/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.session;

import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.exoplatform.services.jcr.impl.core.XASessionImpl;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableDataManager;
import org.exoplatform.services.transaction.TransactionException;

public class TransactionableResourceManager {
    private ConcurrentHashMap<String, ConcurrentLinkedQueue<SoftReference<XASessionImpl>>> txResources = new ConcurrentHashMap();

    public void add(XASessionImpl userSession) {
        ConcurrentLinkedQueue<SoftReference<XASessionImpl>> joinedList = this.txResources.get(userSession.getUserID());
        if (joinedList != null) {
            Iterator<SoftReference<XASessionImpl>> siter = joinedList.iterator();
            while (siter.hasNext()) {
                XASessionImpl xaSession = siter.next().get();
                if (xaSession != null && xaSession.isLive()) continue;
                siter.remove();
            }
            joinedList.add(new SoftReference<XASessionImpl>(userSession));
            this.txResources.putIfAbsent(userSession.getUserID(), joinedList);
        } else {
            ConcurrentLinkedQueue<SoftReference<XASessionImpl>> newJoinedList = new ConcurrentLinkedQueue<SoftReference<XASessionImpl>>();
            ConcurrentLinkedQueue<SoftReference<XASessionImpl>> previous = this.txResources.putIfAbsent(userSession.getUserID(), newJoinedList);
            if (previous != null) {
                previous.add(new SoftReference<XASessionImpl>(userSession));
            } else {
                newJoinedList.add(new SoftReference<XASessionImpl>(userSession));
            }
        }
    }

    public void remove(XASessionImpl userSession) {
        ConcurrentLinkedQueue<SoftReference<XASessionImpl>> joinedList = this.txResources.get(userSession.getUserID());
        if (joinedList != null) {
            Iterator<SoftReference<XASessionImpl>> siter = joinedList.iterator();
            while (siter.hasNext()) {
                XASessionImpl xaSession = siter.next().get();
                if (xaSession != null && xaSession.isLive() && xaSession != userSession) continue;
                siter.remove();
            }
            if (joinedList.size() <= 0) {
                this.txResources.remove(userSession.getUserID());
            }
        }
    }

    public void commit(XASessionImpl userSession, boolean onePhase) throws TransactionException {
        ConcurrentLinkedQueue<SoftReference<XASessionImpl>> joinedList = onePhase ? this.txResources.remove(userSession.getUserID()) : this.txResources.get(userSession.getUserID());
        if (joinedList != null) {
            Iterator<SoftReference<XASessionImpl>> it = joinedList.iterator();
            boolean hasCommitedXASession = false;
            try {
                while (it.hasNext()) {
                    SoftReference<XASessionImpl> sr = it.next();
                    XASessionImpl xaSession = sr.get();
                    if (xaSession != null && xaSession.isLive()) {
                        xaSession.getTransientNodesManager().getTransactManager().commit();
                    }
                    hasCommitedXASession = true;
                }
            }
            catch (TransactionException e) {
                if (onePhase) {
                    while (it.hasNext()) {
                        SoftReference<XASessionImpl> sr = it.next();
                        XASessionImpl xaSession = sr.get();
                        if (xaSession == null || !xaSession.isLive()) continue;
                        xaSession.getTransientNodesManager().getTransactManager().rollback();
                    }
                    if (hasCommitedXASession) {
                        throw new TransactionException(5, (Throwable)e);
                    }
                    throw new TransactionException(6, (Throwable)e);
                }
                throw new TransactionException(104, (Throwable)e);
            }
        }
    }

    public void start(XASessionImpl userSession) {
        ConcurrentLinkedQueue<SoftReference<XASessionImpl>> joinedList = this.txResources.get(userSession.getUserID());
        if (joinedList != null) {
            for (SoftReference<XASessionImpl> sr : joinedList) {
                XASessionImpl xaSession = sr.get();
                if (xaSession == null || !xaSession.isLive()) continue;
                TransactionableDataManager txManager = xaSession.getTransientNodesManager().getTransactManager();
                txManager.start();
            }
        }
    }

    public void rollback(XASessionImpl userSession) {
        ConcurrentLinkedQueue<SoftReference<XASessionImpl>> joinedList = this.txResources.remove(userSession.getUserID());
        if (joinedList != null) {
            for (SoftReference<XASessionImpl> sr : joinedList) {
                XASessionImpl xaSession = sr.get();
                if (xaSession == null || !xaSession.isLive()) continue;
                TransactionableDataManager txManager = xaSession.getTransientNodesManager().getTransactManager();
                txManager.rollback();
            }
        }
    }
}

