/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.jmx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.jmx.ResourceDMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxRegistrationManager {
    private static final Log log = LogFactory.getLog(JmxRegistrationManager.class);
    private static final String GENERAL_PREFIX = System.getProperty("jbosscache.jmx.prefix", "jboss.cache:service=JBossCache");
    public static final String REPLICATED_CACHE_PREFIX = GENERAL_PREFIX + ",cluster=";
    public static final String LOCAL_CACHE_PREFIX = GENERAL_PREFIX + ",uniqueId=";
    public static final String JMX_RESOURCE_KEY = ",jmx-resource=";
    private MBeanServer mBeanServer;
    private String objectNameBase;
    private CacheSPI cacheSpi;

    public JmxRegistrationManager(MBeanServer mBeanServer, Cache cache, ObjectName objectNameBase) {
        this.mBeanServer = mBeanServer;
        this.cacheSpi = (CacheSPI)cache;
        this.processBaseName(objectNameBase);
        log.debug((Object)("Base name is: " + this.objectNameBase));
    }

    public JmxRegistrationManager(MBeanServer mBeanServer, Cache cache, String objectNameBase) {
        this.mBeanServer = mBeanServer;
        this.cacheSpi = (CacheSPI)cache;
        try {
            this.processBaseName(new ObjectName(objectNameBase));
            log.debug((Object)("Base name is: " + this.objectNameBase));
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid Object Name : " + objectNameBase, e);
        }
    }

    public JmxRegistrationManager(Cache cache, ObjectName objectNameBase) {
        this(ManagementFactory.getPlatformMBeanServer(), cache, objectNameBase);
    }

    public JmxRegistrationManager(Cache cache) {
        this(cache, null);
    }

    public void registerAllMBeans() throws CacheException {
        try {
            List<ResourceDMBean> resourceDMBeans = this.getResourceDMBeans();
            for (ResourceDMBean resource : resourceDMBeans) {
                String resourceName = resource.getObjectName();
                ObjectName objectName = new ObjectName(this.getObjectName(resourceName));
                if (this.mBeanServer.isRegistered(objectName)) continue;
                try {
                    this.mBeanServer.registerMBean(resource, objectName);
                }
                catch (InstanceAlreadyExistsException e) {
                    log.warn((Object)"There same instance is already registred!", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new CacheException("Failure while registering mbeans", e);
        }
    }

    public void unregisterAllMBeans() throws CacheException {
        log.trace((Object)"Unregistering jmx resources..");
        try {
            List<ResourceDMBean> resourceDMBeans = this.getResourceDMBeans();
            for (ResourceDMBean resource : resourceDMBeans) {
                String resourceName = resource.getObjectName();
                ObjectName objectName = new ObjectName(this.getObjectName(resourceName));
                if (!this.mBeanServer.isRegistered(objectName)) continue;
                this.mBeanServer.unregisterMBean(objectName);
            }
        }
        catch (Exception e) {
            throw new CacheException("Failure while unregistering mbeans", e);
        }
    }

    private List<ResourceDMBean> getResourceDMBeans() {
        ArrayList<ResourceDMBean> resourceDMBeans = new ArrayList<ResourceDMBean>();
        for (ComponentRegistry.Component component : this.cacheSpi.getComponentRegistry().getRegisteredComponents()) {
            ResourceDMBean resourceDMBean = new ResourceDMBean(component.getInstance());
            if (!resourceDMBean.isManagedResource()) continue;
            resourceDMBeans.add(resourceDMBean);
        }
        return resourceDMBeans;
    }

    private void processBaseName(ObjectName baseName) {
        if (baseName != null) {
            this.objectNameBase = baseName.getCanonicalName();
            return;
        }
        this.objectNameBase = this.cacheSpi.getConfiguration().getCacheMode().equals((Object)Configuration.CacheMode.LOCAL) ? LOCAL_CACHE_PREFIX + Integer.toHexString(System.identityHashCode(this.cacheSpi)) : REPLICATED_CACHE_PREFIX + this.cacheSpi.getConfiguration().getClusterName();
    }

    public String getObjectName(String resourceName) {
        return this.objectNameBase + JMX_RESOURCE_KEY + resourceName;
    }

    public String getObjectNameBase() {
        return this.objectNameBase;
    }
}

