/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.services.rest.opensocial;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlRootElement;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.activitystream.ActivityManager;
import org.exoplatform.social.core.activitystream.model.Activity;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.services.rest.Util;
import org.exoplatform.social.services.rest.opensocial.Like;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="{portalName}/social/activities")
public class ActivitiesRestService
implements ResourceContainer {
    private ActivityManager _activityManager;
    private IdentityManager _identityManager;
    private String portalName_;

    private Activity destroyActivity(String activityId) {
        this._activityManager = this.getActivityManager();
        Activity activity = this._activityManager.getActivity(activityId);
        if (activity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        String rawCommentIds = activity.getExternalId();
        if (rawCommentIds != null) {
            String[] commentIds = rawCommentIds.split(",");
            for (String commentId : commentIds = this.removeItemFromArray(commentIds, "")) {
                try {
                    this._activityManager.deleteActivity(commentId);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        try {
            this._activityManager.deleteActivity(activityId);
        }
        catch (Exception ex) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return activity;
    }

    @POST
    @Path(value="destroy/{activityId}.{format}")
    public Response destroyActivity(@Context UriInfo uriInfo, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        this.portalName_ = Util.getPortalName(uriInfo);
        Activity activity = this.destroyActivity(activityId);
        return Util.getResponse(activity, uriInfo, mediaType, Response.Status.OK);
    }

    private LikeList showLikes(String activityId) {
        LikeList likeList = new LikeList();
        likeList.setActivityId(activityId);
        this._activityManager = this.getActivityManager();
        Activity activity = this._activityManager.getActivity(activityId);
        if (activity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        String[] identityIds = activity.getLikeIdentityIds();
        if (identityIds == null) {
            likeList.setLikes(new ArrayList<Like>());
        } else {
            likeList.setLikes(this.getLikes(identityIds));
        }
        return likeList;
    }

    private LikeList updateLike(String activityId, Like like) throws Exception {
        LikeList likeList = new LikeList();
        likeList.setActivityId(activityId);
        this._activityManager = this.getActivityManager();
        Activity activity = this._activityManager.getActivity(activityId);
        if (activity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        String[] identityIds = activity.getLikeIdentityIds();
        String identityId = like.getIdentityId();
        boolean alreadyLiked = false;
        if (identityId == null) {
            throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
        }
        if (identityIds != null) {
            for (String id : identityIds) {
                if (!id.equals(identityId)) continue;
                alreadyLiked = true;
            }
        }
        if (!alreadyLiked) {
            identityIds = this.addItemToArray(identityIds, identityId);
            activity.setLikeIdentityIds(identityIds);
            try {
                this._activityManager.saveActivity(activity);
            }
            catch (Exception ex) {
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        likeList.setLikes(this.getLikes(identityIds));
        return likeList;
    }

    private LikeList destroyLike(String activityId, String identityId) {
        LikeList likeList = new LikeList();
        likeList.setActivityId(activityId);
        this._activityManager = this.getActivityManager();
        Activity activity = this._activityManager.getActivity(activityId);
        if (activity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        String[] identityIds = activity.getLikeIdentityIds();
        if (identityIds == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        boolean alreadyLiked = true;
        for (String id : identityIds) {
            if (!id.equals(identityId)) continue;
            identityIds = this.removeItemFromArray(identityIds, identityId);
            activity.setLikeIdentityIds(identityIds);
            try {
                this._activityManager.saveActivity(activity);
            }
            catch (Exception ex) {
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
            alreadyLiked = false;
        }
        if (alreadyLiked) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (identityIds == null) {
            likeList.setLikes(new ArrayList<Like>());
        } else {
            likeList.setLikes(this.getLikes(identityIds));
        }
        return likeList;
    }

    @GET
    @Path(value="{activityId}/likes/show.{format}")
    public Response showLikes(@Context UriInfo uriInfo, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        this.portalName_ = Util.getPortalName(uriInfo);
        LikeList likeList = null;
        likeList = this.showLikes(activityId);
        return Util.getResponse(likeList, uriInfo, mediaType, Response.Status.OK);
    }

    @POST
    @Path(value="{activityId}/likes/update.{format}")
    @Consumes(value={"application/json", "application/xml"})
    public Response updateLike(@Context UriInfo uriInfo, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format, Like like) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        this.portalName_ = Util.getPortalName(uriInfo);
        LikeList likeList = null;
        likeList = this.updateLike(activityId, like);
        return Util.getResponse(likeList, uriInfo, mediaType, Response.Status.OK);
    }

    @POST
    @Path(value="{activityId}/likes/destroy/{identityId}.{format}")
    public Response destroyLike(@Context UriInfo uriInfo, @PathParam(value="activityId") String activityId, @PathParam(value="identityId") String identityId, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        this.portalName_ = Util.getPortalName(uriInfo);
        LikeList likeList = null;
        likeList = this.destroyLike(activityId, identityId);
        return Util.getResponse(likeList, uriInfo, mediaType, Response.Status.OK);
    }

    private CommentList showComments(String activityId) {
        CommentList commentList = new CommentList();
        commentList.setActivityId(activityId);
        this._activityManager = this.getActivityManager();
        Activity activity = this._activityManager.getActivity(activityId);
        if (activity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        String rawCommentIds = activity.getExternalId();
        if (rawCommentIds == null) {
            commentList.setComments(new ArrayList<Activity>());
        } else {
            String[] commentIds;
            for (String commentId : commentIds = rawCommentIds.split(",")) {
                if (commentId.length() <= 0) continue;
                commentList.addComment(this._activityManager.getActivity(commentId));
            }
        }
        return commentList;
    }

    private CommentList updateComment(String activityId, Activity comment) {
        CommentList commentList = new CommentList();
        commentList.setActivityId(activityId);
        Activity activity = this._activityManager.getActivity(activityId);
        if (activity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        this._activityManager = this.getActivityManager();
        if (comment.getUserId() == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        comment.setPostedTime(Long.valueOf(System.currentTimeMillis()));
        comment.setExternalId("IS_COMMENT");
        try {
            comment = this._activityManager.saveActivity(comment);
            String rawCommentIds = activity.getExternalId();
            if (rawCommentIds == null) {
                rawCommentIds = "";
            }
            rawCommentIds = rawCommentIds + "," + comment.getId();
            activity.setExternalId(rawCommentIds);
            this._activityManager.saveActivity(activity);
        }
        catch (Exception ex) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        commentList.addComment(comment);
        return commentList;
    }

    private CommentList destroyComment(String activityId, String commentId) {
        CommentList commentList = new CommentList();
        commentList.setActivityId(activityId);
        this._activityManager = this.getActivityManager();
        Activity activity = this._activityManager.getActivity(activityId);
        if (activity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        String rawCommentIds = activity.getExternalId();
        try {
            Activity comment;
            if (rawCommentIds.contains(commentId)) {
                comment = this._activityManager.getActivity(commentId);
                if (activity == null) {
                    throw new WebApplicationException(Response.Status.NOT_FOUND);
                }
            } else {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            commentList.addComment(comment);
            this._activityManager.deleteActivity(commentId);
            commentId = "," + commentId;
            rawCommentIds = rawCommentIds.replace(commentId, "");
            activity.setExternalId(rawCommentIds);
            this._activityManager.saveActivity(activity);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return commentList;
    }

    @GET
    @Path(value="{activityId}/comments/show.{format}")
    public Response showComments(@Context UriInfo uriInfo, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        this.portalName_ = Util.getPortalName(uriInfo);
        CommentList commentList = null;
        commentList = this.showComments(activityId);
        return Util.getResponse(commentList, uriInfo, mediaType, Response.Status.OK);
    }

    @POST
    @Path(value="{activityId}/comments/update.{format}")
    @Consumes(value={"application/json", "application/xml"})
    public Response updateComment(@Context UriInfo uriInfo, @PathParam(value="activityId") String activityId, @PathParam(value="format") String format, Activity comment) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        this.portalName_ = Util.getPortalName(uriInfo);
        CommentList commentList = null;
        commentList = this.updateComment(activityId, comment);
        return Util.getResponse(commentList, uriInfo, mediaType, Response.Status.OK);
    }

    @POST
    @Path(value="{activityId}/comments/destroy/{commentId}.{format}")
    public Response destroyComment(@Context UriInfo uriInfo, @PathParam(value="activityId") String activityId, @PathParam(value="commentId") String commentId, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        this.portalName_ = Util.getPortalName(uriInfo);
        CommentList commentList = null;
        commentList = this.destroyComment(activityId, commentId);
        return Util.getResponse(commentList, uriInfo, mediaType, Response.Status.OK);
    }

    private ActivityManager getActivityManager() {
        if (this._activityManager == null) {
            PortalContainer portalContainer = (PortalContainer)ExoContainerContext.getContainerByName((String)this.portalName_);
            this._activityManager = (ActivityManager)portalContainer.getComponentInstanceOfType(ActivityManager.class);
        }
        return this._activityManager;
    }

    private IdentityManager getIdentityManager() {
        if (this._identityManager == null) {
            PortalContainer portalContainer = (PortalContainer)ExoContainerContext.getContainerByName((String)this.portalName_);
            this._identityManager = (IdentityManager)portalContainer.getComponentInstanceOfType(IdentityManager.class);
        }
        return this._identityManager;
    }

    private List<Like> getLikes(String[] identityIds) {
        ArrayList<Like> likes = new ArrayList<Like>();
        this._identityManager = this.getIdentityManager();
        try {
            for (String identityId : identityIds) {
                Identity identity = this._identityManager.getIdentity(identityId);
                Profile profile = identity.getProfile();
                String username = (String)profile.getProperty("username");
                String fullName = profile.getFullName();
                String thumbnail = profile.getAvatarImageSource((PortalContainer)ExoContainerContext.getContainerByName((String)this.portalName_));
                Like like = new Like();
                like.setIdentityId(identityId);
                like.setUsername(username);
                like.setFullName(fullName);
                like.setThumbnail(thumbnail);
                likes.add(like);
            }
        }
        catch (Exception ex) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        return likes;
    }

    private String[] removeItemFromArray(String[] array, String str) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(array));
        list.remove(str);
        if (list.size() > 0) {
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    private String[] addItemToArray(String[] array, String str) {
        ArrayList<String> list = new ArrayList<String>();
        if (array != null && array.length > 0) {
            list.addAll(Arrays.asList(array));
            list.add(str);
            return list.toArray(new String[list.size()]);
        }
        return new String[]{str};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlRootElement
    public static class CommentList {
        private String _activityId;
        private List<Activity> _comments;

        public void setActivityId(String activityId) {
            this._activityId = activityId;
        }

        public String getActivityId() {
            return this._activityId;
        }

        public void setComments(List<Activity> comments) {
            this._comments = comments;
        }

        public List<Activity> getComments() {
            return this._comments;
        }

        public void addComment(Activity activity) {
            if (this._comments == null) {
                this._comments = new ArrayList<Activity>();
            }
            this._comments.add(activity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlRootElement
    public static class LikeList {
        private String _activityId;
        private List<Like> _likes;

        public void setActivityId(String activityId) {
            this._activityId = activityId;
        }

        public String getActivityId() {
            return this._activityId;
        }

        public void setLikes(List<Like> likes) {
            this._likes = likes;
        }

        public List<Like> getLikes() {
            return this._likes;
        }

        public void addLike(Like like) {
            if (this._likes == null) {
                this._likes = new ArrayList<Like>();
            }
            this._likes.add(like);
        }
    }
}

