/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.library;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    SecurityActions() {
    }

    public static void setThreadContextClassLoader(ClassLoader loader) {
        if (System.getSecurityManager() == null) {
            SetTcl.NON_PRIVILEGED.setContextClassLoader(loader);
        } else {
            SetTcl.PRIVILEGED.setContextClassLoader(loader);
        }
    }

    public static ClassLoader getThreadContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return GetTcl.NON_PRIVILEGED.getContextClassLoader();
        }
        return GetTcl.PRIVILEGED.getContextClassLoader();
    }

    public static ClassLoader getClassLoader(Class clazz) {
        if (System.getSecurityManager() == null) {
            return GetClassLoader.NON_PRIVILEGED.getClassLoader(clazz);
        }
        return GetClassLoader.PRIVILEGED.getClassLoader(clazz);
    }

    static interface GetClassLoader {
        public static final GetClassLoader PRIVILEGED = new GetClassLoader(){

            public ClassLoader getClassLoader(final Class clazz) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return clazz.getClassLoader();
                    }
                });
            }
        };
        public static final GetClassLoader NON_PRIVILEGED = new GetClassLoader(){

            public ClassLoader getClassLoader(Class clazz) {
                return clazz.getClassLoader();
            }
        };

        public ClassLoader getClassLoader(Class var1);
    }

    static interface GetTcl {
        public static final GetTcl PRIVILEGED = new GetTcl(){

            public ClassLoader getContextClassLoader() {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
        };
        public static final GetTcl NON_PRIVILEGED = new GetTcl(){

            public ClassLoader getContextClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }
        };

        public ClassLoader getContextClassLoader();
    }

    static interface SetTcl {
        public static final SetTcl PRIVILEGED = new SetTcl(){

            public void setContextClassLoader(final ClassLoader loader) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(loader);
                        return null;
                    }
                });
            }
        };
        public static final SetTcl NON_PRIVILEGED = new SetTcl(){

            public void setContextClassLoader(ClassLoader loader) {
                Thread.currentThread().setContextClassLoader(loader);
            }
        };

        public void setContextClassLoader(ClassLoader var1);
    }
}

