/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.NoSuchEJBException;
import org.jboss.ejb3.cache.Identifiable;
import org.jboss.ejb3.cache.ObjectStore;
import org.jboss.ejb3.cache.PassivatingCache;
import org.jboss.ejb3.cache.PassivationManager;
import org.jboss.ejb3.cache.StatefulObjectFactory;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePassivatingCache<T extends Identifiable & Serializable>
implements PassivatingCache<T> {
    private static final Logger log = Logger.getLogger(SimplePassivatingCache.class);
    private StatefulObjectFactory<T> factory;
    private PassivationManager<T> passivationManager;
    private ObjectStore<T> store;
    private Map<Object, Entry> cache;
    private int sessionTimeout = -1;
    private String name;
    private Thread sessionTimeoutTask;

    public SimplePassivatingCache(StatefulObjectFactory<T> factory, PassivationManager<T> passivationManager, ObjectStore<T> store) {
        assert (factory != null) : "factory is null";
        assert (passivationManager != null) : "passivationManager is null";
        assert (store != null) : "store is null";
        this.factory = factory;
        this.passivationManager = passivationManager;
        this.store = store;
        this.cache = new HashMap<Object, Entry>();
    }

    protected Entry activate(Object key) {
        T obj = this.store.load(key);
        if (obj == null) {
            return null;
        }
        this.passivationManager.postActivate((Serializable)obj);
        Entry entry = new Entry(this, obj);
        this.cache.put(key, entry);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T create(Class<?>[] initTypes, Object[] initValues) {
        Identifiable obj = (Identifiable)this.factory.create(initTypes, initValues);
        Entry entry = new Entry(this, obj);
        Map<Object, Entry> map = this.cache;
        synchronized (map) {
            this.cache.put(obj.getId(), entry);
        }
        return (T)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(Object key) throws NoSuchEJBException {
        Map<Object, Entry> map = this.cache;
        synchronized (map) {
            Entry entry = this.cache.get(key);
            if (entry == null && (entry = this.activate(key)) != null) {
                return entry.obj;
            }
            if (entry == null) {
                throw new NoSuchEJBException(String.valueOf(key));
            }
            if (entry.state != EntryState.READY) {
                throw new IllegalStateException("entry " + key + " is not ready");
            }
            entry.state = EntryState.IN_USE;
            entry.lastUsed = System.currentTimeMillis();
            return entry.obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void passivate(Object key) {
        log.trace((Object)("passivate " + key));
        Map<Object, Entry> map = this.cache;
        synchronized (map) {
            Entry entry = this.cache.get(key);
            if (entry == null) {
                throw new IllegalArgumentException("entry " + key + " not found in cache " + this);
            }
            if (entry.state == EntryState.IN_USE) {
                throw new IllegalStateException("entry " + entry + " is in use");
            }
            this.passivationManager.prePassivate((Serializable)entry.obj);
            this.store.store(entry.obj);
            this.cache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T peek(Object key) throws NoSuchEJBException {
        Map<Object, Entry> map = this.cache;
        synchronized (map) {
            Entry entry = this.cache.get(key);
            if (entry == null && (entry = this.activate(key)) != null) {
                entry.state = EntryState.READY;
            }
            if (entry == null) {
                throw new NoSuchEJBException(String.valueOf(key));
            }
            return entry.obj;
        }
    }

    @Override
    public void release(T obj) {
        this.releaseByKey(obj.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseByKey(Object key) {
        Map<Object, Entry> map = this.cache;
        synchronized (map) {
            Entry entry = this.cache.get(key);
            if (entry == null) {
                throw new IllegalStateException("object " + key + " not from this cache");
            }
            if (entry.state != EntryState.IN_USE) {
                throw new IllegalStateException("entry " + entry + " is not in use");
            }
            entry.state = EntryState.READY;
            entry.lastUsed = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Object key) {
        Entry entry;
        Map<Object, Entry> map = this.cache;
        synchronized (map) {
            entry = this.cache.remove(key);
            if (entry == null) {
                entry = this.activate(key);
                if (entry == null) {
                    throw new NoSuchEJBException(String.valueOf(key));
                }
                entry.state = EntryState.READY;
            }
            if (entry.state != EntryState.READY) {
                throw new IllegalStateException("entry " + entry + " is not ready");
            }
        }
        if (entry != null) {
            this.factory.destroy(entry.obj);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSessionTimeout(int sessionTimeout) {
        assert (sessionTimeout >= 0) : "sessionTimeout must be >= 0";
        this.sessionTimeout = sessionTimeout;
    }

    @Override
    public void start() {
        assert (this.name != null) : "name has not been set";
        assert (this.sessionTimeout != -1) : "sessionTimeout has not been set";
        if (this.sessionTimeout > 0) {
            this.sessionTimeoutTask = new SessionTimeoutThread("Passivation Thread - " + this.name);
            this.sessionTimeoutTask.start();
        }
    }

    @Override
    public void stop() {
        if (this.sessionTimeoutTask != null) {
            this.sessionTimeoutTask.interrupt();
            try {
                this.sessionTimeoutTask.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.sessionTimeoutTask.isAlive()) {
                log.warn((Object)("Failed to stop " + this.sessionTimeoutTask));
            }
        }
    }

    private class SessionTimeoutThread
    extends Thread {
        public SessionTimeoutThread(String name) {
            super(name);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    Thread.sleep(1000L);
                    Map map = SimplePassivatingCache.this.cache;
                    synchronized (map) {
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        long then = System.currentTimeMillis() - (long)(SimplePassivatingCache.this.sessionTimeout * 1000);
                        Iterator it = SimplePassivatingCache.this.cache.values().iterator();
                        while (it.hasNext()) {
                            Entry entry = (Entry)it.next();
                            if (then < entry.lastUsed || entry.state == EntryState.IN_USE) continue;
                            try {
                                SimplePassivatingCache.this.passivationManager.prePassivate((Serializable)entry.obj);
                            }
                            catch (Throwable t) {
                                log.warn((Object)("pre passivate failed for " + entry.obj), t);
                            }
                            SimplePassivatingCache.this.store.store(entry.obj);
                            it.remove();
                        }
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry {
        long lastUsed;
        T obj;
        EntryState state;
        final /* synthetic */ SimplePassivatingCache this$0;

        Entry(T obj) {
            this.this$0 = var1_1;
            assert (obj != null) : "obj is null";
            this.lastUsed = System.currentTimeMillis();
            this.obj = obj;
            this.state = EntryState.IN_USE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EntryState {
        READY,
        IN_USE;

    }
}

