/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.space;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.social.space.SpaceAttachment;

public class Space {
    private String id;
    private String name;
    private String groupId;
    private String app;
    private String parent;
    private String description;
    private String tag;
    private String[] pendingUsers;
    private String[] invitedUsers;
    private String type;
    private String url;
    private String visibility;
    private String registration;
    private String priority;
    private SpaceAttachment spaceAttachment;
    public static final String ACTIVE_STATUS = "active";
    public static final String DEACTIVE_STATUS = "deactive";
    public static final String INSTALL_STATUS = "installed";
    public static final String PUBLIC = "public";
    public static final String PRIVATE = "private";
    public static final String HIDDEN = "hidden";
    public static final String OPEN = "open";
    public static final String VALIDATION = "validation";
    public static final String CLOSE = "close";
    public static final String HIGH_PRIORITY = "1";
    public static final String INTERMEDIATE_PRIORITY = "2";
    public static final String LOW_PRIORITY = "3";

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getApp() {
        return this.app;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public String getParent() {
        return this.parent;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public void setPendingUsers(String[] pendingUsers) {
        this.pendingUsers = pendingUsers;
    }

    public String[] getPendingUsers() {
        return this.pendingUsers;
    }

    public void setInvitedUsers(String[] invitedUsers) {
        this.invitedUsers = invitedUsers;
    }

    public String[] getInvitedUsers() {
        return this.invitedUsers;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getShortName() {
        return this.groupId.substring(this.groupId.lastIndexOf("/") + 1);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String getRegistration() {
        return this.registration;
    }

    public void setRegistration(String registration) {
        this.registration = registration;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public void setSpaceAttachment(SpaceAttachment spaceAttachment) {
        this.spaceAttachment = spaceAttachment;
    }

    public SpaceAttachment getSpaceAttachment() {
        return this.spaceAttachment;
    }

    public String getImageSource() throws Exception {
        SpaceAttachment spaceAttachment = this.getSpaceAttachment();
        if (spaceAttachment != null) {
            return "/" + PortalContainer.getCurrentRestContextName() + "/jcr/" + this.getRepository() + "/" + spaceAttachment.getWorkspace() + spaceAttachment.getDataPath() + "/?rnd=" + System.currentTimeMillis();
        }
        return null;
    }

    private String getRepository() throws Exception {
        PortalContainer portalContainer = PortalContainer.getInstance();
        RepositoryService rService = (RepositoryService)portalContainer.getComponentInstanceOfType(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }
}

