/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javax.context.ApplicationScoped;
import javax.context.CreationalContext;
import javax.decorator.Decorator;
import javax.event.Observes;
import javax.inject.CreationException;
import javax.inject.DefinitionException;
import javax.interceptor.Interceptor;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.proxy.EnterpriseBeanInstance;
import org.jboss.webbeans.bean.proxy.EnterpriseBeanProxyMethodHandler;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.context.DependentStorageRequest;
import org.jboss.webbeans.ejb.InternalEjbDescriptor;
import org.jboss.webbeans.ejb.api.SessionObjectReference;
import org.jboss.webbeans.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.webbeans.ejb.spi.EjbServices;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.util.Proxies;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseBean<T>
extends AbstractClassBean<T> {
    private final Log log = Logging.getLog(EnterpriseBean.class);
    private InternalEjbDescriptor<T> ejbDescriptor;
    private Class<T> proxyClass;
    private EnterpriseBean<?> specializedBean;

    public static <T> EnterpriseBean<T> of(AnnotatedClass<T> clazz, ManagerImpl manager, BeanDeployerEnvironment environment) {
        return new EnterpriseBean<T>(clazz, manager, environment);
    }

    protected EnterpriseBean(AnnotatedClass<T> type, ManagerImpl manager, BeanDeployerEnvironment environment) {
        super(type, manager);
        this.initType();
        Iterable ejbDescriptors = environment.getEjbDescriptors().get(this.getType());
        if (ejbDescriptors == null) {
            throw new DefinitionException("Not an EJB " + this.toString());
        }
        for (InternalEjbDescriptor ejbDescriptor : ejbDescriptors) {
            if (this.ejbDescriptor == null) {
                this.ejbDescriptor = ejbDescriptor;
                continue;
            }
            throw new RuntimeException("TODO Multiple EJBs have the same bean class! " + this.getType());
        }
        this.initTypes();
        this.initBindings();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (!this.isInitialized()) {
            super.initialize(environment);
            this.initProxyClass();
            this.initInjectionPoints();
            this.checkEJBTypeAllowed();
            this.checkConflictingRoles();
            this.checkObserverMethods();
        }
    }

    @Override
    protected void initTypes() {
        HashSet<Class> types = new HashSet<Class>();
        types = new LinkedHashSet();
        types.add(Object.class);
        for (BusinessInterfaceDescriptor<?> businessInterfaceDescriptor : this.ejbDescriptor.getLocalBusinessInterfaces()) {
            types.add(businessInterfaceDescriptor.getInterface());
        }
        this.types = types;
    }

    protected void initProxyClass() {
        Class proxyClass;
        LinkedHashSet<Type> types = new LinkedHashSet<Type>(this.getTypes());
        types.add((Type)((Object)EnterpriseBeanInstance.class));
        ProxyFactory proxyFactory = Proxies.getProxyFactory(types);
        this.proxyClass = proxyClass = proxyFactory.createClass();
    }

    protected void checkConflictingRoles() {
        if (this.getType().isAnnotationPresent(Interceptor.class)) {
            throw new DefinitionException("Enterprise beans cannot be interceptors");
        }
        if (this.getType().isAnnotationPresent(Decorator.class)) {
            throw new DefinitionException("Enterprise beans cannot be decorators");
        }
    }

    @Override
    protected void checkScopeAllowed() {
        super.checkScopeAllowed();
        if (this.ejbDescriptor.isStateless() && !this.isDependent()) {
            throw new DefinitionException("Scope " + this.getScopeType() + " is not allowed on stateless enterpise beans for " + this.getType() + ". Only @Dependent is allowed on stateless enterprise beans");
        }
        if (this.ejbDescriptor.isSingleton() && !this.isDependent() && !this.getScopeType().equals(ApplicationScoped.class)) {
            throw new DefinitionException("Scope " + this.getScopeType() + " is not allowed on singleton enterpise beans for " + this.getType() + ". Only @Dependent or @ApplicationScoped is allowed on singleton enterprise beans");
        }
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        super.preSpecialize(environment);
        if (!environment.getEjbDescriptors().containsKey(this.getAnnotatedItem().getSuperclass().getRawType())) {
            throw new DefinitionException("Annotation defined specializing EJB must have EJB superclass");
        }
    }

    @Override
    protected void specialize(BeanDeployerEnvironment environment) {
        if (environment.getClassBean(this.getAnnotatedItem().getSuperclass()) == null) {
            throw new IllegalStateException(this.toString() + " does not specialize a bean");
        }
        AbstractClassBean<?> specializedBean = environment.getClassBean(this.getAnnotatedItem().getSuperclass());
        if (!(specializedBean instanceof EnterpriseBean)) {
            throw new IllegalStateException(this.toString() + " doesn't have a session bean as a superclass " + specializedBean);
        }
        this.specializedBean = (EnterpriseBean)specializedBean;
    }

    public T create(CreationalContext<T> creationalContext) {
        try {
            DependentContext.instance().setActive(true);
            T instance = this.proxyClass.newInstance();
            creationalContext.push(instance);
            ((ProxyObject)instance).setHandler((MethodHandler)new EnterpriseBeanProxyMethodHandler(this));
            this.log.trace((Object)"Enterprise bean instance created for bean {0}", new Object[]{this});
            T t = instance;
            return t;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not instantiate enterprise proxy for " + this.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not access bean correctly when creating enterprise proxy for " + this.toString(), e);
        }
        catch (Exception e) {
            throw new CreationException("could not find the EJB in JNDI " + this.proxyClass, (Throwable)e);
        }
        finally {
            DependentContext.instance().setActive(false);
        }
    }

    public void destroy(T instance) {
        if (instance == null) {
            throw new IllegalArgumentException("instance to destroy cannot be null");
        }
        if (!(instance instanceof EnterpriseBeanInstance)) {
            throw new IllegalArgumentException("Cannot destroy session bean instance not created by the container");
        }
        EnterpriseBeanInstance enterpiseBeanInstance = (EnterpriseBeanInstance)instance;
        if (enterpiseBeanInstance.isDestroyed()) {
            return;
        }
    }

    private void checkEJBTypeAllowed() {
        if (this.ejbDescriptor.isMessageDriven()) {
            throw new DefinitionException("Message Driven Beans can't be Web Beans");
        }
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.getName() == null) {
            buffer.append(" unnamed enterprise bean");
        } else {
            buffer.append(" enterprise bean '" + this.getName() + "'");
        }
        buffer.append(" [" + this.getType().getName() + "] ");
        buffer.append("API types " + this.getTypes() + ", binding types " + this.getBindings());
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postConstruct(T instance) {
        DependentStorageRequest dependentStorageRequest = DependentStorageRequest.of(this.dependentInstancesStore, instance);
        try {
            CreationalContext creationalContext = new CreationalContext<T>(){

                public void push(T incompleteInstance) {
                }
            };
            DependentContext.instance().startCollectingDependents(dependentStorageRequest);
            DependentContext.instance().setActive(true);
            this.injectBoundFields(instance, creationalContext);
            this.callInitializers(instance, creationalContext);
        }
        finally {
            DependentContext.instance().stopCollectingDependents(dependentStorageRequest);
            DependentContext.instance().setActive(false);
        }
    }

    public void preDestroy(T instance) {
        this.dependentInstancesStore.destroyDependentInstances(instance);
    }

    @Override
    protected void initSerializable() {
        this._serializable = true;
    }

    public InternalEjbDescriptor<T> getEjbDescriptor() {
        return this.ejbDescriptor;
    }

    public boolean canCallRemoveMethods() {
        return this.getEjbDescriptor().isStateful() && this.isDependent();
    }

    @Override
    public AbstractBean<?, ?> getSpecializedBean() {
        return this.specializedBean;
    }

    protected void checkObserverMethods() {
        for (AnnotatedMethod<?> method : this.annotatedItem.getDeclaredMethodsWithAnnotatedParameters(Observes.class)) {
            if (method.isStatic() || this.isMethodExistsOnTypes(method)) continue;
            throw new DefinitionException("Observer method must be static or business method: " + method + " on " + this.getAnnotatedItem());
        }
    }

    public boolean isMethodExistsOnTypes(AnnotatedMethod<?> method) {
        for (Type type : this.getTypes()) {
            if (!(type instanceof Class)) continue;
            for (Method m : ((Class)type).getMethods()) {
                if (!method.getName().equals(m.getName()) || !Arrays.equals(method.getParameterTypesAsArray(), m.getParameterTypes())) continue;
                return true;
            }
        }
        return false;
    }

    public SessionObjectReference createReference() {
        return ((EjbServices)this.manager.getServices().get(EjbServices.class)).resolveEjb(this.getEjbDescriptor());
    }
}

