/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;

public class PDFToImage {
    private static final String PASSWORD = "-password";
    private static final String START_PAGE = "-startPage";
    private static final String END_PAGE = "-endPage";
    private static final String IMAGE_TYPE = "-imageType";
    private static final String OUTPUT_PREFIX = "-outputPrefix";

    private PDFToImage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String password = "";
        String pdfFile = null;
        String outputPrefix = null;
        String imageType = "jpg";
        int startPage = 1;
        int endPage = Integer.MAX_VALUE;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    PDFToImage.usage();
                }
                password = args[i];
                continue;
            }
            if (args[i].equals(START_PAGE)) {
                if (++i >= args.length) {
                    PDFToImage.usage();
                }
                startPage = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals(END_PAGE)) {
                if (++i >= args.length) {
                    PDFToImage.usage();
                }
                endPage = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals(IMAGE_TYPE)) {
                imageType = args[++i];
                continue;
            }
            if (args[i].equals(OUTPUT_PREFIX)) {
                outputPrefix = args[++i];
                continue;
            }
            if (pdfFile != null) continue;
            pdfFile = args[i];
        }
        if (pdfFile == null) {
            PDFToImage.usage();
        } else {
            if (outputPrefix == null) {
                outputPrefix = pdfFile.substring(0, pdfFile.lastIndexOf(46));
            }
            PDDocument document = null;
            try {
                document = PDDocument.load(pdfFile);
                if (document.isEncrypted()) {
                    try {
                        document.decrypt(password);
                    }
                    catch (InvalidPasswordException e) {
                        if (args.length == 4) {
                            System.err.println("Error: The supplied password is incorrect.");
                            System.exit(2);
                        }
                        System.err.println("Error: The document is encrypted.");
                        PDFToImage.usage();
                    }
                }
                List pages = document.getDocumentCatalog().getAllPages();
                for (int i = startPage - 1; i < endPage && i < pages.size(); ++i) {
                    Object var20_21;
                    ImageInputStream output = null;
                    ImageWriter imageWriter = null;
                    try {
                        PDPage page = (PDPage)pages.get(i);
                        BufferedImage image = page.convertToImage();
                        String fileName = outputPrefix + (i + 1) + "." + imageType;
                        System.out.println("Writing:" + fileName);
                        output = ImageIO.createImageOutputStream(new File(fileName));
                        boolean foundWriter = false;
                        Iterator<ImageWriter> writerIter = ImageIO.getImageWritersByFormatName(imageType);
                        while (writerIter.hasNext() && !foundWriter) {
                            try {
                                imageWriter = writerIter.next();
                                ImageWriteParam writerParams = imageWriter.getDefaultWriteParam();
                                if (writerParams.canWriteCompressed()) {
                                    writerParams.setCompressionMode(2);
                                    writerParams.setCompressionQuality(1.0f);
                                }
                                imageWriter.setOutput(output);
                                imageWriter.write(null, new IIOImage(image, null, null), writerParams);
                                foundWriter = true;
                            }
                            catch (IIOException io) {}
                            continue;
                            finally {
                                if (imageWriter == null) continue;
                                imageWriter.dispose();
                            }
                        }
                        if (!foundWriter) {
                            throw new RuntimeException("Error: no writer found for image type '" + imageType + "'");
                        }
                        var20_21 = null;
                        if (output == null) continue;
                    }
                    catch (Throwable throwable) {
                        var20_21 = null;
                        if (output != null) {
                            output.flush();
                            output.close();
                        }
                        throw throwable;
                    }
                    output.flush();
                    output.close();
                    {
                        continue;
                    }
                }
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.pdfbox.PDFToImage [OPTIONS] <PDF file>\n  -password  <password>          Password to decrypt document\n  -imageType <image type>        (" + PDFToImage.getImageFormats() + ")\n" + "  -outputPrefix <output prefix>  Filename prefix for image files\n" + "  -startPage <number>          The first page to start extraction(1 based)\n" + "  -endPage <number>            The last page to extract(inclusive)\n" + "  <PDF file>                   The PDF document to use\n");
        System.exit(1);
    }

    private static String getImageFormats() {
        StringBuffer retval = new StringBuffer();
        String[] formats = ImageIO.getReaderFormatNames();
        for (int i = 0; i < formats.length; ++i) {
            retval.append(formats[i]);
            if (i + 1 >= formats.length) continue;
            retval.append(",");
        }
        return retval.toString();
    }
}

