/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.resource;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityResult;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.QueryHint;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.event.EventDefinition;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.CreateDeletePolicy;
import org.rhq.core.domain.resource.ProcessScan;
import org.rhq.core.domain.resource.ProductVersion;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceCreationDataType;
import org.rhq.core.domain.resource.ResourceSubCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="RHQ_RESOURCE_TYPE")
@SequenceGenerator(name="SEQ", sequenceName="RHQ_RESOURCE_TYPE_ID_SEQ")
@NamedQueries(value={@NamedQuery(name="ResourceType.findByName", query="SELECT rt FROM ResourceType AS rt WHERE LOWER(rt.name) = LOWER(:name)"), @NamedQuery(name="ResourceType.findByPlugin", query="SELECT rt FROM ResourceType AS rt WHERE rt.plugin = :plugin"), @NamedQuery(name="ResourceType.findByNameAndPlugin", hints={@QueryHint(name="org.hibernate.cacheable", value="true"), @QueryHint(name="org.hibernate.cacheRegion", value="metadata")}, query="SELECT rt FROM ResourceType AS rt WHERE LOWER(rt.name) = LOWER(:name) AND rt.plugin = :plugin"), @NamedQuery(name="ResourceType.findAll", query="SELECT rt FROM ResourceType AS rt"), @NamedQuery(name="ResourceType.findByParentAndName", query="SELECT rt FROM ResourceType AS rt WHERE :parent MEMBER OF rt.parentResourceTypes AND rt.name = :name"), @NamedQuery(name="ResourceType.findRootTypeByName", query="SELECT rt FROM ResourceType AS rt WHERE rt.parentResourceTypes IS EMPTY AND rt.name = :name"), @NamedQuery(name="ResourceType.findChildren", query="SELECT res.resourceType FROM Resource res, IN (res.implicitGroups) g, IN (g.roles) r, IN (r.subjects) s WHERE s = :subject AND res.parentResource = :parent"), @NamedQuery(name="ResourceType.findChildren_admin", query="SELECT res.resourceType FROM Resource res WHERE res.parentResource = :parent"), @NamedQuery(name="ResourceType.findChildrenByParent", query="SELECT DISTINCT rt FROM ResourceType AS rt JOIN FETCH rt.parentResourceTypes AS pa WHERE pa IN (:resourceType)"), @NamedQuery(name="ResourceType.findAllTemplateCountComposites", query="SELECT new org.rhq.core.domain.resource.composite.ResourceTypeTemplateCountComposite(  rt,  (SELECT COUNT(md) FROM MeasurementDefinition AS md WHERE md.resourceType = rt AND md.defaultOn = TRUE),   (SELECT COUNT(md) FROM MeasurementDefinition AS md WHERE md.resourceType = rt AND md.defaultOn = FALSE),   (SELECT COUNT(ad) FROM AlertDefinition AS ad WHERE ad.resourceType = rt AND ad.deleted = FALSE AND ad.enabled = TRUE),   (SELECT COUNT(ad) FROM AlertDefinition AS ad WHERE ad.resourceType = rt AND ad.deleted = FALSE AND ad.enabled = FALSE) )FROM ResourceType AS rt"), @NamedQuery(name="ResourceType.findByCategory", query="SELECT rt FROM ResourceType AS rt WHERE rt.category = :category"), @NamedQuery(name="ResourceType.findUtilizedByCategory", query="SELECT DISTINCT res.resourceType FROM Resource res, IN (res.implicitGroups) g, IN (g.roles) r, IN (r.subjects) s WHERE s = :subject AND res.resourceType.category = :category AND (UPPER(res.name) LIKE :nameFilter OR :nameFilter is null) AND (:inventoryStatus = res.inventoryStatus OR :inventoryStatus is null) ORDER BY res.resourceType.name "), @NamedQuery(name="ResourceType.findUtilizedByCategory_admin", query="SELECT DISTINCT res.resourceType FROM Resource res WHERE res.resourceType.category = :category AND (UPPER(res.name) LIKE :nameFilter OR :nameFilter is null) AND (:inventoryStatus = res.inventoryStatus OR :inventoryStatus is null) ORDER BY res.resourceType.name "), @NamedQuery(name="ResourceType.findUtilizedChildrenByCategory", query="SELECT DISTINCT res.resourceType FROM Resource res, IN (res.implicitGroups) g, IN (g.roles) r, IN (r.subjects) s WHERE s = :subject AND res.parentResource = :parentResource AND res.resourceType.category = :category AND (:inventoryStatus = res.inventoryStatus OR :inventoryStatus is null) "), @NamedQuery(name="ResourceType.findUtilizedChildrenByCategory_admin", query="SELECT DISTINCT res.resourceType FROM Resource res WHERE res.parentResource = :parentResource AND res.resourceType.category = :category AND (:inventoryStatus = res.inventoryStatus OR :inventoryStatus is null) "), @NamedQuery(name="ResourceType.findByResourceGroup", query="SELECT DISTINCT rg.resourceType FROM ResourceGroup AS rg, IN (rg.roles) r, IN (r.subjects) s WHERE s = :subject "), @NamedQuery(name="ResourceType.findByResourceGroup_admin", query="SELECT DISTINCT rg.resourceType FROM ResourceGroup AS rg "), @NamedQuery(name="ResourceType.getExplicitResourceTypeCountsByGroup", query="SELECT type.id, type.name, COUNT(type.id) FROM ResourceGroup rg JOIN rg.explicitResources res JOIN res.resourceType type WHERE rg.id = :groupId GROUP BY type.id, type.name "), @NamedQuery(name="ResourceType.getImplicitResourceTypeCountsByGroup", query="SELECT type.id, type.name, COUNT(type.id) FROM ResourceGroup rg JOIN rg.implicitResources res JOIN res.resourceType type WHERE rg.id = :groupId GROUP BY type.id, type.name "), @NamedQuery(name="ResourceType.findBySubCategory", query="SELECT rt FROM ResourceType rt WHERE rt.subCategory = :subCategory"), @NamedQuery(name="ResourceType.findByIdWithAllOperations", query="SELECT DISTINCT rt FROM ResourceType rt LEFT JOIN FETCH rt.operationDefinitions def LEFT JOIN FETCH def.parametersConfigurationDefinition LEFT JOIN FETCH def.resultsConfigurationDefinition WHERE rt.id = :id"), @NamedQuery(name="ResourceType.findResourceFacets", query="SELECT new org.rhq.core.domain.resource.composite.ResourceFacets        (          rt.id,         (SELECT COUNT(metricDef) FROM rt.metricDefinitions metricDef),         (SELECT COUNT(eventDef) FROM rt.eventDefinitions eventDef),         (SELECT COUNT(pluginConfig) FROM rt.pluginConfigurationDefinition pluginConfig),         (SELECT COUNT(resConfig) FROM rt.resourceConfigurationDefinition resConfig),         (SELECT COUNT(operationDef) FROM rt.operationDefinitions operationDef),         (SELECT COUNT(packageType) FROM rt.packageTypes packageType),         (SELECT COUNT(metricDef) FROM rt.metricDefinitions metricDef WHERE metricDef.dataType = 3)       )   FROM ResourceType rt  WHERE ( rt.id = :resourceTypeId OR :resourceTypeId IS NULL )")})
@NamedNativeQueries(value={@NamedNativeQuery(name="ResourceType.findChildrenByCategory", query="(SELECT crt.id, crt.name, crt.category, crt.creation_data_type, crt.create_delete_policy, crt.singleton, crt.supports_manual_add, crt.description, crt.plugin, crt.ctime, crt.mtime, crt.subcategory_id, crt.plugin_config_def_id, crt.res_config_def_id FROM RHQ_resource_type crt, RHQ_resource res, RHQ_resource_type rt, RHQ_resource_type_parents rtp WHERE res.id = ? AND res.resource_type_id = rt.id AND rt.id = rtp.parent_resource_type_id AND rtp.resource_type_id = crt.id AND crt.category = ? UNION SELECT DISTINCT crt2.id, crt2.name, crt2.category, crt2.creation_data_type, crt2.create_delete_policy, crt2.singleton, crt2.supports_manual_add, crt2.description, crt2.plugin, crt2.ctime, crt2.mtime, crt2.subcategory_id, crt2.plugin_config_def_id, crt2.res_config_def_id FROM RHQ_resource_type crt2 WHERE 1 = (SELECT COUNT(res2.id) FROM RHQ_resource res2, RHQ_resource_type rt2 WHERE res2.id = ? AND res2.resource_type_id = rt2.id AND rt2.category = 'PLATFORM') AND 0 = (SELECT COUNT(rtp2.resource_type_id) FROM RHQ_resource_type_parents rtp2 WHERE rtp2.resource_type_id = crt2.id) AND crt2.category = ?  ) ORDER BY name", resultSetMapping="ResourceType.findChildrenByCategoryMapping"), @NamedNativeQuery(name="ResourceType.findChildrenByCategory_admin", query="(SELECT crt.id, crt.name, crt.category, crt.creation_data_type, crt.create_delete_policy, crt.singleton, crt.supports_manual_add, crt.description, crt.plugin, crt.ctime, crt.mtime, crt.subcategory_id, crt.plugin_config_def_id, crt.res_config_def_id FROM RHQ_resource_type crt, RHQ_resource res, RHQ_resource_type rt, RHQ_resource_type_parents rtp WHERE res.id = ? AND res.resource_type_id = rt.id AND rt.id = rtp.parent_resource_type_id AND rtp.resource_type_id = crt.id AND crt.category = ? UNION (SELECT DISTINCT crt2.id, crt2.name, crt2.category, crt2.creation_data_type, crt2.create_delete_policy, crt2.singleton, crt2.supports_manual_add, crt2.description, crt2.plugin, crt2.ctime, crt2.mtime, crt2.subcategory_id, crt2.plugin_config_def_id, crt2.res_config_def_id FROM RHQ_resource_type crt2 WHERE 1 = (SELECT COUNT(res2.id) FROM RHQ_resource res2, RHQ_resource_type rt2 WHERE res2.id = ? AND res2.resource_type_id = rt2.id AND rt2.category = 'PLATFORM') AND 0 = (SELECT COUNT(rtp2.resource_type_id) FROM RHQ_resource_type_parents rtp2 WHERE rtp2.resource_type_id = crt2.id) AND crt2.category = ? )) ORDER BY name", resultSetMapping="ResourceType.findChildrenByCategoryMapping")})
@SqlResultSetMapping(name="ResourceType.findChildrenByCategoryMapping", entities={@EntityResult(entityClass=ResourceType.class)})
public class ResourceType
implements Externalizable,
Comparable<ResourceType> {
    private static final long serialVersionUID = 1L;
    public static final ResourceType ANY_PLATFORM_TYPE = null;
    public static final String QUERY_FIND_BY_NAME = "ResourceType.findByName";
    public static final String QUERY_GET_EXPLICIT_RESOURCE_TYPE_COUNTS_BY_GROUP = "ResourceType.getExplicitResourceTypeCountsByGroup";
    public static final String QUERY_GET_IMPLICIT_RESOURCE_TYPE_COUNTS_BY_GROUP = "ResourceType.getImplicitResourceTypeCountsByGroup";
    public static final String QUERY_FIND_BY_NAME_AND_PLUGIN = "ResourceType.findByNameAndPlugin";
    public static final String QUERY_FIND_BY_PLUGIN = "ResourceType.findByPlugin";
    public static final String QUERY_FIND_BY_PARENT_AND_NAME = "ResourceType.findByParentAndName";
    public static final String QUERY_FIND_ROOT_TYPE_BY_NAME = "ResourceType.findRootTypeByName";
    public static final String QUERY_FIND_ALL = "ResourceType.findAll";
    public static final String QUERY_FIND_BY_ID_WITH_ALL_OPERATIONS = "ResourceType.findByIdWithAllOperations";
    public static final String QUERY_FIND_BY_CATEGORY = "ResourceType.findByCategory";
    public static final String QUERY_FIND_CHILDREN = "ResourceType.findChildren";
    public static final String QUERY_FIND_CHILDREN_BY_CATEGORY = "ResourceType.findChildrenByCategory";
    public static final String QUERY_FIND_UTILIZED_CHILDREN_BY_CATEGORY = "ResourceType.findUtilizedChildrenByCategory";
    public static final String FIND_CHILDREN_BY_PARENT = "ResourceType.findChildrenByParent";
    public static final String FIND_ALL_TEMPLATE_COUNT_COMPOSITES = "ResourceType.findAllTemplateCountComposites";
    public static final String QUERY_FIND_BY_SUBCATEGORY = "ResourceType.findBySubCategory";
    public static final String QUERY_FIND_UTILIZED_BY_CATEGORY = "ResourceType.findUtilizedByCategory";
    public static final String QUERY_FIND_BY_RESOURCE_GROUP = "ResourceType.findByResourceGroup";
    public static final String MAPPING_FIND_CHILDREN_BY_CATEGORY = "ResourceType.findChildrenByCategoryMapping";
    public static final String QUERY_FIND_RESOURCE_FACETS = "ResourceType.findResourceFacets";
    @Id
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SEQ")
    private int id;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="CATEGORY", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ResourceCategory category;
    @Column(name="CREATION_DATA_TYPE", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ResourceCreationDataType creationDataType = ResourceCreationDataType.CONFIGURATION;
    @Column(name="CREATE_DELETE_POLICY", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private CreateDeletePolicy createDeletePolicy = CreateDeletePolicy.BOTH;
    @Column(name="SUPPORTS_MANUAL_ADD", nullable=false)
    private boolean supportsManualAdd;
    @Column(name="SINGLETON", nullable=false)
    private boolean singleton;
    @Column(name="PLUGIN", nullable=false)
    private String plugin;
    @Column(name="CTIME")
    private Long ctime;
    @Column(name="MTIME")
    private Long mtime;
    @ManyToMany(mappedBy="parentResourceTypes", cascade={CascadeType.ALL})
    @OrderBy
    private Set<ResourceType> childResourceTypes;
    @ManyToMany(cascade={CascadeType.PERSIST})
    @JoinTable(name="RHQ_RESOURCE_TYPE_PARENTS", joinColumns={@JoinColumn(name="RESOURCE_TYPE_ID")}, inverseJoinColumns={@JoinColumn(name="PARENT_RESOURCE_TYPE_ID")})
    @OrderBy
    private Set<ResourceType> parentResourceTypes;
    @JoinColumn(name="PLUGIN_CONFIG_DEF_ID")
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private ConfigurationDefinition pluginConfigurationDefinition;
    @JoinColumn(name="RES_CONFIG_DEF_ID")
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private ConfigurationDefinition resourceConfigurationDefinition;
    @JoinColumn(name="SUBCATEGORY_ID")
    @ManyToOne(fetch=FetchType.LAZY)
    private ResourceSubCategory subCategory;
    @OneToMany(mappedBy="resourceType", cascade={CascadeType.ALL})
    @OrderBy
    private Set<MeasurementDefinition> metricDefinitions;
    @OneToMany(mappedBy="resourceType", cascade={CascadeType.ALL})
    @OrderBy
    private Set<EventDefinition> eventDefinitions;
    @OneToMany(mappedBy="resourceType", cascade={CascadeType.ALL})
    @OrderBy
    private Set<OperationDefinition> operationDefinitions;
    @JoinColumn(name="RESOURCE_TYPE_ID")
    @OneToMany(cascade={CascadeType.ALL})
    private Set<ProcessScan> processScans;
    @OneToMany(mappedBy="resourceType", cascade={CascadeType.ALL})
    private Set<PackageType> packageTypes;
    @OneToMany(mappedBy="resourceType", cascade={CascadeType.ALL})
    private List<ResourceSubCategory> subCategories;
    @OneToMany(mappedBy="resourceType", cascade={CascadeType.REMOVE})
    private List<Resource> resources;
    @OneToMany(mappedBy="resourceType", cascade={CascadeType.ALL})
    private Set<ProductVersion> productVersions;
    @Transient
    private transient String helpText;

    public ResourceType() {
    }

    public ResourceType(@NotNull String name, @NotNull String plugin, ResourceCategory category, ResourceType parentResourceType) {
        assert (name != null);
        assert (plugin != null);
        this.childResourceTypes = new LinkedHashSet<ResourceType>();
        this.parentResourceTypes = new LinkedHashSet<ResourceType>();
        this.metricDefinitions = new LinkedHashSet<MeasurementDefinition>();
        this.eventDefinitions = new LinkedHashSet<EventDefinition>();
        this.operationDefinitions = new LinkedHashSet<OperationDefinition>();
        this.packageTypes = new HashSet<PackageType>();
        this.subCategories = new ArrayList<ResourceSubCategory>();
        this.processScans = new LinkedHashSet<ProcessScan>();
        this.name = name;
        this.category = category;
        this.plugin = plugin;
        this.mtime = this.ctime = Long.valueOf(System.currentTimeMillis());
        if (parentResourceType != null) {
            parentResourceType.addChildResourceType(this);
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @NotNull
    public ResourceCategory getCategory() {
        return this.category;
    }

    public void setCategory(@NotNull ResourceCategory category) {
        this.category = category;
    }

    @NotNull
    public ResourceCreationDataType getCreationDataType() {
        return this.creationDataType;
    }

    public void setCreationDataType(@NotNull ResourceCreationDataType creationDataType) {
        if (creationDataType == null) {
            throw new IllegalArgumentException("creationDataType cannot be null");
        }
        this.creationDataType = creationDataType;
    }

    @NotNull
    public CreateDeletePolicy getCreateDeletePolicy() {
        return this.createDeletePolicy;
    }

    public void setCreateDeletePolicy(@NotNull CreateDeletePolicy createDeletePolicy) {
        if (createDeletePolicy == null) {
            throw new IllegalArgumentException("createDeletePolicy cannot be null");
        }
        this.createDeletePolicy = createDeletePolicy;
    }

    public boolean isCreatable() {
        return this.createDeletePolicy == CreateDeletePolicy.BOTH || this.createDeletePolicy == CreateDeletePolicy.CREATE_ONLY;
    }

    public boolean isDeletable() {
        return this.createDeletePolicy == CreateDeletePolicy.BOTH || this.createDeletePolicy == CreateDeletePolicy.DELETE_ONLY;
    }

    @Nullable
    public ResourceSubCategory getSubCategory() {
        return this.subCategory;
    }

    public void setSubCategory(ResourceSubCategory subcategory) {
        this.subCategory = subcategory;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean isSupportsManualAdd() {
        return this.supportsManualAdd;
    }

    public void setSupportsManualAdd(boolean supportsManualAdd) {
        this.supportsManualAdd = supportsManualAdd;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @NotNull
    public String getPlugin() {
        return this.plugin;
    }

    public void setPlugin(@NotNull String plugin) {
        this.plugin = plugin;
    }

    public long getCtime() {
        return this.ctime;
    }

    @PrePersist
    void onPersist() {
        this.mtime = this.ctime = Long.valueOf(System.currentTimeMillis());
    }

    public long getMtime() {
        return this.mtime;
    }

    @PreUpdate
    void onUpdate() {
        this.mtime = System.currentTimeMillis();
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    public Set<ResourceType> getParentResourceTypes() {
        return this.parentResourceTypes;
    }

    public void setParentResourceTypes(Set<ResourceType> parentResourceTypes) {
        this.parentResourceTypes = parentResourceTypes;
    }

    public void addParentResourceType(ResourceType parentResourceType) {
        parentResourceType.childResourceTypes.add(this);
        this.parentResourceTypes.add(parentResourceType);
    }

    public void removeParentResourceType(ResourceType oldParentResourceType) {
        oldParentResourceType.childResourceTypes.remove(this);
        this.parentResourceTypes.remove(oldParentResourceType);
    }

    public Set<ResourceType> getChildResourceTypes() {
        return this.childResourceTypes;
    }

    public void addChildResourceType(ResourceType childResourceType) {
        childResourceType.parentResourceTypes.add(this);
        this.childResourceTypes.add(childResourceType);
    }

    public void removeChildResourceType(ResourceType oldChildResourceType) {
        oldChildResourceType.parentResourceTypes.remove(this);
        this.childResourceTypes.remove(oldChildResourceType);
    }

    public ConfigurationDefinition getPluginConfigurationDefinition() {
        return this.pluginConfigurationDefinition;
    }

    public void setPluginConfigurationDefinition(ConfigurationDefinition pluginConfigurationDefinition) {
        this.pluginConfigurationDefinition = pluginConfigurationDefinition;
    }

    public ConfigurationDefinition getResourceConfigurationDefinition() {
        return this.resourceConfigurationDefinition;
    }

    public void setResourceConfigurationDefinition(ConfigurationDefinition resourceConfigurationDefinition) {
        this.resourceConfigurationDefinition = resourceConfigurationDefinition;
    }

    @XmlTransient
    @NotNull
    public Set<MeasurementDefinition> getMetricDefinitions() {
        if (this.metricDefinitions == null) {
            this.metricDefinitions = new LinkedHashSet<MeasurementDefinition>();
        }
        return this.metricDefinitions;
    }

    public void setMetricDefinitions(Set<MeasurementDefinition> metricDefinitions) {
        this.metricDefinitions = metricDefinitions != null ? metricDefinitions : Collections.emptySet();
    }

    public boolean addMetricDefinition(MeasurementDefinition metricDef) {
        metricDef.setResourceType(this);
        return this.metricDefinitions.add(metricDef);
    }

    @XmlTransient
    @NotNull
    public Set<EventDefinition> getEventDefinitions() {
        if (this.eventDefinitions == null) {
            this.eventDefinitions = new LinkedHashSet<EventDefinition>();
        }
        return this.eventDefinitions;
    }

    public void setEventDefinitions(Set<EventDefinition> eventDefinitions) {
        this.eventDefinitions = eventDefinitions != null ? eventDefinitions : eventDefinitions;
    }

    public void addEventDefinition(EventDefinition eventDefinition) {
        this.getEventDefinitions().add(eventDefinition);
    }

    @NotNull
    public Set<OperationDefinition> getOperationDefinitions() {
        if (this.operationDefinitions == null) {
            this.operationDefinitions = new LinkedHashSet<OperationDefinition>();
        }
        return this.operationDefinitions;
    }

    public boolean addOperationDefinition(OperationDefinition operationDefinition) {
        operationDefinition.setResourceType(this);
        return this.operationDefinitions.add(operationDefinition);
    }

    @NotNull
    public Set<ProcessScan> getProcessScans() {
        if (this.processScans == null) {
            this.processScans = new LinkedHashSet<ProcessScan>();
        }
        return this.processScans;
    }

    public boolean addProcessScan(ProcessScan processMatch) {
        return this.getProcessScans().add(processMatch);
    }

    public Set<PackageType> getPackageTypes() {
        if (this.packageTypes == null) {
            this.packageTypes = new LinkedHashSet<PackageType>();
        }
        return this.packageTypes;
    }

    public void setPackageTypes(Set<PackageType> packageTypes) {
        this.packageTypes = packageTypes != null ? packageTypes : packageTypes;
    }

    public void addPackageType(PackageType packageType) {
        packageType.setResourceType(this);
        this.getPackageTypes().add(packageType);
    }

    public void removePackageType(PackageType packageType) {
        this.getPackageTypes().remove(packageType);
        packageType.setResourceType(null);
    }

    public List<ResourceSubCategory> getChildSubCategories() {
        return this.subCategories;
    }

    public void setChildSubCategories(List<ResourceSubCategory> subCategories) {
        this.subCategories = subCategories;
    }

    public void addChildSubCategory(ResourceSubCategory subCategory) {
        if (this.subCategories == null) {
            this.subCategories = new ArrayList<ResourceSubCategory>();
        }
        subCategory.setResourceType(this);
        this.subCategories.add(subCategory);
    }

    @Override
    public int compareTo(ResourceType that) {
        return this.name.compareTo(that.getName());
    }

    @Nullable
    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(@Nullable String helpText) {
        this.helpText = helpText;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ResourceType)) {
            return false;
        }
        ResourceType that = (ResourceType)obj;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return !(this.plugin != null ? !this.plugin.equals(that.plugin) : that.plugin != null);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.plugin != null ? this.plugin.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ResourceType[id=" + this.id + ", category=" + (Object)((Object)this.category) + ", name=" + this.name + ", plugin=" + this.plugin + "]";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.plugin);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.plugin = in.readUTF();
    }
}

