/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jboss.aop.Advisor;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.pointcut.MatcherStrategy;
import org.jboss.aop.pointcut.SecurityActions;
import org.jboss.aop.pointcut.ast.ClassExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyMatcherStrategy
extends MatcherStrategy {
    @Override
    protected boolean checkIntroductions(Class<?> clazz, ClassExpression instanceOf, Advisor advisor) {
        try {
            if (advisor != null) {
                ArrayList<InterfaceIntroduction> intros;
                ClassLoader cl = advisor.getClassLoader();
                if (cl == null) {
                    cl = SecurityActions.getContextClassLoader();
                }
                if ((intros = advisor.getInterfaceIntroductions()).size() > 0) {
                    for (InterfaceIntroduction intro : intros) {
                        ArrayList<InterfaceIntroduction.Mixin> mixins;
                        String[] introductions = intro.getInterfaces();
                        if (introductions != null) {
                            for (int i = 0; i < introductions.length; ++i) {
                                Class<?> iface = cl.loadClass(introductions[i]);
                                if (!this.subtypeOf(iface, instanceOf, advisor)) continue;
                                return true;
                            }
                        }
                        if ((mixins = intro.getMixins()).size() <= 0) continue;
                        for (InterfaceIntroduction.Mixin mixin : mixins) {
                            String[] mixinInterfaces = mixin.getInterfaces();
                            if (mixinInterfaces == null) continue;
                            for (int i = 0; i < mixinInterfaces.length; ++i) {
                                Class<?> iface = cl.loadClass(mixinInterfaces[i]);
                                if (!this.subtypeOf(iface, instanceOf, advisor)) continue;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    @Override
    public Class<?> getDeclaringClass(Advisor advisor, Method m) {
        Class<?> methodClass = m.getDeclaringClass();
        Class advisorClass = advisor.getClazz();
        if (advisorClass != null && methodClass.isInterface()) {
            return advisorClass;
        }
        return methodClass;
    }
}

