/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jpa.injection;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jboss.jpa.deployment.ManagedEntityManagerFactory;
import org.jboss.jpa.tx.TransactionScopedEntityManager;
import org.jboss.jpa.util.ManagedEntityManagerFactoryHelper;

public class InjectedEntityManagerFactory
implements EntityManagerFactory,
Externalizable {
    private static final long serialVersionUID = -3734435119658196788L;
    private transient EntityManagerFactory delegate;
    private transient ManagedEntityManagerFactory managedFactory;

    public InjectedEntityManagerFactory() {
    }

    public InjectedEntityManagerFactory(ManagedEntityManagerFactory managedFactory) {
        assert (managedFactory != null) : "managedFactory is null";
        this.delegate = managedFactory.getEntityManagerFactory();
        this.managedFactory = managedFactory;
    }

    public EntityManagerFactory getDelegate() {
        return this.delegate;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.managedFactory.getKernelName());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String kernelName = in.readUTF();
        this.managedFactory = ManagedEntityManagerFactoryHelper.getManagedEntityManagerFactory(kernelName);
        if (this.managedFactory == null) {
            throw new IOException("Unable to find persistence unit in registry: " + kernelName);
        }
        this.delegate = this.managedFactory.getEntityManagerFactory();
    }

    public EntityManager createEntityManager() {
        return this.getDelegate().createEntityManager();
    }

    public EntityManager createEntityManager(Map map) {
        return this.delegate.createEntityManager(map);
    }

    public EntityManager getEntityManager() {
        return new TransactionScopedEntityManager(this.managedFactory);
    }

    public void close() {
        throw new IllegalStateException("It is illegal to close an injected EntityManagerFactory");
    }

    public boolean isOpen() {
        return this.getDelegate().isOpen();
    }
}

