/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.network;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.jboss.remoting.network.NetworkRegistryMBean;
import org.jboss.remoting.util.SecurityUtility;

public class NetworkRegistryQuery
implements QueryExp {
    private MBeanServer server;
    private static final long serialVersionUID = 2402056810602499064L;

    public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        try {
            return NetworkRegistryQuery.isInstanceOf(this.server, objectName, NetworkRegistryMBean.class.getName());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            return false;
        }
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this.server = mBeanServer;
    }

    private static boolean isInstanceOf(final MBeanServer server, final ObjectName objectName, final String className) throws InstanceNotFoundException {
        if (SecurityUtility.skipAccessControl()) {
            return server.isInstanceOf(objectName, className);
        }
        try {
            return (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new Boolean(server.isInstanceOf(objectName, className));
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (InstanceNotFoundException)e.getCause();
        }
    }
}

