/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.clustered.jndiregistrar;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.Context;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.proxy.clustered.registry.ProxyClusteringInfo;
import org.jboss.ejb3.proxy.clustered.registry.ProxyClusteringRegistry;
import org.jboss.ejb3.proxy.clustered.registry.ProxyClusteringRegistryListener;
import org.jboss.ejb3.proxy.impl.jndiregistrar.JndiReferenceBinding;
import org.jboss.ejb3.proxy.impl.jndiregistrar.JndiReferenceBindingSet;
import org.jboss.ejb3.proxy.impl.jndiregistrar.JndiSessionRegistrarBase;
import org.jboss.ha.framework.interfaces.FamilyClusterInfo;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.ClusterConfigMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.remoting.InvokerLocator;

public abstract class JndiClusteredSessionRegistrarBase
extends JndiSessionRegistrarBase
implements ProxyClusteringRegistryListener {
    private static final Logger log = Logger.getLogger(JndiClusteredSessionRegistrarBase.class);
    private final ProxyClusteringRegistry registry;
    private final Map<String, BeanClusteringRegistryInfo> bindingsByContainer = new ConcurrentHashMap<String, BeanClusteringRegistryInfo>();

    public JndiClusteredSessionRegistrarBase(String sessionProxyObjectFactoryType, ProxyClusteringRegistry registry) {
        super(sessionProxyObjectFactoryType);
        assert (registry != null) : "registry is null";
        this.registry = registry;
        this.registry.registerListener(this);
    }

    public void clusterTopologyChanged(ProxyClusteringInfo beanClusteringInfo) {
        RefAddr refAddr;
        JndiReferenceBindingSet bindings = null;
        BeanClusteringRegistryInfo registryEntry = this.bindingsByContainer.get(beanClusteringInfo.getContainerName());
        if (registryEntry != null) {
            bindings = registryEntry.bindings;
        }
        if (bindings == null) {
            return;
        }
        Context context = bindings.getContext();
        FamilyClusterInfo fci = beanClusteringInfo.getFamilyWrapper().get();
        String familyName = fci.getFamilyName();
        for (JndiReferenceBinding binding : bindings.getDefaultRemoteBindings()) {
            refAddr = this.getFirstRefAddr(binding.getReference(), "Cluster Family Name");
            if (refAddr == null || !familyName.equals(refAddr.getContent())) continue;
            this.redecorateReferenceForClusteringTargets(binding.getReference(), fci);
            this.rebind(context, binding.getJndiName(), binding.getReference());
        }
        for (JndiReferenceBinding binding : bindings.getHomeRemoteBindings()) {
            refAddr = this.getFirstRefAddr(binding.getReference(), "Cluster Family Name");
            if (refAddr == null || !familyName.equals(refAddr.getContent())) continue;
            this.redecorateReferenceForClusteringTargets(binding.getReference(), fci);
            this.rebind(context, binding.getJndiName(), binding.getReference());
        }
        for (Set businessBindings : bindings.getBusinessRemoteBindings().values()) {
            for (JndiReferenceBinding binding : businessBindings) {
                RefAddr refAddr2 = this.getFirstRefAddr(binding.getReference(), "Cluster Family Name");
                if (refAddr2 == null || !familyName.equals(refAddr2.getContent())) continue;
                this.redecorateReferenceForClusteringTargets(binding.getReference(), fci);
                this.rebind(context, binding.getJndiName(), binding.getReference());
            }
        }
    }

    public void beanClusteringInfoAdded(ProxyClusteringInfo beanClusteringInfo) {
        BeanClusteringRegistryInfo info = this.getBeanClusteringRegistryInfo(beanClusteringInfo.getContainerName());
        info.familyCount.incrementAndGet();
    }

    public void beanClusteringInfoRemoved(ProxyClusteringInfo beanClusteringInfo) {
        String containerName = beanClusteringInfo.getContainerName();
        BeanClusteringRegistryInfo info = this.getBeanClusteringRegistryInfo(containerName);
        if (info.familyCount.decrementAndGet() == 0) {
            this.bindingsByContainer.remove(containerName);
        }
    }

    public ProxyClusteringRegistry getRegistry() {
        return this.registry;
    }

    public String getProxyFactoryRegistryKey(String jndiName, JBossSessionBeanMetaData smd, boolean isLocal) {
        String key = super.getProxyFactoryRegistryKey(jndiName, smd, isLocal);
        if (!isLocal) {
            ClusterConfigMetaData ccmd = smd.getClusterConfig();
            assert (ccmd != null) : ClusterConfigMetaData.class.getSimpleName() + " not found in metadata, specified only in XML? [EJBTHREE-1539]";
            key = key + "/" + ProxyClusteringRegistry.getPartitionName(smd.getClusterConfig());
        }
        return key;
    }

    protected JndiReferenceBindingSet createJndiReferenceBindingSet(Context context, JBossSessionBeanMetaData smd, ClassLoader cl, String containerName, String containerGuid, Advisor advisor) {
        JndiReferenceBindingSet bindings = super.createJndiReferenceBindingSet(context, smd, cl, containerName, containerGuid, advisor);
        this.decorateReferencesForClustering(bindings);
        BeanClusteringRegistryInfo registryInfo = this.getBeanClusteringRegistryInfo(containerName);
        registryInfo.bindings = bindings;
        return bindings;
    }

    private BeanClusteringRegistryInfo getBeanClusteringRegistryInfo(String containerName) {
        BeanClusteringRegistryInfo registryInfo = this.bindingsByContainer.get(containerName);
        if (registryInfo == null) {
            registryInfo = new BeanClusteringRegistryInfo();
            this.bindingsByContainer.put(containerName, registryInfo);
        }
        return registryInfo;
    }

    private void decorateReferencesForClustering(JndiReferenceBindingSet bindings) {
        for (JndiReferenceBinding binding : bindings.getDefaultRemoteBindings()) {
            this.decorateReferenceForClustering(binding.getReference());
        }
        for (JndiReferenceBinding binding : bindings.getHomeRemoteBindings()) {
            this.decorateReferenceForClustering(binding.getReference());
        }
        for (Set businessBindings : bindings.getBusinessRemoteBindings().values()) {
            for (JndiReferenceBinding binding : businessBindings) {
                this.decorateReferenceForClustering(binding.getReference());
            }
        }
    }

    private void decorateReferenceForClustering(Reference ref) {
        String proxyFactoryKey = this.getSingleRequiredRefAddr(ref, "ProxyFactoryKey");
        ProxyClusteringInfo bci = this.registry.getBeanClusteringInfo(proxyFactoryKey);
        if (bci == null) {
            throw new IllegalStateException("Cannot find " + ProxyClusteringInfo.class.getSimpleName() + " for proxyFactoryKey " + proxyFactoryKey);
        }
        StringRefAddr partitionRef = new StringRefAddr("Cluster Partition Name", bci.getPartitionName());
        this.addRefAddrToReference(ref, partitionRef);
        StringRefAddr lbpRef = new StringRefAddr("Cluster Proxy Factory Load Balance Policy", bci.getHomeLoadBalancePolicy().getName());
        this.addRefAddrToReference(ref, lbpRef);
        FamilyClusterInfo fci = bci.getFamilyWrapper().get();
        StringRefAddr familyNameRef = new StringRefAddr("Cluster Family Name", fci.getFamilyName());
        this.addRefAddrToReference(ref, familyNameRef);
        this.decorateReferenceForClusteringTargets(ref, fci);
    }

    private void redecorateReferenceForClusteringTargets(Reference ref, FamilyClusterInfo fci) {
        for (int i = 0; i < ref.size(); ++i) {
            RefAddr refAddr = ref.get(i);
            if (!"Cluster Target Remoting Host URL".equals(refAddr.getType())) continue;
            ref.remove(i);
            --i;
        }
        this.decorateReferenceForClusteringTargets(ref, fci);
    }

    private void decorateReferenceForClusteringTargets(Reference ref, FamilyClusterInfo fci) {
        List targets = fci.getTargets();
        for (Object target : targets) {
            boolean correctType = target instanceof InvokerLocator;
            assert (correctType) : target + " is not an instance of InvokerLocator";
            if (!correctType) {
                throw new IllegalStateException(target + " is not an instance of InvokerLocator");
            }
            String url = ((InvokerLocator)target).getOriginalURI();
            StringRefAddr targetRef = new StringRefAddr("Cluster Target Remoting Host URL", url);
            this.addRefAddrToReference(ref, targetRef);
        }
    }

    private void addRefAddrToReference(Reference ref, RefAddr refAddr) {
        log.debug((Object)("Adding " + RefAddr.class.getSimpleName() + " to " + Reference.class.getSimpleName() + ": Type \"" + refAddr.getType() + "\", Content \"" + refAddr.getContent() + "\""));
        ref.add(refAddr);
    }

    private String getSingleRequiredRefAddr(Reference ref, String refAddrType) {
        RefAddr result = null;
        for (int i = 0; i < ref.size(); ++i) {
            RefAddr refAddr = ref.get(i);
            if (!refAddr.getType().equals(refAddrType)) continue;
            if (result == null) {
                result = refAddr;
                continue;
            }
            throw new IllegalStateException(ref + " has multiple RefAddr objects of type " + refAddrType);
        }
        if (result == null) {
            throw new IllegalStateException(ref + " has no RefAddr object of type " + refAddrType);
        }
        return (String)result.getContent();
    }

    private RefAddr getFirstRefAddr(Reference ref, String refAddrType) {
        for (int i = 0; i < ref.size(); ++i) {
            RefAddr refAddr = ref.get(i);
            if (!refAddr.getType().equals(refAddrType)) continue;
            return refAddr;
        }
        return null;
    }

    private static class BeanClusteringRegistryInfo {
        private final AtomicInteger familyCount = new AtomicInteger();
        private JndiReferenceBindingSet bindings;

        private BeanClusteringRegistryInfo() {
        }
    }
}

