/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import org.exoplatform.services.database.DBObject;
import org.exoplatform.services.database.DBObjectMapper;
import org.exoplatform.services.database.DBObjectQuery;
import org.exoplatform.services.database.ExoDatasource;
import org.exoplatform.services.database.StandardSQLDAO;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.organization.jdbc.UserProfileData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserProfileDAOImpl
extends StandardSQLDAO<UserProfileData>
implements UserProfileHandler {
    protected static Log log = ExoLogger.getLogger((String)"organization:UserProfileDAOImpl");
    protected ListenerService listenerService_;

    public UserProfileDAOImpl(ListenerService lService, ExoDatasource datasource, DBObjectMapper<UserProfileData> mapper) {
        super(datasource, mapper, UserProfileData.class);
        this.listenerService_ = lService;
    }

    public UserProfile createUserProfileInstance() {
        return new UserProfileData("").getUserProfile();
    }

    public UserProfile createUserProfileInstance(String userName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("----------------Create Profile with userName = " + userName));
        }
        return new UserProfileData(userName).getUserProfile();
    }

    public UserProfile findUserProfileByName(String userName) throws Exception {
        UserProfileData data = this.findUserProfileDataByName(userName);
        if (data != null) {
            return data.getUserProfile();
        }
        return null;
    }

    private UserProfileData findUserProfileDataByName(String userName) throws Exception {
        DBObjectQuery query = new DBObjectQuery(UserProfileData.class);
        query.addLIKE("USER_NAME", userName);
        return (UserProfileData)this.loadUnique(query.toQuery());
    }

    public Collection findUserProfiles() throws Exception {
        ArrayList allProfileData = new ArrayList();
        DBObjectQuery query = new DBObjectQuery(UserProfileData.class);
        this.loadInstances(query.toQuery(), allProfileData);
        ArrayList<UserProfile> allProfile = new ArrayList<UserProfile>();
        for (UserProfileData ele : allProfileData) {
            allProfile.add(ele.getUserProfile());
        }
        return allProfile;
    }

    public UserProfile removeUserProfile(String userName, boolean broadcast) throws Exception {
        UserProfileData userImpl = this.findUserProfileDataByName(userName);
        if (userImpl == null) {
            return null;
        }
        if (broadcast) {
            this.listenerService_.broadcast("organization.userProfile.preDelete", (Object)this, (Object)userImpl);
        }
        super.remove((DBObject)userImpl);
        if (broadcast) {
            this.listenerService_.broadcast("organization.userProfile.postDelete", (Object)this, (Object)userImpl);
        }
        return userImpl.getUserProfile();
    }

    public void saveUserProfile(UserProfile profile, boolean broadcast) throws Exception {
        UserProfileData userImpl = this.findUserProfileDataByName(profile.getUserName());
        if (userImpl == null) {
            userImpl = new UserProfileData(profile.getUserName());
            userImpl.setUserProfile(profile);
            if (broadcast) {
                this.listenerService_.broadcast("organization.userProfile.preCreate", (Object)this, (Object)userImpl);
            }
            super.save((DBObject)userImpl);
            if (broadcast) {
                this.listenerService_.broadcast("organization.userProfile.postCreate", (Object)this, (Object)userImpl);
            }
        } else {
            if (broadcast) {
                this.listenerService_.broadcast("organization.userProfile.preUpdate", (Object)this, (Object)userImpl);
            }
            userImpl.setUserProfile(profile);
            super.update((DBObject)userImpl);
            if (broadcast) {
                this.listenerService_.broadcast("organization.userProfile.postUpdate", (Object)this, (Object)userImpl);
            }
        }
    }

    public void addUserProfileEventListener(UserProfileEventListener listener) {
    }
}

