/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.resource;

import java.lang.reflect.Method;
import java.util.List;
import org.exoplatform.services.rest.impl.resource.PathValue;
import org.exoplatform.services.rest.method.MethodInvoker;
import org.exoplatform.services.rest.method.MethodParameter;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;
import org.exoplatform.services.rest.resource.ResourceDescriptorVisitor;
import org.exoplatform.services.rest.resource.SubResourceLocatorDescriptor;
import org.exoplatform.services.rest.uri.UriPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubResourceLocatorDescriptorImpl
implements SubResourceLocatorDescriptor {
    private final PathValue path;
    private final UriPattern uriPattern;
    private final Method method;
    private final AbstractResourceDescriptor parentResource;
    private final List<MethodParameter> parameters;
    private final MethodInvoker invoker;

    SubResourceLocatorDescriptorImpl(PathValue path, Method method, List<MethodParameter> parameters, AbstractResourceDescriptor parentResource, MethodInvoker invoker) {
        this.path = path;
        this.uriPattern = new UriPattern(path.getPath());
        this.method = method;
        this.parameters = parameters;
        this.parentResource = parentResource;
        this.invoker = invoker;
    }

    @Override
    public PathValue getPathValue() {
        return this.path;
    }

    @Override
    public UriPattern getUriPattern() {
        return this.uriPattern;
    }

    @Override
    public void accept(ResourceDescriptorVisitor visitor) {
        visitor.visitSubResourceLocatorDescriptor(this);
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public List<MethodParameter> getMethodParameters() {
        return this.parameters;
    }

    @Override
    public AbstractResourceDescriptor getParentResource() {
        return this.parentResource;
    }

    @Override
    public MethodInvoker getMethodInvoker() {
        return this.invoker;
    }

    @Override
    public Class<?> getResponseType() {
        return this.getMethod().getReturnType();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[ SubResourceMethodDescriptorImpl: ");
        sb.append("resource: " + this.getParentResource() + "; ").append("path: " + this.getPathValue() + "; ").append("return type: " + this.getResponseType() + "; ").append("invoker: " + this.getMethodInvoker()).append(" ]");
        return sb.toString();
    }
}

