/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.chars.chardet;

import org.exoplatform.services.chars.chardet.BIG5Verifier;
import org.exoplatform.services.chars.chardet.Big5Statistics;
import org.exoplatform.services.chars.chardet.CP1252Verifier;
import org.exoplatform.services.chars.chardet.EUCJPStatistics;
import org.exoplatform.services.chars.chardet.EUCJPVerifier;
import org.exoplatform.services.chars.chardet.EUCKRStatistics;
import org.exoplatform.services.chars.chardet.EUCKRVerifier;
import org.exoplatform.services.chars.chardet.EUCSampler;
import org.exoplatform.services.chars.chardet.EUCStatistics;
import org.exoplatform.services.chars.chardet.EUCTWStatistics;
import org.exoplatform.services.chars.chardet.EUCTWVerifier;
import org.exoplatform.services.chars.chardet.GB18030Verifier;
import org.exoplatform.services.chars.chardet.GB2312Statistics;
import org.exoplatform.services.chars.chardet.GB2312Verifier;
import org.exoplatform.services.chars.chardet.HZVerifier;
import org.exoplatform.services.chars.chardet.ISO2022CNVerifier;
import org.exoplatform.services.chars.chardet.ISO2022JPVerifier;
import org.exoplatform.services.chars.chardet.ISO2022KRVerifier;
import org.exoplatform.services.chars.chardet.SJISVerifier;
import org.exoplatform.services.chars.chardet.UCS2BEVerifier;
import org.exoplatform.services.chars.chardet.UCS2LEVerifier;
import org.exoplatform.services.chars.chardet.UTF8Verifier;
import org.exoplatform.services.chars.chardet.Verifier;

public abstract class PSMDetector {
    public static final int ALL = 0;
    public static final int JAPANESE = 1;
    public static final int CHINESE = 2;
    public static final int SIMPLIFIED_CHINESE = 3;
    public static final int TRADITIONAL_CHINESE = 4;
    public static final int KOREAN = 5;
    public static final int NO_OF_LANGUAGES = 6;
    public static final int MAX_VERIFIERS = 16;
    Verifier[] mVerifier;
    EUCStatistics[] mStatisticsData;
    EUCSampler mSampler = new EUCSampler();
    byte[] mState = new byte[16];
    int[] mItemIdx = new int[16];
    int mItems;
    int mClassItems;
    boolean mDone;
    boolean mRunSampler;
    boolean mClassRunSampler;

    public PSMDetector() {
        this.initVerifiers(0);
        this.Reset();
    }

    public PSMDetector(int langFlag) {
        this.initVerifiers(langFlag);
        this.Reset();
    }

    public PSMDetector(int aItems, Verifier[] aVerifierSet, EUCStatistics[] aStatisticsSet) {
        this.mClassRunSampler = aStatisticsSet != null;
        this.mStatisticsData = aStatisticsSet;
        this.mVerifier = aVerifierSet;
        this.mClassItems = aItems;
        this.Reset();
    }

    public void Reset() {
        this.mRunSampler = this.mClassRunSampler;
        this.mDone = false;
        this.mItems = this.mClassItems;
        for (int i = 0; i < this.mItems; ++i) {
            this.mState[i] = 0;
            this.mItemIdx[i] = i;
        }
        this.mSampler.reset();
    }

    protected void initVerifiers(int currVerSet) {
        int currVerifierSet = currVerSet >= 0 && currVerSet < 6 ? currVerSet : 0;
        this.mVerifier = null;
        this.mStatisticsData = null;
        if (currVerifierSet == 4) {
            this.mVerifier = new Verifier[]{new UTF8Verifier(), new BIG5Verifier(), new ISO2022CNVerifier(), new EUCTWVerifier(), new CP1252Verifier(), new UCS2BEVerifier(), new UCS2LEVerifier()};
            this.mStatisticsData = new EUCStatistics[]{null, new Big5Statistics(), null, new EUCTWStatistics(), null, null, null};
        } else if (currVerifierSet == 5) {
            this.mVerifier = new Verifier[]{new UTF8Verifier(), new EUCKRVerifier(), new ISO2022KRVerifier(), new CP1252Verifier(), new UCS2BEVerifier(), new UCS2LEVerifier()};
        } else if (currVerifierSet == 3) {
            this.mVerifier = new Verifier[]{new UTF8Verifier(), new GB2312Verifier(), new GB18030Verifier(), new ISO2022CNVerifier(), new HZVerifier(), new CP1252Verifier(), new UCS2BEVerifier(), new UCS2LEVerifier()};
        } else if (currVerifierSet == 1) {
            this.mVerifier = new Verifier[]{new UTF8Verifier(), new SJISVerifier(), new EUCJPVerifier(), new ISO2022JPVerifier(), new CP1252Verifier(), new UCS2BEVerifier(), new UCS2LEVerifier()};
        } else if (currVerifierSet == 2) {
            this.mVerifier = new Verifier[]{new UTF8Verifier(), new GB2312Verifier(), new GB18030Verifier(), new BIG5Verifier(), new ISO2022CNVerifier(), new HZVerifier(), new EUCTWVerifier(), new CP1252Verifier(), new UCS2BEVerifier(), new UCS2LEVerifier()};
            this.mStatisticsData = new EUCStatistics[]{null, new GB2312Statistics(), null, new Big5Statistics(), null, null, new EUCTWStatistics(), null, null, null};
        } else if (currVerifierSet == 0) {
            this.mVerifier = new Verifier[]{new UTF8Verifier(), new SJISVerifier(), new EUCJPVerifier(), new ISO2022JPVerifier(), new EUCKRVerifier(), new ISO2022KRVerifier(), new BIG5Verifier(), new EUCTWVerifier(), new GB2312Verifier(), new GB18030Verifier(), new ISO2022CNVerifier(), new HZVerifier(), new CP1252Verifier(), new UCS2BEVerifier(), new UCS2LEVerifier()};
            this.mStatisticsData = new EUCStatistics[]{null, null, new EUCJPStatistics(), null, new EUCKRStatistics(), null, new Big5Statistics(), new EUCTWStatistics(), new GB2312Statistics(), null, null, null, null, null, null};
        }
        this.mClassRunSampler = this.mStatisticsData != null;
        this.mClassItems = this.mVerifier.length;
    }

    public abstract void report(String var1);

    public boolean handleData(byte[] aBuf, int len) {
        for (int i = 0; i < len; ++i) {
            byte b = aBuf[i];
            int j = 0;
            while (j < this.mItems) {
                byte st = Verifier.getNextState(this.mVerifier[this.mItemIdx[j]], b, this.mState[j]);
                if (st == 2) {
                    this.report(this.mVerifier[this.mItemIdx[j]].charset());
                    this.mDone = true;
                    return this.mDone;
                }
                if (st == 1) {
                    --this.mItems;
                    if (j >= this.mItems) continue;
                    this.mItemIdx[j] = this.mItemIdx[this.mItems];
                    this.mState[j] = this.mState[this.mItems];
                    continue;
                }
                this.mState[j++] = st;
            }
            if (this.mItems <= 1) {
                if (1 == this.mItems) {
                    this.report(this.mVerifier[this.mItemIdx[0]].charset());
                }
                this.mDone = true;
                return this.mDone;
            }
            int nonUCS2Num = 0;
            int nonUCS2Idx = 0;
            for (j = 0; j < this.mItems; ++j) {
                if (this.mVerifier[this.mItemIdx[j]].isUCS2() || this.mVerifier[this.mItemIdx[j]].isUCS2()) continue;
                ++nonUCS2Num;
                nonUCS2Idx = j;
            }
            if (true != nonUCS2Num) continue;
            this.report(this.mVerifier[this.mItemIdx[nonUCS2Idx]].charset());
            this.mDone = true;
            return this.mDone;
        }
        if (this.mRunSampler) {
            this.Sample(aBuf, len);
        }
        return this.mDone;
    }

    public void dataEnd() {
        if (this.mDone) {
            return;
        }
        if (this.mItems == 2) {
            if (this.mVerifier[this.mItemIdx[0]].charset().equals("GB18030")) {
                this.report(this.mVerifier[this.mItemIdx[1]].charset());
                this.mDone = true;
            } else if (this.mVerifier[this.mItemIdx[1]].charset().equals("GB18030")) {
                this.report(this.mVerifier[this.mItemIdx[0]].charset());
                this.mDone = true;
            }
        }
        if (this.mRunSampler) {
            this.Sample(null, 0, true);
        }
    }

    public void Sample(byte[] aBuf, int aLen) {
        this.Sample(aBuf, aLen, false);
    }

    public void Sample(byte[] aBuf, int aLen, boolean aLastChance) {
        int j;
        int possibleCandidateNum = 0;
        int eucNum = 0;
        for (j = 0; j < this.mItems; ++j) {
            if (null != this.mStatisticsData[this.mItemIdx[j]]) {
                ++eucNum;
            }
            if (this.mVerifier[this.mItemIdx[j]].isUCS2() || this.mVerifier[this.mItemIdx[j]].charset().equals("GB18030")) continue;
            ++possibleCandidateNum;
        }
        boolean bl = this.mRunSampler = eucNum > 1;
        if (this.mRunSampler) {
            this.mRunSampler = this.mSampler.sample(aBuf, aLen);
            if ((aLastChance && this.mSampler.getSomeData() || this.mSampler.enoughData()) && eucNum == possibleCandidateNum) {
                this.mSampler.calFreq();
                int bestIdx = -1;
                int eucCnt = 0;
                float bestScore = 0.0f;
                for (j = 0; j < this.mItems; ++j) {
                    if (null == this.mStatisticsData[this.mItemIdx[j]] || this.mVerifier[this.mItemIdx[j]].charset().equals("Big5")) continue;
                    float score = this.mSampler.getScore(this.mStatisticsData[this.mItemIdx[j]].mFirstByteFreq(), this.mStatisticsData[this.mItemIdx[j]].mFirstByteWeight(), this.mStatisticsData[this.mItemIdx[j]].mSecondByteFreq(), this.mStatisticsData[this.mItemIdx[j]].mSecondByteWeight());
                    if (0 != eucCnt++ && !(bestScore > score)) continue;
                    bestScore = score;
                    bestIdx = j;
                }
                if (bestIdx >= 0) {
                    this.report(this.mVerifier[this.mItemIdx[bestIdx]].charset());
                    this.mDone = true;
                }
            }
        }
    }

    public String[] getProbableCharsets() {
        if (this.mItems <= 0) {
            String[] nomatch = new String[]{"nomatch"};
            return nomatch;
        }
        String[] ret = new String[this.mItems];
        for (int i = 0; i < this.mItems; ++i) {
            ret[i] = this.mVerifier[this.mItemIdx[i]].charset();
        }
        return ret;
    }
}

