/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.space.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.application.SpaceApplicationHandler;
import org.exoplatform.social.application.impl.DefaultSpaceApplicationHandler;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceException;
import org.exoplatform.social.space.SpaceService;
import org.exoplatform.social.space.SpaceUtils;
import org.exoplatform.social.space.impl.JCRStorage;
import org.exoplatform.social.space.impl.SocialDataLocation;
import org.exoplatform.social.space.lifecycle.SpaceLifecycle;
import org.exoplatform.social.space.lifecycle.SpaceListenerPlugin;
import org.exoplatform.social.space.spi.SpaceLifeCycleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceServiceImpl
implements SpaceService {
    private static Log logger = ExoLogger.getLogger((String)SpaceServiceImpl.class.getName());
    public static final String SPACE_PARENT = "/spaces";
    public static final String MEMBER = "member";
    public static final String MANAGER = "manager";
    private String homeNodeApp;
    private List<String> apps = null;
    private JCRStorage storage;
    private OrganizationService orgService = null;
    private UserACL userACL = null;
    private Map<String, SpaceApplicationHandler> spaceApplicationHandlers = null;
    private SpaceLifecycle spaceLifeCycle = new SpaceLifecycle();

    public SpaceServiceImpl(InitParams params, SocialDataLocation dataLocation) throws Exception {
        this.storage = new JCRStorage(dataLocation);
        Iterator it = params.getValuesParamIterator();
        this.apps = new ArrayList<String>();
        while (it.hasNext()) {
            ValuesParam param = (ValuesParam)it.next();
            String name = param.getName();
            if (name.endsWith("homeNodeApp")) {
                this.homeNodeApp = param.getValue();
            }
            if (!name.endsWith("apps")) continue;
            this.apps = param.getValues();
        }
    }

    @Override
    public List<Space> getAllSpaces() throws SpaceException {
        try {
            List<Space> spaces = this.storage.getAllSpaces();
            Collections.sort(spaces, new SpaceComparator());
            return spaces;
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    @Override
    public List<Space> getSpacesByName(String spaceName, boolean isFirstCharOfSpaceName) throws SpaceException {
        List<Space> spaces;
        String nameForSearch = spaceName.trim();
        try {
            spaces = this.storage.getAllSpaces();
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
        Iterator<Space> itr = spaces.iterator();
        if (!isFirstCharOfSpaceName) {
            while (itr.hasNext()) {
                Space space = itr.next();
                if (space.getName().toLowerCase().matches(nameForSearch.toLowerCase())) continue;
                itr.remove();
            }
        } else {
            while (itr.hasNext()) {
                Space space = itr.next();
                if (space.getName().toLowerCase().startsWith(nameForSearch.toLowerCase())) continue;
                itr.remove();
            }
        }
        return spaces;
    }

    @Override
    public Space getSpaceById(String id) throws SpaceException {
        try {
            return this.storage.getSpaceById(id);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    @Override
    public Space getSpaceByUrl(String url) throws SpaceException {
        try {
            return this.storage.getSpaceByUrl(url);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    @Override
    public List<Space> getSpaces(String userId) throws SpaceException {
        List<Space> userSpaces = this.getAllSpaces();
        Iterator<Space> itr = userSpaces.iterator();
        while (itr.hasNext()) {
            Space space = itr.next();
            if (this.isMember(space, userId)) continue;
            itr.remove();
        }
        return userSpaces;
    }

    @Override
    public List<Space> getAccessibleSpaces(String userId) throws SpaceException {
        List<Space> accessiableSpaces = this.getAllSpaces();
        Iterator<Space> itr = accessiableSpaces.iterator();
        while (itr.hasNext()) {
            Space space = itr.next();
            if (this.hasAccessPermission(space, userId)) continue;
            itr.remove();
        }
        return accessiableSpaces;
    }

    @Override
    public List<Space> getEditableSpaces(String userId) throws SpaceException {
        List<Space> editableSpaces = this.getAllSpaces();
        Iterator<Space> itr = editableSpaces.iterator();
        while (itr.hasNext()) {
            Space space = itr.next();
            if (this.hasEditPermission(space, userId)) continue;
            itr.remove();
        }
        return editableSpaces;
    }

    @Override
    public List<Space> getInvitedSpaces(String userId) throws SpaceException {
        List<Space> spaces = this.getAllSpaces();
        Iterator<Space> itr = spaces.iterator();
        while (itr.hasNext()) {
            Space space = itr.next();
            if (this.isInvited(space, userId)) continue;
            itr.remove();
        }
        return spaces;
    }

    @Override
    public List<Space> getPublicSpaces(String userId) throws SpaceException {
        List<Space> spaces = this.getAllSpaces();
        Iterator<Space> itr = spaces.iterator();
        while (itr.hasNext()) {
            Space space = itr.next();
            if (!space.getVisibility().equals("hidden") && !this.isMember(space, userId) && !this.isInvited(space, userId) && !this.isPending(space, userId)) continue;
            itr.remove();
        }
        return spaces;
    }

    @Override
    public List<Space> getPendingSpaces(String userId) throws SpaceException {
        List<Space> spaces = this.getAllSpaces();
        Iterator<Space> itr = spaces.iterator();
        while (itr.hasNext()) {
            Space space = itr.next();
            if (this.isPending(space, userId)) continue;
            itr.remove();
        }
        return spaces;
    }

    @Override
    public Space createSpace(Space space, String creator) throws SpaceException {
        return this.createSpace(space, creator, null);
    }

    @Override
    public Space createSpace(Space space, String creator, String groupId) throws SpaceException {
        if (groupId == null) {
            groupId = SpaceUtils.createGroup(space.getName(), creator);
        } else {
            if (SpaceUtils.isSpaceNameExisted(space.getName())) {
                throw new SpaceException(SpaceException.Code.SPACE_ALREADY_EXIST);
            }
            SpaceUtils.addCreatorToGroup(creator, groupId);
        }
        space.setGroupId(groupId);
        space.setUrl(SpaceUtils.cleanString(space.getName()));
        this.saveSpace(space, true);
        this.spaceLifeCycle.spaceCreated(space, creator);
        return space;
    }

    @Override
    public void saveSpace(Space space, boolean isNew) throws SpaceException {
        try {
            this.storage.saveSpace(space, isNew);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    @Override
    public void deleteSpace(Space space) throws SpaceException {
        try {
            SpaceApplicationHandler appHander = this.getSpaceApplicationHandler(space);
            appHander.removeApplications(space);
            appHander.deInitApp(space);
            this.storage.deleteSpace(space.getId());
            OrganizationService orgService = this.getOrgService();
            UserACL acl = this.getUserACL();
            GroupHandler groupHandler = orgService.getGroupHandler();
            Group deletedGroup = groupHandler.findGroupById(space.getGroupId());
            List mandatories = acl.getMandatoryGroups();
            if (!this.isMandatory(groupHandler, deletedGroup, mandatories)) {
                SpaceUtils.removeGroup(space);
            }
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_DELETE_SPACE, (Throwable)e);
        }
        this.spaceLifeCycle.spaceRemoved(space, null);
    }

    @Override
    public void deleteSpace(String spaceId) throws SpaceException {
        this.deleteSpace(this.getSpaceById(spaceId));
    }

    @Override
    public void initApp(Space space) throws SpaceException {
        SpaceApplicationHandler spaceAppHandler = this.getSpaceApplicationHandler(space);
        spaceAppHandler.initApp(space, this.homeNodeApp, this.apps);
        for (String app : this.apps) {
            String[] splited = (app = app.trim()).split(":");
            if (splited.length != 2) {
                logger.error((Object)"app has problem with status value of form: [appId:isRemovable]");
                return;
            }
            boolean isRemovable = splited[1].equals("true");
            this.setApp(space, splited[0], splited[0], isRemovable, "active");
        }
    }

    @Override
    public void addMember(Space space, String userId) throws SpaceException {
        OrganizationService orgService = this.getOrgService();
        try {
            UserHandler userHandler = orgService.getUserHandler();
            User user = userHandler.findUserByName(userId);
            MembershipType mbShipType = orgService.getMembershipTypeHandler().findMembershipType(MEMBER);
            MembershipHandler membershipHandler = orgService.getMembershipHandler();
            Group spaceGroup = orgService.getGroupHandler().findGroupById(space.getGroupId());
            membershipHandler.linkMembership(user, spaceGroup, mbShipType, true);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_ADD_USER, (Throwable)e);
        }
        this.spaceLifeCycle.memberJoigned(space, userId);
    }

    @Override
    public void addMember(String spaceId, String userId) throws SpaceException {
        this.addMember(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void removeMember(Space space, String userId) throws SpaceException {
        block4: {
            try {
                OrganizationService orgService = this.getOrgService();
                String groupID = space.getGroupId();
                MembershipHandler memberShipHandler = orgService.getMembershipHandler();
                Collection memberships = memberShipHandler.findMembershipsByUserAndGroup(userId, groupID);
                if (memberships.size() == 0) {
                    throw new SpaceException(SpaceException.Code.USER_NOT_MEMBER);
                }
                for (Membership mbShip : memberships) {
                    memberShipHandler.removeMembership(mbShip.getId(), true);
                }
            }
            catch (Exception e) {
                if (!(e instanceof SpaceException)) break block4;
                throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_USER, (Throwable)e);
            }
        }
        this.spaceLifeCycle.memberLeft(space, userId);
    }

    @Override
    public void removeMember(String spaceId, String userId) throws SpaceException {
        this.removeMember(this.getSpaceById(spaceId), userId);
    }

    private Space addPending(Space space, String userId) throws SpaceException {
        space.setPendingUsers(this.addItemToArray(space.getPendingUsers(), userId));
        return space;
    }

    private Space removePending(Space space, String userId) throws SpaceException {
        space.setPendingUsers(this.removeItemFromArray(space.getPendingUsers(), userId));
        return space;
    }

    private Space addInvited(Space space, String userId) throws SpaceException {
        space.setInvitedUsers(this.addItemToArray(space.getInvitedUsers(), userId));
        return space;
    }

    private Space removeInvited(Space space, String userId) throws SpaceException {
        space.setInvitedUsers(this.removeItemFromArray(space.getInvitedUsers(), userId));
        return space;
    }

    @Override
    public List<String> getMembers(Space space) throws SpaceException {
        try {
            OrganizationService orgService = this.getOrgService();
            Group group = orgService.getGroupHandler().findGroupById(space.getGroupId());
            Collection memberships = orgService.getMembershipHandler().findMembershipsByGroup(group);
            Iterator itr = memberships.iterator();
            ArrayList<String> userNames = new ArrayList<String>();
            while (itr.hasNext()) {
                Membership membership = (Membership)itr.next();
                String userName = membership.getUserName();
                if (userNames.contains(userName)) continue;
                userNames.add(userName);
            }
            return userNames;
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_RETRIEVING_MEMBER_LIST, (Throwable)e);
        }
    }

    @Override
    public List<String> getMembers(String spaceId) throws SpaceException {
        return this.getMembers(this.getSpaceById(spaceId));
    }

    @Override
    public void setLeader(Space space, String userId, boolean isLeader) throws SpaceException {
        try {
            OrganizationService orgService = this.getOrgService();
            UserHandler userHandler = orgService.getUserHandler();
            User user = userHandler.findUserByName(userId);
            MembershipHandler membershipHandler = orgService.getMembershipHandler();
            if (isLeader) {
                Membership memberShipMember = membershipHandler.findMembershipByUserGroupAndType(user.getUserName(), space.getGroupId(), MEMBER);
                membershipHandler.removeMembership(memberShipMember.getId(), true);
                MembershipType mbshipTypeManager = orgService.getMembershipTypeHandler().findMembershipType(MANAGER);
                GroupHandler groupHandler = orgService.getGroupHandler();
                membershipHandler.linkMembership(user, groupHandler.findGroupById(space.getGroupId()), mbshipTypeManager, true);
            } else {
                Membership memberShip = membershipHandler.findMembershipByUserGroupAndType(user.getUserName(), space.getGroupId(), MANAGER);
                membershipHandler.removeMembership(memberShip.getId(), true);
                MembershipType mbShipTypeMember = orgService.getMembershipTypeHandler().findMembershipType(MEMBER);
                GroupHandler groupHandler = orgService.getGroupHandler();
                membershipHandler.linkMembership(user, groupHandler.findGroupById(space.getGroupId()), mbShipTypeMember, true);
            }
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_SETTING_LEADER_STATUS, (Throwable)e);
        }
        if (isLeader) {
            this.spaceLifeCycle.grantedLead(space, userId);
        } else {
            this.spaceLifeCycle.revokedLead(space, userId);
        }
    }

    @Override
    public void setLeader(String spaceId, String userId, boolean isLeader) throws SpaceException {
        this.setLeader(this.getSpaceById(spaceId), userId, isLeader);
    }

    @Override
    public boolean isLeader(Space space, String userId) throws SpaceException {
        try {
            OrganizationService orgService = this.getOrgService();
            MembershipHandler memberShipHandler = orgService.getMembershipHandler();
            return memberShipHandler.findMembershipByUserGroupAndType(userId, space.getGroupId(), MANAGER) != null;
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_RETRIEVING_MEMBER_LIST, (Throwable)e);
        }
    }

    @Override
    public boolean isLeader(String spaceId, String userId) throws SpaceException {
        return this.isLeader(this.getSpaceById(spaceId), userId);
    }

    @Override
    public boolean isOnlyLeader(Space space, String userId2) throws SpaceException {
        boolean isOnlyLeader = true;
        if (!this.isLeader(space, userId2)) {
            return false;
        }
        List<String> members = this.getMembers(space);
        members.remove(userId2);
        for (String userId2 : members) {
            if (!this.isLeader(space, userId2)) continue;
            return false;
        }
        return isOnlyLeader;
    }

    @Override
    public boolean isOnlyLeader(String spaceId, String userId) throws SpaceException {
        return this.isOnlyLeader(this.getSpaceById(spaceId), userId);
    }

    @Override
    public boolean isMember(Space space, String userId) throws SpaceException {
        try {
            OrganizationService orgService = this.getOrgService();
            MembershipHandler memberShipHandler = orgService.getMembershipHandler();
            return memberShipHandler.findMembershipsByUserAndGroup(userId, space.getGroupId()).size() > 0;
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_RETRIEVING_MEMBER_LIST, (Throwable)e);
        }
    }

    @Override
    public boolean isMember(String spaceId, String userId) throws SpaceException {
        return this.isMember(this.getSpaceById(spaceId), userId);
    }

    @Override
    public boolean hasAccessPermission(Space space, String userId) throws SpaceException {
        if (userId.equals(this.getUserACL().getSuperUser())) {
            return true;
        }
        return this.isMember(space, userId);
    }

    @Override
    public boolean hasAccessPermission(String spaceId, String userId) throws SpaceException {
        return this.hasAccessPermission(this.getSpaceById(spaceId), userId);
    }

    @Override
    public boolean hasEditPermission(Space space, String userId) throws SpaceException {
        if (userId.equals(this.getUserACL().getSuperUser())) {
            return true;
        }
        return this.isLeader(space, userId);
    }

    @Override
    public boolean hasEditPermission(String spaceId, String userId) throws SpaceException {
        return this.hasEditPermission(this.getSpaceById(spaceId), userId);
    }

    @Override
    public boolean isInvited(Space space, String userId) {
        String[] invitedUsers = space.getInvitedUsers();
        if (invitedUsers == null) {
            return false;
        }
        for (String user : invitedUsers) {
            if (!user.equals(userId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInvited(String spaceId, String userId) throws SpaceException {
        return this.isInvited(this.getSpaceById(spaceId), userId);
    }

    @Override
    public boolean isPending(Space space, String userId) {
        String[] pendingUsers = space.getPendingUsers();
        if (pendingUsers == null) {
            return false;
        }
        for (String user : pendingUsers) {
            if (!user.equals(userId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPending(String spaceId, String userId) throws SpaceException {
        return this.isPending(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void installApplication(String spaceId, String appId) throws SpaceException {
        this.installApplication(this.getSpaceById(spaceId), appId);
    }

    @Override
    public void installApplication(Space space, String appId) throws SpaceException {
        this.spaceLifeCycle.addApplication(space, appId);
    }

    @Override
    public void activateApplication(Space space, String appId) throws SpaceException {
        String appName = null;
        appName = SpaceUtils.isInstalledApp(space, appId) ? appId + System.currentTimeMillis() : appId;
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
        this.setApp(space, appId, appName, SpaceUtils.isRemovableApp(space, appId), "active");
        appHandler.activateApplication(space, appId, appName);
        this.spaceLifeCycle.activateApplication(space, appId);
    }

    @Override
    public void activateApplication(String spaceId, String appId) throws SpaceException {
        this.activateApplication(this.getSpaceById(spaceId), appId);
    }

    @Override
    public void deactivateApplication(Space space, String appId) throws SpaceException {
        String appStatus = SpaceUtils.getAppStatus(space, appId);
        if (appStatus == null) {
            logger.warn((Object)"appStatus is null!");
            return;
        }
        if (appStatus.equals("deactive")) {
            return;
        }
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
        appHandler.deactiveApplication(space, appId);
        this.setApp(space, appId, appId, SpaceUtils.isRemovableApp(space, appId), "deactive");
        this.spaceLifeCycle.deactivateApplication(space, appId);
    }

    @Override
    public void deactivateApplication(String spaceId, String appId) throws SpaceException {
        this.deactivateApplication(this.getSpaceById(spaceId), appId);
    }

    @Override
    public void removeApplication(Space space, String appId, String appName) throws SpaceException {
        String appStatus = SpaceUtils.getAppStatus(space, appId);
        if (appStatus == null) {
            return;
        }
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
        appHandler.removeApplication(space, appId, appName);
        this.removeApp(space, appId, appName);
        this.spaceLifeCycle.removeApplication(space, appId);
    }

    @Override
    public void removeApplication(String spaceId, String appId, String appName) throws SpaceException {
        this.removeApplication(this.getSpaceById(spaceId), appId, appName);
    }

    @Override
    public void requestJoin(String spaceId, String userId) throws SpaceException {
        this.requestJoin(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void requestJoin(Space space, String userId) throws SpaceException {
        if (this.isInvited(space, userId)) {
            this.addMember(space, userId);
            space = this.removeInvited(space, userId);
            this.saveSpace(space, false);
            return;
        }
        String registration = space.getRegistration();
        String visibility = space.getVisibility();
        if (visibility.equals("hidden")) {
            throw new SpaceException(SpaceException.Code.UNABLE_REQUEST_TO_JOIN_HIDDEN);
        }
        if (registration.equals("open")) {
            this.addMember(space, userId);
        } else if (registration.equals("validation")) {
            space = this.addPending(space, userId);
            this.saveSpace(space, false);
        } else {
            throw new SpaceException(SpaceException.Code.UNABLE_REQUEST_TO_JOIN);
        }
    }

    @Override
    public void revokeRequestJoin(Space space, String userId) throws SpaceException {
        if (this.isPending(space, userId)) {
            space = this.removePending(space, userId);
            this.saveSpace(space, false);
        }
    }

    @Override
    public void revokeRequestJoin(String spaceId, String userId) throws SpaceException {
        this.revokeRequestJoin(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void inviteMember(Space space, String userId) throws SpaceException {
        OrganizationService orgService = this.getOrgService();
        try {
            User user = orgService.getUserHandler().findUserByName(userId);
            if (user == null) {
                throw new SpaceException(SpaceException.Code.USER_NOT_EXIST);
            }
        }
        catch (Exception e) {
            if (e instanceof SpaceException) {
                throw (SpaceException)e;
            }
            throw new SpaceException(SpaceException.Code.ERROR_RETRIEVING_USER, (Throwable)e);
        }
        if (this.isInvited(space, userId)) {
            throw new SpaceException(SpaceException.Code.USER_ALREADY_INVITED);
        }
        if (this.isMember(space, userId) && !userId.equals(this.getUserACL().getSuperUser())) {
            throw new SpaceException(SpaceException.Code.USER_ALREADY_MEMBER);
        }
        if (this.isPending(space, userId)) {
            space = this.removePending(space, userId);
            this.addMember(space, userId);
        } else {
            space = this.addInvited(space, userId);
        }
        this.saveSpace(space, false);
    }

    @Override
    public void inviteMember(String spaceId, String userId) throws SpaceException {
        this.inviteMember(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void revokeInvitation(Space space, String userId) throws SpaceException {
        if (!this.isInvited(space, userId)) {
            throw new SpaceException(SpaceException.Code.USER_NOT_INVITED);
        }
        space = this.removeInvited(space, userId);
        this.saveSpace(space, false);
    }

    @Override
    public void revokeInvitation(String spaceId, String userId) throws SpaceException {
        this.revokeInvitation(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void acceptInvitation(Space space, String userId) throws SpaceException {
        if (!this.isInvited(space, userId)) {
            throw new SpaceException(SpaceException.Code.USER_NOT_INVITED);
        }
        space = this.removeInvited(space, userId);
        this.saveSpace(space, false);
        this.addMember(space, userId);
    }

    @Override
    public void acceptInvitation(String spaceId, String userId) throws SpaceException {
        this.acceptInvitation(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void denyInvitation(String spaceId, String userId) throws SpaceException {
        this.denyInvitation(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void denyInvitation(Space space, String userId) throws SpaceException {
        if (!this.isInvited(space, userId)) {
            throw new SpaceException(SpaceException.Code.USER_NOT_INVITED);
        }
        space = this.removeInvited(space, userId);
        this.saveSpace(space, false);
    }

    @Override
    public void validateRequest(Space space, String userId) throws SpaceException {
        space = this.removePending(space, userId);
        this.saveSpace(space, false);
        this.addMember(space, userId);
    }

    @Override
    public void validateRequest(String spaceId, String userId) throws SpaceException {
        this.validateRequest(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void declineRequest(Space space, String userId) throws SpaceException {
        space = this.removePending(space, userId);
        this.saveSpace(space, false);
    }

    @Override
    public void declineRequest(String spaceId, String userId) throws SpaceException {
        this.declineRequest(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void registerSpaceLifeCycleListener(SpaceLifeCycleListener listener) {
        this.spaceLifeCycle.addListener(listener);
    }

    @Override
    public void unregisterSpaceLifeCycleListener(SpaceLifeCycleListener listener) {
        this.spaceLifeCycle.removeListener(listener);
    }

    public void addSpaceListener(SpaceListenerPlugin plugin) {
        this.registerSpaceLifeCycleListener(plugin);
    }

    private OrganizationService getOrgService() {
        if (this.orgService == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.orgService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        }
        return this.orgService;
    }

    private UserACL getUserACL() {
        if (this.userACL == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            return (UserACL)container.getComponentInstanceOfType(UserACL.class);
        }
        return this.userACL;
    }

    private Map<String, SpaceApplicationHandler> getSpaceApplicationHandlers() {
        if (this.spaceApplicationHandlers == null) {
            this.spaceApplicationHandlers = new HashMap<String, SpaceApplicationHandler>();
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            DefaultSpaceApplicationHandler appHandler = (DefaultSpaceApplicationHandler)container.getComponentInstanceOfType(DefaultSpaceApplicationHandler.class);
            this.spaceApplicationHandlers.put(appHandler.getName(), appHandler);
        }
        return this.spaceApplicationHandlers;
    }

    private SpaceApplicationHandler getSpaceApplicationHandler(Space space) throws SpaceException {
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandlers().get(space.getType());
        if (appHandler == null) {
            throw new SpaceException(SpaceException.Code.UNKNOWN_SPACE_TYPE);
        }
        return appHandler;
    }

    public void setApp(Space space, String appId, String appName, boolean isRemovable, String status) throws SpaceException {
        String apps = space.getApp();
        String applicationStatus = appId + ":" + appName;
        applicationStatus = isRemovable ? applicationStatus + ":true" : applicationStatus + ":false";
        applicationStatus = applicationStatus + ":" + status;
        apps = apps == null ? applicationStatus : apps + "," + applicationStatus;
        space.setApp(apps);
        this.saveSpace(space, false);
    }

    private void removeApp(Space space, String appId, String appName) throws SpaceException {
        String apps = space.getApp();
        StringBuffer remainApp = new StringBuffer();
        String[] listApp = apps.split(",");
        for (int idx = 0; idx < listApp.length; ++idx) {
            String app = listApp[idx];
            String[] appPart = app.split(":");
            if (appPart[1].equals(appName)) continue;
            if (remainApp.length() != 0) {
                remainApp.append(",");
            }
            remainApp.append(app);
        }
        space.setApp(remainApp.toString());
        this.saveSpace(space, false);
    }

    private String[] removeItemFromArray(String[] arrays, String str) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(arrays));
        list.remove(str);
        if (list.size() > 0) {
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    private String[] addItemToArray(String[] arrays, String str) {
        ArrayList<String> list = new ArrayList<String>();
        if (arrays != null && arrays.length > 0) {
            list.addAll(Arrays.asList(arrays));
            list.add(str);
            return list.toArray(new String[list.size()]);
        }
        return new String[]{str};
    }

    private boolean isMandatory(GroupHandler groupHandler, Group group, List<String> mandatories) throws Exception {
        if (mandatories.contains(group.getId())) {
            return true;
        }
        Collection children = groupHandler.findGroups(group);
        for (Group g : children) {
            if (!this.isMandatory(groupHandler, g, mandatories)) continue;
            return true;
        }
        return false;
    }

    public JCRStorage getStorage() {
        return this.storage;
    }

    public void setStorage(JCRStorage storage) {
        this.storage = storage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SpaceComparator
    implements Comparator<Space> {
        private SpaceComparator() {
        }

        @Override
        public int compare(Space space1, Space space2) {
            return space1.getName().compareToIgnoreCase(space2.getName());
        }
    }
}

