/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.pooled.interfaces;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.rmi.Remote;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteStub;
import org.jboss.invocation.pooled.interfaces.CompatibilityVersion;

public class OptimizedObjectOutputStream
extends ObjectOutputStream {
    public OptimizedObjectOutputStream(OutputStream os) throws IOException {
        super(os);
        this.enableReplaceObject(true);
    }

    protected void writeClassDescriptor(ObjectStreamClass classdesc) throws IOException {
        if (CompatibilityVersion.pooledInvokerLegacy) {
            this.writeUTF(classdesc.getName());
        } else {
            super.writeClassDescriptor(classdesc);
        }
    }

    protected Object replaceObject(Object obj) throws IOException {
        if (obj instanceof Remote && !(obj instanceof RemoteStub)) {
            Remote remote = (Remote)obj;
            try {
                obj = RemoteObject.toStub(remote);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return obj;
    }
}

