/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.query.lucene.ComparableBoolean;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexFormatVersion;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrTermQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.LazyTextExtractorField;
import org.exoplatform.services.jcr.impl.core.query.lucene.MatchAllQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.ReleaseableIndexReader;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataConvertor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger log = LoggerFactory.getLogger(Util.class);

    public static void disposeDocument(Document old) {
        for (Fieldable f : old.getFields()) {
            try {
                if (f.readerValue() != null) {
                    f.readerValue().close();
                    continue;
                }
                if (!(f instanceof LazyTextExtractorField)) continue;
                LazyTextExtractorField field = (LazyTextExtractorField)f;
                field.dispose();
            }
            catch (IOException ex) {
                log.warn("Exception while disposing index document: " + ex);
            }
        }
    }

    public static boolean isDocumentReady(Document doc) {
        for (Fieldable f : doc.getFields()) {
            LazyTextExtractorField field;
            if (!(f instanceof LazyTextExtractorField) || (field = (LazyTextExtractorField)f).isExtractorFinished()) continue;
            return false;
        }
        return true;
    }

    public static Query createMatchAllQuery(String name, IndexFormatVersion version) {
        if (version.getVersion() >= IndexFormatVersion.V2.getVersion()) {
            return new JcrTermQuery(new Term(FieldNames.PROPERTIES_SET, name));
        }
        return new MatchAllQuery(name);
    }

    public static IOException createIOException(Throwable t) {
        IOException ex = new IOException(t.getMessage());
        ex.initCause(t);
        return ex;
    }

    public static void closeOrRelease(IndexReader reader) throws IOException {
        if (reader instanceof ReleaseableIndexReader) {
            ((ReleaseableIndexReader)reader).release();
        } else {
            reader.close();
        }
    }

    public static Comparable getComparable(ValueData value, int type) throws UnsupportedEncodingException, IllegalStateException, ValueFormatException, IOException, IllegalNameException {
        switch (type) {
            case 2: {
                return null;
            }
            case 6: {
                return ComparableBoolean.valueOf(ValueDataConvertor.readBoolean(value));
            }
            case 5: {
                return new Long(ValueDataConvertor.readDate(value).getTimeInMillis());
            }
            case 4: {
                return new Double(ValueDataConvertor.readDouble(value));
            }
            case 3: {
                return new Long(ValueDataConvertor.readLong(value));
            }
            case 7: {
                return new QPathEntry(ValueDataConvertor.readQName(value), 1);
            }
            case 1: 
            case 8: 
            case 9: {
                return ValueDataConvertor.readString(value);
            }
        }
        return null;
    }

    public static Comparable getComparable(Value value) throws ValueFormatException, RepositoryException {
        switch (value.getType()) {
            case 6: {
                return ComparableBoolean.valueOf(value.getBoolean());
            }
            case 5: {
                return new Long(value.getDate().getTimeInMillis());
            }
            case 4: {
                return new Double(value.getDouble());
            }
            case 3: {
                return new Long(value.getLong());
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                return value.getString();
            }
        }
        throw new RepositoryException("Unsupported type: " + PropertyType.nameFromValue((int)value.getType()));
    }

    public static int compare(Comparable c1, Comparable c2) {
        if (c1 == c2) {
            return 0;
        }
        if (c1 == null) {
            return -1;
        }
        if (c2 == null) {
            return 1;
        }
        if (c1.getClass() == c2.getClass()) {
            return c1.compareTo(c2);
        }
        String name1 = c1.getClass().getName();
        String name2 = c2.getClass().getName();
        return name1.compareTo(name2);
    }

    public static int compare(Value v1, Value v2) throws ValueFormatException, RepositoryException {
        Object c2;
        Comparable c1 = Util.getComparable(v1);
        switch (v1.getType()) {
            case 6: {
                c2 = ComparableBoolean.valueOf(v2.getBoolean());
                break;
            }
            case 5: {
                c2 = new Long(v2.getDate().getTimeInMillis());
                break;
            }
            case 4: {
                c2 = new Double(v2.getDouble());
                break;
            }
            case 3: {
                c2 = new Long(v2.getLong());
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                c2 = v2.getString();
                break;
            }
            default: {
                throw new RepositoryException("Unsupported type: " + PropertyType.nameFromValue((int)v2.getType()));
            }
        }
        return Util.compare(c1, (Comparable)c2);
    }

    public static Pattern createRegexp(String likePattern) {
        StringBuffer regexp = new StringBuffer();
        boolean escaped = false;
        block4: for (int i = 0; i < likePattern.length(); ++i) {
            if (likePattern.charAt(i) == '\\') {
                if (escaped) {
                    regexp.append("\\\\");
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (Character.isLetterOrDigit(likePattern.charAt(i))) {
                if (escaped) {
                    regexp.append("\\\\").append(likePattern.charAt(i));
                    escaped = false;
                    continue;
                }
                regexp.append(likePattern.charAt(i));
                continue;
            }
            if (escaped) {
                regexp.append('\\').append(likePattern.charAt(i));
                escaped = false;
                continue;
            }
            switch (likePattern.charAt(i)) {
                case '_': {
                    regexp.append('.');
                    continue block4;
                }
                case '%': {
                    regexp.append(".*");
                    continue block4;
                }
                default: {
                    regexp.append('\\').append(likePattern.charAt(i));
                }
            }
        }
        return Pattern.compile(regexp.toString(), 32);
    }

    public static long getLength(ValueData value, int propType) {
        if (propType == 2) {
            return value.getLength();
        }
        if (propType == 7 || propType == 8) {
            return -1L;
        }
        return value.toString().length();
    }
}

