/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.fileupload.RequestContext;
import org.gatein.common.util.ParameterMap;
import org.gatein.wsrp.producer.MarkupRequest;
import org.oasis.wsrp.v1.InteractionParams;
import org.oasis.wsrp.v1.NamedString;
import org.oasis.wsrp.v1.UploadContext;

abstract class WSRPRequestContext
implements org.gatein.pc.api.spi.RequestContext,
RequestContext {
    protected String characterEncoding;

    protected WSRPRequestContext(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public int getContentLength() {
        throw new UnsupportedOperationException("Not currently supported");
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException("Not currently supported");
    }

    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("Not currently supported");
    }

    public abstract ParameterMap getForm();

    public static WSRPRequestContext createRequestContext(MarkupRequest markupRequest, InteractionParams interactionParams) {
        List formParams = interactionParams.getFormParameters();
        List uploadContexts = interactionParams.getUploadContexts();
        if (uploadContexts != null && !uploadContexts.isEmpty()) {
            try {
                return new WSRPMultiRequestContext(markupRequest.getCharacterSet(), formParams, uploadContexts);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid upload contexts", e);
            }
        }
        return new WSRPSimpleRequestContext(markupRequest.getCharacterSet(), markupRequest.getMediaType(), formParams);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WSRPMultiRequestContext
    extends WSRPRequestContext {
        private byte[] content;
        private boolean usingStream;
        private boolean usingReader;
        private String contentType;

        protected WSRPMultiRequestContext(String characterEncoding, List<NamedString> formParams, List<UploadContext> uploadContexts) throws IOException, MessagingException {
            super(characterEncoding);
            MimeMultipart parts = new MimeMultipart();
            if (uploadContexts != null && !uploadContexts.isEmpty()) {
                for (UploadContext uploadContext : uploadContexts) {
                    InternetHeaders headers = new InternetHeaders();
                    headers.addHeader("Content-type", uploadContext.getMimeType());
                    List attributes = uploadContext.getMimeAttributes();
                    if (attributes != null && !attributes.isEmpty()) {
                        for (NamedString attribute : attributes) {
                            headers.addHeader(attribute.getName(), attribute.getValue());
                        }
                    }
                    MimeBodyPart mimeBodyPart = new MimeBodyPart(headers, uploadContext.getUploadData());
                    parts.addBodyPart((BodyPart)mimeBodyPart);
                }
            }
            String paramContentDispositionHeader = "form-data; name=\"";
            if (formParams != null) {
                for (NamedString formParam : formParams) {
                    InternetHeaders headers = new InternetHeaders();
                    StringBuffer paramContentDisposition = new StringBuffer("form-data; name=\"");
                    paramContentDisposition.append(formParam.getName()).append("\"");
                    headers.addHeader("Content-disposition", paramContentDisposition.toString());
                    MimeBodyPart mimeBodyPart = new MimeBodyPart(headers, formParam.getValue().getBytes());
                    parts.addBodyPart((BodyPart)mimeBodyPart);
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            parts.writeTo((OutputStream)baos);
            this.content = baos.toByteArray();
            this.contentType = parts.getContentType();
        }

        @Override
        public ParameterMap getForm() {
            return new ParameterMap();
        }

        public String getContentType() {
            return this.contentType;
        }

        @Override
        public int getContentLength() {
            return this.content.length;
        }

        @Override
        public BufferedReader getReader() throws IOException {
            if (this.usingStream) {
                throw new IllegalStateException("getInputStream has already been called on this ActionContext!");
            }
            this.usingReader = true;
            return new BufferedReader(new InputStreamReader(this.getInputStreamFromContent()));
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.usingReader) {
                throw new IllegalStateException("getReader has already been called on this ActionContext!");
            }
            this.usingStream = true;
            return this.getInputStreamFromContent();
        }

        private InputStream getInputStreamFromContent() {
            return new ByteArrayInputStream(this.content);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WSRPSimpleRequestContext
    extends WSRPRequestContext {
        private ParameterMap formParameters;
        private String contentType;

        protected WSRPSimpleRequestContext(String characterEncoding, String contentType, List<NamedString> formParams) {
            super(characterEncoding);
            this.contentType = contentType;
            if (formParams != null && !formParams.isEmpty()) {
                HashMap<String, String[]> params = new HashMap<String, String[]>(formParams.size());
                for (NamedString formParam : formParams) {
                    String paramName = formParam.getName();
                    String paramValue = formParam.getValue();
                    if (params.containsKey(paramName)) {
                        String[] oldValues = (String[])params.get(paramName);
                        int valuesLength = oldValues.length;
                        String[] newValues = new String[valuesLength + 1];
                        System.arraycopy(oldValues, 0, newValues, 0, valuesLength);
                        newValues[valuesLength] = paramValue;
                        params.put(paramName, newValues);
                    } else {
                        params.put(paramName, new String[]{paramValue});
                    }
                    this.formParameters = new ParameterMap(params);
                }
            } else {
                this.formParameters = new ParameterMap();
            }
        }

        @Override
        public ParameterMap getForm() {
            return this.formParameters;
        }

        public String getContentType() {
            return this.contentType;
        }
    }
}

