/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.application.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Dashboard;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.pom.config.Utils;
import org.exoplatform.portal.pom.spi.gadget.Gadget;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.PortletBuilder;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.social.application.SpaceApplicationHandler;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceException;
import org.exoplatform.social.space.SpaceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSpaceApplicationHandler
implements SpaceApplicationHandler {
    public static final String NAME = "classic";
    public static final String SPACE_TEMPLATE_PAGE_ID = "portal::classic::spacetemplate";
    public static final String APPLICATION_CONTAINER = "Application";
    private ExoContainer container = ExoContainerContext.getCurrentContainer();
    private DataStorage dataStorage = (DataStorage)this.container.getComponentInstanceOfType(DataStorage.class);
    private static Map<ApplicationCategory, List<Application>> appStoreCache = null;
    private static List<Application> appCache = new ArrayList<Application>();

    @Override
    public void initApp(Space space, String homeNodeApp, List<String> apps) throws SpaceException {
        try {
            PageNavigation spaceNav = SpaceUtils.createGroupNavigation(space.getGroupId());
            PageNode homeNode = this.createPageNodeFromApplication(space, homeNodeApp, null, true);
            ArrayList<PageNode> childNodes = homeNode.getChildren();
            if (childNodes == null) {
                childNodes = new ArrayList<PageNode>();
            }
            PageNode dashBoardPageNode = null;
            for (String app : apps) {
                app = app.trim().split(":")[0];
                PageNode appNode = this.createPageNodeFromApplication(space, app, null, false);
                if ("DashboardPortlet".equals(app)) {
                    dashBoardPageNode = appNode;
                }
                childNodes.add(appNode);
            }
            spaceNav.addNode(homeNode);
            this.dataStorage.save(spaceNav);
            this.changeDashBoardColumn(dashBoardPageNode);
            SpaceUtils.setNavigation(spaceNav);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_INIT_APP, (Throwable)e);
        }
    }

    @Override
    public void deInitApp(Space space) throws SpaceException {
        try {
            String groupId = space.getGroupId();
            PageNavigation spaceNav = SpaceUtils.getGroupNavigation(groupId);
            if (spaceNav == null) {
                return;
            }
            ArrayList spaceNodes = spaceNav.getNodes();
            for (PageNode spaceNode : spaceNodes) {
                String pageId = spaceNode.getPageReference();
                Page page = this.dataStorage.getPage(pageId);
                this.dataStorage.remove(page);
            }
            SpaceUtils.removeGroupNavigation(groupId);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_DEINIT_APP, (Throwable)e);
        }
    }

    @Override
    public void activateApplication(Space space, String appId, String appName) throws SpaceException {
        this.activateApplicationClassic(space, appId, appName);
    }

    @Override
    public void deactiveApplication(Space space, String appId) throws SpaceException {
        this.deactivateApplicationClassic(space, appId);
    }

    @Override
    public void installApplication(Space space, String appId) throws SpaceException {
    }

    @Override
    public void removeApplication(Space space, String appId, String appName) throws SpaceException {
        this.removeApplicationClassic(space, appId, appName);
    }

    @Override
    public void removeApplications(Space space) throws SpaceException {
        try {
            String[] apps = space.getApp().split(",");
            String[] appPart = null;
            for (int i = 0; i < apps.length; ++i) {
                appPart = apps[i].split(":");
                this.removeApplication(space, appPart[0], appPart[1]);
            }
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_APPLICATIONS, (Throwable)e);
        }
    }

    private List<Application> getSpaceApplications(Space space) throws Exception {
        List<Application> allApps = SpaceUtils.getApplications(space.getGroupId());
        ArrayList<Application> appList = new ArrayList<Application>();
        String spaceApps = space.getApp();
        if (spaceApps != null) {
            String[] apps;
            block0: for (String obj : apps = spaceApps.split(",")) {
                String appId = obj.split(":")[0];
                for (Application app : allApps) {
                    if (!app.getApplicationName().equals(appId)) continue;
                    appList.add(app);
                    continue block0;
                }
            }
        }
        return appList;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void activateApplicationClassic(Space space, String appId, String appName) throws SpaceException {
        PageNavigation nav = SpaceUtils.createGroupNavigation(space.getGroupId());
        PageNode pageNode = this.createPageNodeFromApplication(space, appId, appName, false);
        UIPortal uiPortal = Util.getUIPortal();
        PageNode selectedNode = null;
        try {
            selectedNode = uiPortal.getSelectedNode();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
        UserPortalConfig userPortalConfig = uiPortalApp.getUserPortalConfig();
        List navigations = userPortalConfig.getNavigations();
        for (PageNavigation navi : navigations) {
            if (!navi.getOwner().equals(nav.getOwner())) continue;
            nav = navi;
            break;
        }
        try {
            PageNode homeNode = SpaceUtils.getHomeNode(nav, space.getUrl());
            if (homeNode == null) {
                throw new Exception("homeNode is null!");
            }
            ArrayList<PageNode> childNodes = homeNode.getChildren();
            if (childNodes == null) {
                childNodes = new ArrayList<PageNode>();
            }
            childNodes.add(pageNode);
            this.dataStorage.save(nav);
            if ("DashboardPortlet".equals(appId)) {
                this.changeDashBoardColumn(pageNode);
            }
            uiPortal.setSelectedNode(selectedNode);
            uiPortal.setSelectedNavigation(nav);
            SpaceUtils.setNavigation(nav);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_ADD_APPLICATION, (Throwable)e);
        }
    }

    private void deactivateApplicationClassic(Space space, String appId) {
    }

    private void removeApplicationClassic(Space space, String appId, String appName) throws SpaceException {
        try {
            String groupId = space.getGroupId();
            PageNavigation nav = this.dataStorage.getPageNavigation("group", groupId);
            if (nav == null) {
                return;
            }
            PageNode homeNode = SpaceUtils.getHomeNode(nav, space.getUrl());
            if (homeNode == null) {
                throw new Exception("homeNode is null!");
            }
            List childNodes = homeNode.getChildren();
            String nodeName = appName;
            PageNode childNode = homeNode.getChild(nodeName);
            if (childNode == null) {
                for (PageNode pageNode : homeNode.getChildren()) {
                    String nodeUri = pageNode.getUri();
                    if (!(nodeUri = nodeUri.substring(nodeUri.indexOf("/") + 1)).equals(nodeName)) continue;
                    childNode = pageNode;
                    break;
                }
            }
            if (childNode == null) {
                nodeName = space.getName() + nodeName;
                childNode = homeNode.getChild(nodeName);
            }
            childNodes.remove(childNode);
            this.dataStorage.save(nav);
            SpaceUtils.setNavigation(nav);
            String pageId = childNode.getPageReference();
            Page page = this.dataStorage.getPage(pageId);
            this.dataStorage.remove(page);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_APPLICATION, (Throwable)e);
        }
    }

    private Application getApplication(List<Application> apps, String appId) {
        for (Application app : apps) {
            if (!app.getApplicationName().equals(appId)) continue;
            return app;
        }
        return null;
    }

    private PageNode createPageNodeFromApplication(Space space, String appId, String appName, boolean isRoot) throws SpaceException {
        String contentId;
        String portalName = Util.getPortalRequestContext().getPortalOwner();
        Application app = this.getApplication(appCache, appId);
        if (app == null) {
            try {
                if (appStoreCache == null) {
                    appStoreCache = SpaceUtils.getAppStore(space);
                }
                if ((app = this.getApplication(appStoreCache, appId)) == null && (app = this.getApplication(appStoreCache = SpaceUtils.getAppStore(space), appId)) == null && (app = SpaceUtils.getAppFromPortalContainer(appId)) == null) {
                    throw new Exception("app is null!");
                }
                appCache.add(app);
            }
            catch (Exception e) {
                throw new SpaceException(SpaceException.Code.UNABLE_TO_LIST_AVAILABLE_APPLICATIONS, (Throwable)e);
            }
        }
        if ((contentId = app.getContentId()) == null) {
            contentId = app.getCategoryName() + "/" + app.getApplicationName();
        }
        String appInstanceId = "group#" + space.getGroupId() + ":/" + contentId + "/" + app.getApplicationName() + app.hashCode();
        org.exoplatform.portal.config.model.Application gadgetApplication = null;
        org.exoplatform.portal.config.model.Application<Portlet> portletApplication = null;
        if (app.getType() == ApplicationType.GADGET) {
            TransientApplicationState gadgetState = new TransientApplicationState(app.getApplicationName());
            gadgetApplication = org.exoplatform.portal.config.model.Application.createGadgetApplication();
            gadgetApplication.setState((ApplicationState)gadgetState);
            gadgetApplication.setAccessPermissions(new String[]{"*:" + space.getGroupId()});
            gadgetApplication.setShowInfoBar(false);
        } else {
            portletApplication = this.createPortletApplication(appInstanceId, space, isRoot);
            portletApplication.setAccessPermissions(new String[]{"*:" + space.getGroupId()});
            portletApplication.setShowInfoBar(false);
        }
        Page page = null;
        String pageName = null;
        pageName = isRoot ? space.getUrl() : (SpaceUtils.isInstalledApp(space, appId) && appName != null ? appName : app.getApplicationName());
        String newName = space.getUrl();
        try {
            if (!isRoot) {
                newName = pageName;
            }
            page = this.dataStorage.clonePage(SPACE_TEMPLATE_PAGE_ID, "group", space.getGroupId(), newName.trim());
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_CREATE_PAGE, (Throwable)e);
        }
        this.setPage(space, app, (org.exoplatform.portal.config.model.Application<Gadget>)gadgetApplication, portletApplication, page, newName, isRoot);
        try {
            try {
                this.dataStorage.save(page);
            }
            catch (Exception e) {
                Page clonedPage = this.dataStorage.getPage("portal::" + portalName + "::" + pageName);
                this.dataStorage.remove(clonedPage);
                newName = space.getName() + newName;
                pageName = space.getName() + pageName;
                page = this.dataStorage.clonePage(SPACE_TEMPLATE_PAGE_ID, "group", space.getGroupId(), newName.trim());
                this.setPage(space, app, (org.exoplatform.portal.config.model.Application<Gadget>)gadgetApplication, portletApplication, page, newName, isRoot);
                this.dataStorage.save(page);
            }
            Page clonedPage = this.dataStorage.getPage("portal::" + portalName + "::" + pageName);
            this.dataStorage.remove(clonedPage);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_CREATE_PAGE, (Throwable)e);
        }
        PageNode pageNode = new PageNode();
        String label = app.getDisplayName();
        if (appName != null) {
            String sufixLabel = pageName.replaceAll(app.getApplicationName(), "");
            label = label + sufixLabel;
        }
        if (isRoot) {
            label = space.getName();
            pageNode.setUri(pageName);
        } else {
            pageNode.setUri(space.getUrl() + "/" + pageName);
        }
        pageNode.setName(pageName);
        pageNode.setLabel(label);
        pageNode.setPageReference(page.getPageId());
        pageNode.setModifiable(true);
        return pageNode;
    }

    private void setPage(Space space, Application app, org.exoplatform.portal.config.model.Application<Gadget> gadgetApplication, org.exoplatform.portal.config.model.Application<Portlet> portletApplication, Page page, String newName, boolean isRoot) {
        page.setOwnerType("group");
        page.setOwnerId(space.getGroupId());
        page.setTitle(space.getName() + " - " + newName);
        String visibility = space.getVisibility();
        if (visibility.equals("public")) {
            page.setAccessPermissions(new String[]{"Everyone"});
        } else {
            page.setAccessPermissions(new String[]{"*:" + space.getGroupId()});
        }
        page.setEditPermission("manager:" + space.getGroupId());
        page.setModifiable(true);
        ArrayList<ModelObject> pageChilds = page.getChildren();
        Container menuContainer = SpaceUtils.findContainerById(pageChilds, "Menu");
        org.exoplatform.portal.config.model.Application menuPortlet = (org.exoplatform.portal.config.model.Application)menuContainer.getChildren().get(0);
        ApplicationState state = menuPortlet.getState();
        try {
            Portlet portletPreference = (Portlet)this.dataStorage.load(state, ApplicationType.PORTLET);
            if (portletPreference == null) {
                portletPreference = new PortletBuilder().add("SPACE_URL", space.getUrl()).build();
            } else {
                portletPreference.setValue("SPACE_URL", space.getUrl());
            }
            this.dataStorage.save(state, (Object)portletPreference);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Container container = SpaceUtils.findContainerById(pageChilds, APPLICATION_CONTAINER);
        ArrayList children = container.getChildren();
        if (app.getType() == ApplicationType.GADGET) {
            children.add(gadgetApplication);
        } else {
            children.add(portletApplication);
        }
        container.setChildren(children);
        pageChilds = this.setContainerById(pageChilds, container);
        page.setChildren(pageChilds);
        this.setPermissionForPage(page.getChildren(), "*:" + space.getGroupId());
    }

    private Application getApplication(Map<ApplicationCategory, List<Application>> appStore, String appId) {
        for (ApplicationCategory category : appStore.keySet()) {
            List appList = category.getApplications();
            for (Application app : appList) {
                if (!app.getApplicationName().equals(appId)) continue;
                return app;
            }
        }
        return null;
    }

    private void setPermissionForPage(ArrayList<ModelObject> childrens, String perm) {
        for (ModelObject modelObject : childrens) {
            if (modelObject instanceof org.exoplatform.portal.config.model.Application) {
                ((org.exoplatform.portal.config.model.Application)modelObject).setAccessPermissions(new String[]{perm});
                continue;
            }
            if (!(modelObject instanceof Container)) continue;
            ((Container)modelObject).setAccessPermissions(new String[]{perm});
            this.setPermissionForPage(((Container)modelObject).getChildren(), perm);
        }
    }

    private ArrayList<ModelObject> setContainerById(ArrayList<ModelObject> childs, Container container) {
        ArrayList<ModelObject> result = childs;
        int index = result.indexOf(container);
        if (index != -1) {
            result.set(index, (ModelObject)container);
        } else {
            for (int i = 0; i < result.size(); ++i) {
                ModelObject obj = result.get(i);
                if (org.exoplatform.portal.config.model.Application.class.isInstance(obj)) continue;
                Container objContainer = (Container)obj;
                ArrayList<ModelObject> tmp = this.setContainerById(objContainer.getChildren(), container);
                objContainer.setChildren(tmp);
                result.set(i, (ModelObject)objContainer);
            }
        }
        return result;
    }

    private org.exoplatform.portal.config.model.Application<Portlet> createPortletApplication(String instanceId, Space space, Boolean isRoot) {
        int i0 = instanceId.indexOf("#");
        int i1 = instanceId.indexOf(":/", i0 + 1);
        String ownerType = instanceId.substring(0, i0);
        String ownerId = instanceId.substring(i0 + 1, i1);
        String persistenceid = instanceId.substring(i1 + 2);
        String[] persistenceChunks = Utils.split((String)"/", (String)persistenceid);
        PortletBuilder pb = new PortletBuilder();
        for (String appName : SpaceUtils.PORTLETS_SPACE_URL_PREFERENCE_NEEDED) {
            if (!instanceId.contains(appName)) continue;
            pb.add("SPACE_URL", space.getUrl());
            break;
        }
        TransientApplicationState portletState = new TransientApplicationState(persistenceChunks[0] + "/" + persistenceChunks[1], (Object)pb.build(), ownerType, ownerId, persistenceChunks[2]);
        org.exoplatform.portal.config.model.Application portletApp = org.exoplatform.portal.config.model.Application.createPortletApplication();
        portletApp.setState((ApplicationState)portletState);
        return portletApp;
    }

    private void changeDashBoardColumn(PageNode spaceAppNode) throws Exception {
        String pageId = spaceAppNode.getPageReference();
        Page page = this.dataStorage.getPage(pageId);
        ArrayList pageChildren = page.getChildren();
        Container applicationContainer = SpaceUtils.findContainerById(pageChildren, APPLICATION_CONTAINER);
        try {
            org.exoplatform.portal.config.model.Application applicationPortlet = (org.exoplatform.portal.config.model.Application)applicationContainer.getChildren().get(0);
            String dashboardId = applicationPortlet.getStorageId();
            Dashboard container = this.dataStorage.loadDashboard(dashboardId);
            ArrayList containerDatas = container.getChildren();
            containerDatas.remove(2);
            container.setChildren(containerDatas);
            this.dataStorage.saveDashboard(container);
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

