/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.services.resources.ResourceBundleManager;
import org.exoplatform.webui.application.WebuiRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageNavigationUtils {
    public static void removeNode(List<PageNode> list, String uri) {
        if (list == null) {
            return;
        }
        for (PageNode pageNode : list) {
            if (!pageNode.getUri().equalsIgnoreCase(uri)) continue;
            list.remove(pageNode);
            return;
        }
    }

    public static PageNode[] searchPageNodesByUri(PageNode node, String uri) {
        if (node.getUri().equals(uri)) {
            return new PageNode[]{null, node};
        }
        if (node.getChildren() == null) {
            return null;
        }
        List children = node.getChildren();
        for (PageNode ele : children) {
            PageNode[] returnNodes = PageNavigationUtils.searchPageNodesByUri(ele, uri);
            if (returnNodes == null) continue;
            if (returnNodes[0] == null) {
                returnNodes[0] = node;
            }
            return returnNodes;
        }
        return null;
    }

    public static PageNode[] searchPageNodesByUri(PageNavigation nav, String uri) {
        if (nav.getNodes() == null) {
            return null;
        }
        ArrayList nodes = nav.getNodes();
        for (PageNode ele : nodes) {
            PageNode[] returnNodes = PageNavigationUtils.searchPageNodesByUri(ele, uri);
            if (returnNodes == null) continue;
            return returnNodes;
        }
        return null;
    }

    public static PageNode searchPageNodeByUri(PageNode node, String uri) {
        if (node.getUri().equals(uri)) {
            return node;
        }
        if (node.getChildren() == null) {
            return null;
        }
        List children = node.getChildren();
        for (PageNode ele : children) {
            PageNode returnNode = PageNavigationUtils.searchPageNodeByUri(ele, uri);
            if (returnNode == null) continue;
            return returnNode;
        }
        return null;
    }

    public static PageNode searchPageNodeByUri(PageNavigation nav, String uri) {
        if (nav.getNodes() == null) {
            return null;
        }
        ArrayList nodes = nav.getNodes();
        for (PageNode ele : nodes) {
            PageNode returnNode = PageNavigationUtils.searchPageNodeByUri(ele, uri);
            if (returnNode == null) continue;
            return returnNode;
        }
        return null;
    }

    public static Object searchParentNode(PageNavigation nav, String uri) {
        if (nav.getNodes() == null) {
            return null;
        }
        int last = uri.lastIndexOf("/");
        String parentUri = "";
        if (last > -1) {
            parentUri = uri.substring(0, uri.lastIndexOf("/"));
        }
        for (PageNode ele : nav.getNodes()) {
            if (!ele.getUri().equals(uri)) continue;
            return nav;
        }
        if (parentUri.equals("")) {
            return null;
        }
        return PageNavigationUtils.searchPageNodeByUri(nav, parentUri);
    }

    public static PageNavigation filter(PageNavigation nav, String userName) throws Exception {
        return PageNavigationUtils.filterNavigation(nav, userName, false);
    }

    public static PageNavigation filterNavigation(PageNavigation nav, String userName, boolean acceptNonDisplayedNode) throws Exception {
        PageNavigation filter = nav.clone();
        filter.setNodes(new ArrayList());
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ExoContainer container = context.getApplication().getApplicationServiceContainer();
        UserPortalConfigService userService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        UserACL userACL = (UserACL)container.getComponentInstanceOfType(UserACL.class);
        for (PageNode node : nav.getNodes()) {
            PageNode newNode = PageNavigationUtils.filterNodeNavigation(node, userName, acceptNonDisplayedNode, userService, userACL);
            if (newNode == null) continue;
            filter.addNode(newNode);
        }
        return filter;
    }

    private static PageNode filterNodeNavigation(PageNode startNode, String userName, boolean acceptNonDisplayedNode, UserPortalConfigService userService, UserACL userACL) throws Exception {
        boolean doNothingCase_3;
        Visibility nodeVisibility = startNode.getVisibility();
        String pageReference = startNode.getPageReference();
        boolean doNothingCase_1 = nodeVisibility == Visibility.SYSTEM && (!userACL.getSuperUser().equals(userName) || !acceptNonDisplayedNode);
        boolean doNothingCase_2 = nodeVisibility != Visibility.SYSTEM && !startNode.isDisplay() && !acceptNonDisplayedNode;
        boolean bl = doNothingCase_3 = pageReference != null && userService.getPage(pageReference, userName) == null;
        if (doNothingCase_1 || doNothingCase_2 || doNothingCase_3) {
            return null;
        }
        PageNode cloneStartNode = startNode.clone();
        ArrayList<PageNode> filteredChildren = new ArrayList<PageNode>();
        List children = startNode.getChildren();
        if (children != null) {
            for (PageNode child : children) {
                PageNode filteredChildNode = PageNavigationUtils.filterNodeNavigation(child, userName, acceptNonDisplayedNode, userService, userACL);
                if (filteredChildNode == null) continue;
                filteredChildren.add(filteredChildNode);
            }
        }
        if (!acceptNonDisplayedNode && filteredChildren.size() == 0 && cloneStartNode.getPageReference() == null) {
            return null;
        }
        cloneStartNode.setChildren(filteredChildren);
        return cloneStartNode;
    }

    public static PageNode filter(PageNode node, String userName, boolean acceptNonDisplayedNode) throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ExoContainer container = context.getApplication().getApplicationServiceContainer();
        UserPortalConfigService userService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        UserACL userACL = (UserACL)container.getComponentInstanceOfType(UserACL.class);
        return PageNavigationUtils.filterNodeNavigation(node, userName, acceptNonDisplayedNode, userService, userACL);
    }

    public static void localizePageNavigation(PageNavigation nav, Locale locale, ResourceBundleManager i18nManager) {
        if (nav.getOwnerType().equals("user")) {
            return;
        }
        ResourceBundle res = i18nManager.getNavigationResourceBundle(locale.getLanguage(), nav.getOwnerType(), nav.getOwnerId());
        for (PageNode node : nav.getNodes()) {
            PageNavigationUtils.resolveLabel(res, node);
        }
    }

    private static void resolveLabel(ResourceBundle res, PageNode node) {
        node.setResolvedLabel(res);
        if (node.getChildren() == null) {
            return;
        }
        for (PageNode childNode : node.getChildren()) {
            PageNavigationUtils.resolveLabel(res, childNode);
        }
    }

    public static PageNavigation findNavigationByID(List<PageNavigation> all_Navigations, int id) {
        for (PageNavigation nav : all_Navigations) {
            if (nav.getId() != id) continue;
            return nav;
        }
        return null;
    }
}

