/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.remoting;

import java.util.StringTokenizer;
import javax.management.MBeanServer;
import org.jboss.logging.Logger;
import org.jboss.mx.remoting.JMXUtil;
import org.jboss.mx.remoting.MBeanServerClientInvokerProxy;
import org.jboss.mx.remoting.MBeanServerRegistry;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ident.Identity;

public class MBeanTransportPreference {
    private static final transient Logger log = Logger.getLogger((String)MBeanTransportPreference.class.getName());
    private static String _preferences = System.getProperty("jboss.transport.preferences", "socket,rmi,soap");
    private static String[] preferences = MBeanTransportPreference.initialize(_preferences);
    private static MBeanServer ourServer;
    private static Identity ourIdentity;

    public static void setLocalServer(MBeanServer server, Identity identity) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("setLocalServer called - server=" + server + ",identity=" + identity));
        }
        ourServer = server;
        ourIdentity = identity;
    }

    private static String[] initialize(String list) {
        if (list == null) {
            return new String[1];
        }
        StringTokenizer tok = new StringTokenizer(list, ",");
        String[] pref = new String[tok.countTokens()];
        int c = 0;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            pref[c++] = token.trim();
        }
        return pref;
    }

    public static void setTransportPreferences(String[] order) {
        preferences = order == null || order.length <= 0 ? MBeanTransportPreference.initialize(_preferences) : order;
    }

    public static String[] getTransportPreferences() {
        return preferences;
    }

    public static MBeanServer getServerByTransport(Identity identity, InvokerLocator[] locators) throws ConnectionFailedException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("getServerByTransport for identity=" + identity + ", ours is=" + ourIdentity));
        }
        if (ourIdentity == null) {
            if (ourServer == null) {
                ourServer = JMXUtil.getMBeanServer();
            }
            ourIdentity = Identity.get((MBeanServer)ourServer);
        }
        if (identity.isSameJVM(ourIdentity)) {
            return ourServer;
        }
        for (int c = 0; c < preferences.length; ++c) {
            String transport = preferences[c];
            if (transport == null) continue;
            for (int x = 0; x < locators.length; ++x) {
                if (!locators[x].getProtocol().equals(transport)) continue;
                try {
                    MBeanServer svr = MBeanServerRegistry.getMBeanServerFor(locators[x]);
                    if (svr != null) {
                        return svr;
                    }
                    svr = MBeanServerClientInvokerProxy.create(locators[x], ourIdentity.getJMXId(), identity.getJMXId());
                    if (svr == null) continue;
                    return svr;
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
        }
        for (int x = 0; x < locators.length; ++x) {
            try {
                MBeanServer svr;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("attempting to connect via locator[" + x + "] (" + locators[x] + ") to: " + identity));
                }
                if ((svr = MBeanServerRegistry.getMBeanServerFor(locators[x])) != null) {
                    return svr;
                }
                svr = MBeanServerClientInvokerProxy.create(locators[x], ourIdentity.getJMXId(), identity.getJMXId());
                if (svr == null) continue;
                return svr;
            }
            catch (Throwable ex) {
                log.debug((Object)"Error connecting ... ", ex);
            }
        }
        throw new ConnectionFailedException("No transport/connection available to connect to: " + identity);
    }
}

