/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.BusinessKey;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.datatype.request.FindRelatedBusinesses;
import org.apache.juddi.datatype.response.RelatedBusinessInfos;
import org.apache.juddi.datatype.response.RelatedBusinessesList;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class FindRelatedBusinessesFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$function$FindRelatedBusinessesFunction == null ? (class$org$apache$juddi$function$FindRelatedBusinessesFunction = FindRelatedBusinessesFunction.class$("org.apache.juddi.function.FindRelatedBusinessesFunction")) : class$org$apache$juddi$function$FindRelatedBusinessesFunction));
    static /* synthetic */ Class class$org$apache$juddi$function$FindRelatedBusinessesFunction;

    public FindRelatedBusinessesFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        FindRelatedBusinesses request = (FindRelatedBusinesses)regObject;
        String generic = request.getGeneric();
        String businessKey = request.getBusinessKey();
        KeyedReference keyedRef = request.getKeyedReference();
        FindQualifiers qualifiers = request.getFindQualifiers();
        int maxRows = request.getMaxRows();
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            dataStore.beginTrans();
            Vector infoVector = null;
            boolean truncatedResults = false;
            infoVector = dataStore.findRelatedBusinesses(businessKey, keyedRef, qualifiers);
            if (infoVector != null && infoVector.size() > 0) {
                int rowCount = infoVector.size();
                if (maxRows > 0 && maxRows < rowCount) {
                    rowCount = maxRows;
                    truncatedResults = true;
                }
            }
            RelatedBusinessInfos infos = new RelatedBusinessInfos();
            infos.setRelatedBusinessInfoVector(infoVector);
            dataStore.commit();
            RelatedBusinessesList list = new RelatedBusinessesList();
            list.setGeneric(generic);
            list.setOperator(Config.getOperator());
            list.setTruncated(truncatedResults);
            list.setBusinessKey(new BusinessKey(businessKey));
            list.setRelatedBusinessInfos(infos);
            RelatedBusinessesList relatedBusinessesList = list;
            return relatedBusinessesList;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
    }

    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        reg.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

