/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.util;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javassist.bytecode.ClassFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForceInterfaceToImplementAnnotation {
    static final String RETRO_ANNOTATION = "org/jboss/lang/Annotation";

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args.length > 2) {
            System.out.println("Usage:\njava org.jboss.aop.util.ForceInterfaceToImplementAnnotation dir-with-classes [file-listing-classes]");
            return;
        }
        String input = args.length == 1 ? "annotations.txt" : args[1];
        List<String> classes = ForceInterfaceToImplementAnnotation.readClasses(input);
        if (classes != null) {
            ForceInterfaceToImplementAnnotation.weaveAnnotations(args[0], classes);
        }
    }

    private static List<String> readClasses(String input) {
        File file = new File(input);
        if (!file.exists()) {
            System.out.println(input + " could not be found");
            return null;
        }
        BufferedReader rdr = null;
        try {
            rdr = new BufferedReader(new FileReader(file));
            ArrayList<String> classes = new ArrayList<String>();
            String clazz = rdr.readLine();
            while (clazz != null) {
                classes.add(clazz);
                clazz = rdr.readLine();
            }
            ArrayList<String> arrayList = classes;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (rdr != null) {
                try {
                    rdr.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static void weaveAnnotations(String directory, List<String> classes) {
        File dir = new File(directory);
        if (!dir.exists()) {
            throw new RuntimeException(directory + " does not exist");
        }
        if (!dir.isDirectory()) {
            throw new RuntimeException(directory + " is not a directory");
        }
        for (String clazz : classes) {
            File fileToWeave = ForceInterfaceToImplementAnnotation.getFileToWeave(directory, clazz);
            if (!fileToWeave.exists()) {
                System.out.println("Weaving skipped for " + clazz + ". Could not find file at " + fileToWeave);
                continue;
            }
            ForceInterfaceToImplementAnnotation.weaveClass(fileToWeave);
        }
    }

    private static File getFileToWeave(String directory, String clazz) {
        directory = directory.replace('/', File.separatorChar);
        directory = directory.replace('\\', File.separatorChar);
        StringBuffer filename = new StringBuffer(directory);
        if (!directory.endsWith(File.separator)) {
            filename.append(File.separatorChar);
        }
        if (clazz.endsWith(".class")) {
            clazz = clazz.substring(0, clazz.length() - ".class".length());
        }
        clazz = clazz.replace('.', File.separatorChar);
        clazz = clazz.replace('/', File.separatorChar);
        clazz = clazz.replace('\\', File.separatorChar);
        filename.append(clazz);
        filename.append(".class");
        return new File(filename.toString());
    }

    public static void weaveClass(File file) {
        System.out.println("* Weaving interface in " + file + " to be compatible as an annotation in javassist");
        ClassFile classFile = ForceInterfaceToImplementAnnotation.getClassFile(file);
        if (!classFile.isInterface()) {
            throw new RuntimeException(file + " does not contain an interface");
        }
        String[] interfaces = classFile.getInterfaces();
        boolean implementsRetroAnnotation = false;
        for (String intf : interfaces) {
            if (!intf.equals(RETRO_ANNOTATION)) continue;
            implementsRetroAnnotation = true;
            break;
        }
        if (!implementsRetroAnnotation) {
            classFile.addInterface(RETRO_ANNOTATION);
            ForceInterfaceToImplementAnnotation.writeClassFile(classFile, file);
        }
    }

    private static ClassFile getClassFile(File file) {
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(file));
            ClassFile classFile = new ClassFile((DataInputStream)in);
            return classFile;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void writeClassFile(ClassFile cf, File file) {
        FilterOutputStream out = null;
        try {
            out = new DataOutputStream(new FileOutputStream(file));
            cf.write((DataOutputStream)out);
        }
        catch (Exception e) {
            throw new RuntimeException("Problems writing " + file, e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

