/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.SemaphoreControlledChannel;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class PipedChannel
extends SemaphoreControlledChannel {
    protected ObjectInputStream in_;
    protected ObjectOutputStream out_;
    protected final PipedOutputStream outp_;
    protected final PipedInputStream inp_;

    public PipedChannel() {
        super(1);
        try {
            this.outp_ = new PipedOutputStream();
            this.inp_ = new PipedInputStream();
            this.inp_.connect(this.outp_);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new Error("Cannot construct Pipe?");
        }
    }

    protected synchronized ObjectInputStream in() {
        try {
            if (this.in_ == null) {
                this.in_ = new ObjectInputStream(this.inp_);
            }
            return this.in_;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new Error("IO exception during open");
        }
    }

    protected synchronized ObjectOutputStream out() {
        try {
            if (this.out_ == null) {
                this.out_ = new ObjectOutputStream(this.outp_);
            }
            return this.out_;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new Error("IO exception during open");
        }
    }

    protected void insert(Object x) {
        try {
            this.out().writeObject(x);
        }
        catch (InterruptedIOException ex) {
            Thread.currentThread().interrupt();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new Error("IO exception during put");
        }
    }

    protected Object extract() {
        try {
            return this.in().readObject();
        }
        catch (InterruptedIOException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new Error("IO exception during take");
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            throw new Error("Serialization exception during take");
        }
    }

    public Object peek() {
        return null;
    }
}

