/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.persistence;

import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.WeakHashMap;
import javax.management.ObjectName;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.config.plugins.property.PropertyConfiguration;
import org.jboss.config.spi.Configuration;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.factory.AbstractManagedObjectFactory;
import org.jboss.managed.spi.factory.InstanceClassFactory;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.metatype.api.values.InstanceFactory;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.plugins.values.ListInstanceFactory;
import org.jboss.metatype.plugins.values.SetInstanceFactory;
import org.jboss.metatype.plugins.values.SortedSetInstanceFactory;
import org.jboss.metatype.spi.values.MetaMapper;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.system.server.profileservice.persistence.ManagedObjectRecreationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentPropertyPopulator {
    private static final Logger log = Logger.getLogger(AttachmentPropertyPopulator.class);
    private static final MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();
    private static final Configuration configuration = AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

        @Override
        public Configuration run() {
            return new PropertyConfiguration();
        }
    });
    private final ManagedObjectFactory managedObjectFactory;
    private final ManagedObjectRecreationHelper helper;
    private Map<Class<?>, InstanceFactory<?>> instanceFactoryMap = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setInstanceFactory(Class<T> clazz, InstanceFactory<T> factory) {
        Map<Class<?>, InstanceFactory<?>> map = this.instanceFactoryMap;
        synchronized (map) {
            if (factory == null) {
                this.instanceFactoryMap.remove(clazz);
            } else {
                this.instanceFactoryMap.put(clazz, factory);
            }
        }
    }

    public AttachmentPropertyPopulator(ManagedObjectFactory managedObjectFactory, ManagedObjectRecreationHelper helper) {
        if (managedObjectFactory == null) {
            throw new IllegalArgumentException("null managed object factory.");
        }
        if (helper == null) {
            throw new IllegalArgumentException("null helper");
        }
        this.managedObjectFactory = managedObjectFactory;
        this.helper = helper;
        this.setInstanceFactory((Class)List.class, (InstanceFactory)ListInstanceFactory.INSTANCE);
        this.setInstanceFactory((Class)Set.class, (InstanceFactory)SetInstanceFactory.INSTANCE);
        this.setInstanceFactory((Class)SortedSet.class, (InstanceFactory)SortedSetInstanceFactory.INSTANCE);
    }

    public void processManagedProperty(String name, ManagedProperty property, Object attachment) throws Throwable {
        MetaMapper mapper;
        boolean trace = log.isTraceEnabled();
        PropertyInfo propertyInfo = (PropertyInfo)property.getField("propertyInfo", PropertyInfo.class);
        if (propertyInfo == null || !propertyInfo.isWritable()) {
            if (trace) {
                log.debug((Object)("Skipping not writable property " + propertyInfo));
            }
            return;
        }
        MetaType metaType = property.getMetaType();
        MetaValue value = property.getValue();
        if (value != null) {
            metaType = value.getMetaType();
        }
        if ((mapper = (MetaMapper)property.getTransientAttachment(MetaMapper.class)) == null) {
            CollectionMetaType collectionMetaType;
            if (metaType.isComposite()) {
                Object unwrapped;
                if (!metaType.getTypeName().equals(ObjectName.class.getName()) && (unwrapped = metaValueFactory.unwrap(value, propertyInfo.getType())) != null && Proxy.isProxyClass(unwrapped.getClass())) {
                    throw new IllegalStateException("cannot unwrap composite value for property " + property.getName() + " maybe missing @MetaMapping? " + metaType.getTypeName());
                }
            } else if (metaType.isCollection() && (collectionMetaType = (CollectionMetaType)metaType).getElementType() == AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE) {
                Collection<?> newCollection = this.unwrapGenericCollection((CollectionValue)value, propertyInfo);
                propertyInfo.set(attachment, newCollection);
                return;
            }
        }
        InstanceClassFactory icf = this.managedObjectFactory.getInstanceClassFactory(attachment.getClass(), null);
        BeanInfo beanInfo = propertyInfo.getBeanInfo();
        icf.setValue(beanInfo, property, attachment, value);
    }

    protected Collection<?> unwrapGenericCollection(CollectionValue collection, PropertyInfo propertyInfo) throws Throwable {
        BeanInfo beanInfo = configuration.getBeanInfo(propertyInfo.getType());
        Collection newCollection = (Collection)this.createNewInstance(beanInfo);
        for (MetaValue value : collection.getElements()) {
            ManagedObject o = (ManagedObject)((GenericValue)value).getValue();
            newCollection.add(o.getAttachment());
        }
        return newCollection;
    }

    protected Object createNewInstance(BeanInfo beanInfo) throws Throwable {
        ClassInfo classInfo = beanInfo.getClassInfo();
        if (classInfo.isInterface()) {
            InstanceFactory<?> instanceFactory = this.instanceFactoryMap.get(classInfo.getType());
            if (instanceFactory == null) {
                throw new IllegalArgumentException("Cannot instantiate interface BeanInfo, missing InstanceFactory: " + classInfo);
            }
            return instanceFactory.instantiate(beanInfo);
        }
        return beanInfo.newInstance();
    }
}

