/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.pc.api.InvalidPortletIdException;
import org.gatein.pc.api.NoSuchPortletException;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.info.PreferenceInfo;
import org.gatein.pc.api.info.PreferencesInfo;
import org.gatein.pc.api.state.DestroyCloneFailure;
import org.gatein.pc.api.state.PropertyChange;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationLocal;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.WSRPExceptionFactory;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.producer.PortletManagementInterface;
import org.gatein.wsrp.producer.ServiceHandler;
import org.gatein.wsrp.producer.Utils;
import org.gatein.wsrp.producer.WSRPProducerImpl;
import org.oasis.wsrp.v1.AccessDenied;
import org.oasis.wsrp.v1.ClonePortlet;
import org.oasis.wsrp.v1.DestroyFailed;
import org.oasis.wsrp.v1.DestroyPortlets;
import org.oasis.wsrp.v1.DestroyPortletsResponse;
import org.oasis.wsrp.v1.GetPortletDescription;
import org.oasis.wsrp.v1.GetPortletProperties;
import org.oasis.wsrp.v1.GetPortletPropertyDescription;
import org.oasis.wsrp.v1.InconsistentParameters;
import org.oasis.wsrp.v1.InvalidHandle;
import org.oasis.wsrp.v1.InvalidRegistration;
import org.oasis.wsrp.v1.InvalidUserCategory;
import org.oasis.wsrp.v1.MissingParameters;
import org.oasis.wsrp.v1.OperationFailed;
import org.oasis.wsrp.v1.PortletContext;
import org.oasis.wsrp.v1.PortletDescription;
import org.oasis.wsrp.v1.PortletDescriptionResponse;
import org.oasis.wsrp.v1.PortletPropertyDescriptionResponse;
import org.oasis.wsrp.v1.Property;
import org.oasis.wsrp.v1.PropertyDescription;
import org.oasis.wsrp.v1.PropertyList;
import org.oasis.wsrp.v1.ResetProperty;
import org.oasis.wsrp.v1.SetPortletProperties;
import org.oasis.wsrp.v1.UserContext;

class PortletManagementHandler
extends ServiceHandler
implements PortletManagementInterface {
    private static final String GET_PORTLET_PROPERTY_DESCRIPTION = "GetPortletPropertyDescription";
    private static final String GET_PORTLET_PROPERTIES = "GetPortletProperties";
    private static final String PORTLET_CONTEXT = "PortletContext";
    private static final String GET_PORTLET_DESCRIPTION = "GetPortletDescription";

    PortletManagementHandler(WSRPProducerImpl producer) {
        super(producer);
    }

    public PortletDescriptionResponse getPortletDescription(GetPortletDescription getPortletDescription) throws AccessDenied, InvalidHandle, InvalidUserCategory, InconsistentParameters, MissingParameters, InvalidRegistration, OperationFailed {
        WSRPExceptionFactory.throwOperationFailedIfValueIsMissing((Object)getPortletDescription, (String)GET_PORTLET_DESCRIPTION);
        Registration registration = this.producer.getRegistrationOrFailIfInvalid(getPortletDescription.getRegistrationContext());
        PortletContext portletContext = getPortletDescription.getPortletContext();
        WSRPExceptionFactory.throwMissingParametersIfValueIsMissing((Object)portletContext, (String)PORTLET_CONTEXT, (String)GET_PORTLET_DESCRIPTION);
        UserContext userContext = getPortletDescription.getUserContext();
        this.checkUserAuthorization(userContext);
        PortletDescription description = this.producer.getPortletDescription(portletContext, getPortletDescription.getDesiredLocales(), registration);
        return WSRPTypeFactory.createPortletDescriptionResponse((PortletDescription)description);
    }

    public PortletPropertyDescriptionResponse getPortletPropertyDescription(GetPortletPropertyDescription getPortletPropertyDescription) throws MissingParameters, InconsistentParameters, InvalidUserCategory, InvalidRegistration, AccessDenied, InvalidHandle, OperationFailed {
        WSRPExceptionFactory.throwOperationFailedIfValueIsMissing((Object)getPortletPropertyDescription, (String)GET_PORTLET_PROPERTY_DESCRIPTION);
        PortletContext portletContext = getPortletPropertyDescription.getPortletContext();
        WSRPExceptionFactory.throwMissingParametersIfValueIsMissing((Object)portletContext, (String)PORTLET_CONTEXT, (String)GET_PORTLET_PROPERTY_DESCRIPTION);
        Registration registration = this.producer.getRegistrationOrFailIfInvalid(getPortletPropertyDescription.getRegistrationContext());
        UserContext userContext = getPortletPropertyDescription.getUserContext();
        this.checkUserAuthorization(userContext);
        List desiredLocales = getPortletPropertyDescription.getDesiredLocales();
        Portlet portlet = this.getPortletFrom(portletContext, registration);
        PortletInfo info = portlet.getInfo();
        PreferencesInfo prefsInfo = info.getPreferences();
        List descs = Collections.emptyList();
        if (prefsInfo != null) {
            Set keySet = prefsInfo.getKeys();
            descs = new ArrayList(keySet.size());
            boolean index = false;
            for (Object key : keySet) {
                PreferenceInfo prefInfo = prefsInfo.getPreference((String)key);
                Boolean readOnly = prefInfo.isReadOnly();
                if (readOnly == null || readOnly.booleanValue()) continue;
                PropertyDescription desc = WSRPTypeFactory.createPropertyDescription((String)prefInfo.getKey(), (QName)WSRPConstants.XSD_STRING);
                desc.setLabel(Utils.convertToWSRPLocalizedString(prefInfo.getDisplayName(), desiredLocales));
                desc.setHint(Utils.convertToWSRPLocalizedString(prefInfo.getDescription(), desiredLocales));
                descs.add(desc);
            }
        }
        return WSRPTypeFactory.createPortletPropertyDescriptionResponse(descs);
    }

    public PortletContext clonePortlet(ClonePortlet clonePortlet) throws InvalidUserCategory, AccessDenied, OperationFailed, InvalidHandle, InvalidRegistration, InconsistentParameters, MissingParameters {
        WSRPExceptionFactory.throwOperationFailedIfValueIsMissing((Object)clonePortlet, (String)"ClonePortlet");
        PortletContext portletContext = clonePortlet.getPortletContext();
        WSRPExceptionFactory.throwMissingParametersIfValueIsMissing((Object)portletContext, (String)PORTLET_CONTEXT, (String)"ClonePortlet");
        Registration registration = this.producer.getRegistrationOrFailIfInvalid(clonePortlet.getRegistrationContext());
        UserContext userContext = clonePortlet.getUserContext();
        this.checkUserAuthorization(userContext);
        org.gatein.pc.api.PortletContext portalPC = WSRPUtils.convertToPortalPortletContext((PortletContext)portletContext);
        try {
            RegistrationLocal.setRegistration(registration);
            org.gatein.pc.api.PortletContext response = this.producer.getPortletInvoker().createClone(PortletStateType.OPAQUE, portalPC);
            PortletContext portletContext2 = WSRPUtils.convertToWSRPPortletContext((org.gatein.pc.api.PortletContext)response);
            return portletContext2;
        }
        catch (NoSuchPortletException e) {
            throw (InvalidHandle)WSRPExceptionFactory.throwWSException((String)"InvalidHandle", (String)("Failed to create clone for portlet '" + portletContext.getPortletHandle()), (Throwable)e);
        }
        catch (InvalidPortletIdException e) {
            throw (InconsistentParameters)WSRPExceptionFactory.throwWSException((String)"InconsistentParameters", (String)("Failed to create clone for portlet '" + portletContext.getPortletHandle()), (Throwable)e);
        }
        catch (PortletInvokerException e) {
            throw (OperationFailed)WSRPExceptionFactory.throwWSException((String)"OperationFailed", (String)("Failed to create clone for portlet '" + portletContext.getPortletHandle()), (Throwable)e);
        }
        finally {
            RegistrationLocal.setRegistration(null);
        }
    }

    public DestroyPortletsResponse destroyPortlets(DestroyPortlets destroyPortlets) throws InconsistentParameters, MissingParameters, InvalidRegistration, OperationFailed {
        WSRPExceptionFactory.throwOperationFailedIfValueIsMissing((Object)destroyPortlets, (String)"DestroyPortlets");
        List handles = destroyPortlets.getPortletHandles();
        WSRPExceptionFactory.throwMissingParametersIfValueIsMissing((Object)handles, (String)"portlet handles to be destroyed", (String)"DestroyPortlets");
        Registration registration = this.producer.getRegistrationOrFailIfInvalid(destroyPortlets.getRegistrationContext());
        ArrayList<org.gatein.pc.api.PortletContext> portletContexts = new ArrayList<org.gatein.pc.api.PortletContext>(handles.size());
        for (String handle : handles) {
            portletContexts.add(org.gatein.pc.api.PortletContext.createPortletContext((String)handle));
        }
        try {
            ArrayList<DestroyFailed> destroyFailed;
            RegistrationLocal.setRegistration(registration);
            List failuresList = this.producer.getPortletInvoker().destroyClones(portletContexts);
            int failuresNumber = failuresList.size();
            if (failuresNumber > 0) {
                destroyFailed = new ArrayList<DestroyFailed>(failuresNumber);
                for (DestroyCloneFailure failure : failuresList) {
                    destroyFailed.add(WSRPTypeFactory.createDestroyFailed((String)failure.getPortletId(), (String)failure.getMessage()));
                }
            } else {
                destroyFailed = null;
            }
            DestroyPortletsResponse destroyPortletsResponse = WSRPTypeFactory.createDestroyPortletsResponse(destroyFailed);
            return destroyPortletsResponse;
        }
        catch (PortletInvokerException e) {
            throw (OperationFailed)WSRPExceptionFactory.throwWSException((String)"OperationFailed", (String)"Failed to destroy clones", (Throwable)e);
        }
        finally {
            RegistrationLocal.setRegistration(null);
        }
    }

    public PortletContext setPortletProperties(SetPortletProperties setPortletProperties) throws OperationFailed, InvalidHandle, MissingParameters, InconsistentParameters, InvalidUserCategory, AccessDenied, InvalidRegistration {
        WSRPExceptionFactory.throwOperationFailedIfValueIsMissing((Object)setPortletProperties, (String)"SetPortletProperties");
        PortletContext portletContext = setPortletProperties.getPortletContext();
        WSRPExceptionFactory.throwMissingParametersIfValueIsMissing((Object)portletContext, (String)PORTLET_CONTEXT, (String)"SetPortletProperties");
        PropertyList propertyList = setPortletProperties.getPropertyList();
        WSRPExceptionFactory.throwMissingParametersIfValueIsMissing((Object)propertyList, (String)"PropertyList", (String)"SetPortletProperties");
        Registration registration = this.producer.getRegistrationOrFailIfInvalid(setPortletProperties.getRegistrationContext());
        this.checkUserAuthorization(setPortletProperties.getUserContext());
        List properties = propertyList.getProperties();
        List resetProperties = propertyList.getResetProperties();
        int changesCount = 0;
        if (properties != null) {
            changesCount += properties.size();
        }
        if (resetProperties != null) {
            changesCount += resetProperties.size();
        }
        if (changesCount > 0) {
            ArrayList<PropertyChange> changes = new ArrayList<PropertyChange>(changesCount);
            if (properties != null) {
                for (Property property : properties) {
                    String value = property.getStringValue();
                    List values = property.getAny();
                    String lang = property.getLang();
                    changes.add(PropertyChange.newUpdate((String)property.getName(), (String)value));
                }
            }
            if (resetProperties != null) {
                for (ResetProperty resetProperty : resetProperties) {
                    changes.add(PropertyChange.newReset((String)resetProperty.getName()));
                }
            }
            try {
                RegistrationLocal.setRegistration(registration);
                org.gatein.pc.api.PortletContext resultContext = this.producer.getPortletInvoker().setProperties(WSRPUtils.convertToPortalPortletContext((PortletContext)portletContext), changes.toArray(new PropertyChange[changes.size()]));
                PortletContext portletContext2 = WSRPUtils.convertToWSRPPortletContext((org.gatein.pc.api.PortletContext)resultContext);
                return portletContext2;
            }
            catch (NoSuchPortletException e) {
                throw (InvalidHandle)WSRPExceptionFactory.throwWSException((String)"InvalidHandle", (String)("Failed to set properties for portlet '" + portletContext.getPortletHandle() + "'"), (Throwable)e);
            }
            catch (InvalidPortletIdException e) {
                throw (InconsistentParameters)WSRPExceptionFactory.throwWSException((String)"InconsistentParameters", (String)("Failed to set properties for portlet '" + portletContext.getPortletHandle() + "'"), (Throwable)e);
            }
            catch (PortletInvokerException e) {
                throw (OperationFailed)WSRPExceptionFactory.throwWSException((String)"OperationFailed", (String)("Failed to set properties for portlet '" + portletContext.getPortletHandle() + "'"), (Throwable)e);
            }
            finally {
                RegistrationLocal.setRegistration(null);
            }
        }
        return portletContext;
    }

    public PropertyList getPortletProperties(GetPortletProperties getPortletProperties) throws InvalidHandle, MissingParameters, InvalidRegistration, AccessDenied, OperationFailed, InconsistentParameters, InvalidUserCategory {
        WSRPExceptionFactory.throwOperationFailedIfValueIsMissing((Object)getPortletProperties, (String)GET_PORTLET_PROPERTIES);
        PortletContext portletContext = getPortletProperties.getPortletContext();
        WSRPExceptionFactory.throwMissingParametersIfValueIsMissing((Object)portletContext, (String)PORTLET_CONTEXT, (String)GET_PORTLET_PROPERTIES);
        Registration registration = this.producer.getRegistrationOrFailIfInvalid(getPortletProperties.getRegistrationContext());
        UserContext userContext = getPortletProperties.getUserContext();
        this.checkUserAuthorization(userContext);
        List names = getPortletProperties.getNames();
        HashSet keys = new HashSet(names);
        try {
            org.gatein.pc.api.PortletContext jbpContext = WSRPUtils.convertToPortalPortletContext((PortletContext)portletContext);
            RegistrationLocal.setRegistration(registration);
            PropertyMap properties = keys != null ? this.producer.getPortletInvoker().getProperties(jbpContext, keys) : this.producer.getPortletInvoker().getProperties(jbpContext);
            Portlet portlet = this.getPortletFrom(portletContext, registration);
            PortletInfo info = portlet.getInfo();
            PropertyList result = WSRPTypeFactory.createPropertyList();
            int propertyNb = properties.size();
            if (propertyNb > 0) {
                for (Map.Entry entry : properties.entrySet()) {
                    String key = (String)entry.getKey();
                    List values = (List)entry.getValue();
                    PreferenceInfo prefInfo = info.getPreferences().getPreference(key);
                    LocalizedString displayName = prefInfo.getDisplayName();
                    String lang = WSRPUtils.toString((Locale)displayName.getDefaultLocale());
                    if (values.size() != 1) {
                        throw new UnsupportedOperationException("Currently doesn't support multi-valued properties!");
                    }
                    result.getProperties().add(WSRPTypeFactory.createProperty((String)key, (String)lang, (String)((String)values.get(0))));
                }
            }
            PropertyList propertyList = result;
            return propertyList;
        }
        catch (PortletInvokerException e) {
            throw (InvalidHandle)WSRPExceptionFactory.throwWSException((String)"InvalidHandle", (String)("Could not retrieve properties for portlet '" + portletContext + "'"), (Throwable)e);
        }
        finally {
            RegistrationLocal.setRegistration(null);
        }
    }

    private void checkUserAuthorization(UserContext userContext) {
        if (userContext != null) {
            // empty if block
        }
    }

    private Portlet getPortletFrom(PortletContext portletContext, Registration registration) throws InvalidHandle {
        try {
            Portlet portlet;
            RegistrationLocal.setRegistration(registration);
            Portlet portlet2 = portlet = this.producer.getPortletInvoker().getPortlet(WSRPUtils.convertToPortalPortletContext((PortletContext)portletContext));
            return portlet2;
        }
        catch (PortletInvokerException e) {
            throw (InvalidHandle)WSRPExceptionFactory.throwWSException((String)"InvalidHandle", (String)("Could not retrieve portlet '" + portletContext.getPortletHandle() + "'"), (Throwable)e);
        }
        finally {
            RegistrationLocal.setRegistration(null);
        }
    }
}

