/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.catalina.security.SecurityClassLoad;
import org.apache.catalina.startup.CatalinaProperties;
import org.apache.catalina.startup.ClassLoaderFactory;
import org.jboss.logging.Logger;

public final class Bootstrap {
    private static Logger log = Logger.getLogger(Bootstrap.class);
    protected static final String CATALINA_HOME_TOKEN = "${catalina.home}";
    protected static final String CATALINA_BASE_TOKEN = "${catalina.base}";
    private static Bootstrap daemon = null;
    private Object catalinaDaemon = null;
    protected ClassLoader commonLoader = null;
    protected ClassLoader catalinaLoader = null;
    protected ClassLoader sharedLoader = null;

    private void initClassLoaders() {
        try {
            this.commonLoader = this.createClassLoader("common", null);
            if (this.commonLoader == null) {
                this.commonLoader = this.getClass().getClassLoader();
            }
            this.catalinaLoader = this.createClassLoader("server", this.commonLoader);
            this.sharedLoader = this.createClassLoader("shared", this.commonLoader);
        }
        catch (Throwable t) {
            log.error((Object)"Class loader creation threw exception", t);
            System.exit(1);
        }
    }

    private ClassLoader createClassLoader(String name, ClassLoader parent) throws Exception {
        String value = CatalinaProperties.getProperty(name + ".loader");
        if (value == null || value.equals("")) {
            return parent;
        }
        ArrayList<String> repositoryLocations = new ArrayList<String>();
        ArrayList<Integer> repositoryTypes = new ArrayList<Integer>();
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        while (tokenizer.hasMoreElements()) {
            int i;
            String repository = tokenizer.nextToken();
            boolean replace = false;
            String before = repository;
            while ((i = repository.indexOf(CATALINA_HOME_TOKEN)) >= 0) {
                replace = true;
                if (i > 0) {
                    repository = repository.substring(0, i) + Bootstrap.getCatalinaHome() + repository.substring(i + CATALINA_HOME_TOKEN.length());
                    continue;
                }
                repository = Bootstrap.getCatalinaHome() + repository.substring(CATALINA_HOME_TOKEN.length());
            }
            while ((i = repository.indexOf(CATALINA_BASE_TOKEN)) >= 0) {
                replace = true;
                if (i > 0) {
                    repository = repository.substring(0, i) + Bootstrap.getCatalinaBase() + repository.substring(i + CATALINA_BASE_TOKEN.length());
                    continue;
                }
                repository = Bootstrap.getCatalinaBase() + repository.substring(CATALINA_BASE_TOKEN.length());
            }
            if (replace && log.isDebugEnabled()) {
                log.debug((Object)("Expanded " + before + " to " + replace));
            }
            try {
                URL url = new URL(repository);
                repositoryLocations.add(repository);
                repositoryTypes.add(ClassLoaderFactory.IS_URL);
            }
            catch (MalformedURLException e) {
                if (repository.endsWith("*.jar")) {
                    repository = repository.substring(0, repository.length() - "*.jar".length());
                    repositoryLocations.add(repository);
                    repositoryTypes.add(ClassLoaderFactory.IS_GLOB);
                    continue;
                }
                if (repository.endsWith(".jar")) {
                    repositoryLocations.add(repository);
                    repositoryTypes.add(ClassLoaderFactory.IS_JAR);
                    continue;
                }
                repositoryLocations.add(repository);
                repositoryTypes.add(ClassLoaderFactory.IS_DIR);
            }
        }
        String[] locations = repositoryLocations.toArray(new String[0]);
        Integer[] types = repositoryTypes.toArray(new Integer[0]);
        ClassLoader classLoader = ClassLoaderFactory.createClassLoader(locations, types, parent);
        MBeanServer mBeanServer = null;
        mBeanServer = MBeanServerFactory.findMBeanServer(null).size() > 0 ? MBeanServerFactory.findMBeanServer(null).get(0) : MBeanServerFactory.createMBeanServer();
        ObjectName objectName = new ObjectName("Catalina:type=ServerClassLoader,name=" + name);
        mBeanServer.registerMBean(classLoader, objectName);
        return classLoader;
    }

    public void init() throws Exception {
        this.setCatalinaHome();
        this.setCatalinaBase();
        this.initClassLoaders();
        Thread.currentThread().setContextClassLoader(this.catalinaLoader);
        SecurityClassLoad.securityClassLoad(this.catalinaLoader);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Loading startup class");
        }
        Class<?> startupClass = this.catalinaLoader.loadClass("org.apache.catalina.startup.Catalina");
        Object startupInstance = startupClass.newInstance();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting startup class properties");
        }
        String methodName = "setParentClassLoader";
        Class[] paramTypes = new Class[]{Class.forName("java.lang.ClassLoader")};
        Object[] paramValues = new Object[]{this.sharedLoader};
        Method method = startupInstance.getClass().getMethod(methodName, paramTypes);
        method.invoke(startupInstance, paramValues);
        this.catalinaDaemon = startupInstance;
    }

    private void load(String[] arguments) throws Exception {
        Object[] param;
        Class[] paramTypes;
        String methodName = "load";
        if (arguments == null || arguments.length == 0) {
            paramTypes = null;
            param = null;
        } else {
            paramTypes = new Class[]{arguments.getClass()};
            param = new Object[]{arguments};
        }
        Method method = this.catalinaDaemon.getClass().getMethod(methodName, paramTypes);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Calling startup class " + method));
        }
        method.invoke(this.catalinaDaemon, param);
    }

    public void init(String[] arguments) throws Exception {
        this.init();
        this.load(arguments);
    }

    public void start() throws Exception {
        if (this.catalinaDaemon == null) {
            this.init();
        }
        Method method = this.catalinaDaemon.getClass().getMethod("start", null);
        method.invoke(this.catalinaDaemon, (Object[])null);
    }

    public void stop() throws Exception {
        Method method = this.catalinaDaemon.getClass().getMethod("stop", null);
        method.invoke(this.catalinaDaemon, (Object[])null);
    }

    public void stopServer() throws Exception {
        Method method = this.catalinaDaemon.getClass().getMethod("stopServer", null);
        method.invoke(this.catalinaDaemon, (Object[])null);
    }

    public void stopServer(String[] arguments) throws Exception {
        Object[] param;
        Class[] paramTypes;
        if (arguments == null || arguments.length == 0) {
            paramTypes = null;
            param = null;
        } else {
            paramTypes = new Class[]{arguments.getClass()};
            param = new Object[]{arguments};
        }
        Method method = this.catalinaDaemon.getClass().getMethod("stopServer", paramTypes);
        method.invoke(this.catalinaDaemon, param);
    }

    public void setAwait(boolean await) throws Exception {
        Class[] paramTypes = new Class[]{Boolean.TYPE};
        Object[] paramValues = new Object[]{new Boolean(await)};
        Method method = this.catalinaDaemon.getClass().getMethod("setAwait", paramTypes);
        method.invoke(this.catalinaDaemon, paramValues);
    }

    public boolean getAwait() throws Exception {
        Class[] paramTypes = new Class[]{};
        Object[] paramValues = new Object[]{};
        Method method = this.catalinaDaemon.getClass().getMethod("getAwait", paramTypes);
        Boolean b = (Boolean)method.invoke(this.catalinaDaemon, paramValues);
        return b;
    }

    public void destroy() {
    }

    public static void main(String[] args) {
        if (daemon == null) {
            daemon = new Bootstrap();
            try {
                daemon.init();
            }
            catch (Throwable t) {
                t.printStackTrace();
                return;
            }
        }
        try {
            String command = "start";
            if (args.length > 0) {
                command = args[args.length - 1];
            }
            if (command.equals("startd")) {
                args[0] = "start";
                daemon.load(args);
                daemon.start();
            } else if (command.equals("stopd")) {
                args[0] = "stop";
                daemon.stop();
            } else if (command.equals("start")) {
                daemon.setAwait(true);
                daemon.load(args);
                daemon.start();
            } else if (command.equals("stop")) {
                daemon.stopServer(args);
            } else {
                log.warn((Object)("Bootstrap: command \"" + command + "\" does not exist."));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setCatalinaHome(String s) {
        System.setProperty("catalina.home", s);
    }

    public void setCatalinaBase(String s) {
        System.setProperty("catalina.base", s);
    }

    private void setCatalinaBase() {
        if (System.getProperty("catalina.base") != null) {
            return;
        }
        if (System.getProperty("catalina.home") != null) {
            System.setProperty("catalina.base", System.getProperty("catalina.home"));
        } else {
            System.setProperty("catalina.base", System.getProperty("user.dir"));
        }
    }

    private void setCatalinaHome() {
        if (System.getProperty("catalina.home") != null) {
            return;
        }
        File bootstrapJar = new File(System.getProperty("user.dir"), "bootstrap.jar");
        if (bootstrapJar.exists()) {
            try {
                System.setProperty("catalina.home", new File(System.getProperty("user.dir"), "..").getCanonicalPath());
            }
            catch (Exception e) {
                System.setProperty("catalina.home", System.getProperty("user.dir"));
            }
        } else {
            System.setProperty("catalina.home", System.getProperty("user.dir"));
        }
    }

    public static String getCatalinaHome() {
        return System.getProperty("catalina.home", System.getProperty("user.dir"));
    }

    public static String getCatalinaBase() {
        return System.getProperty("catalina.base", Bootstrap.getCatalinaHome());
    }
}

