/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.relationship;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.Property;
import org.exoplatform.social.core.relationship.Relationship;
import org.exoplatform.social.core.relationship.lifecycle.RelationshipLifeCycle;
import org.exoplatform.social.core.relationship.lifecycle.RelationshipListenerPlugin;
import org.exoplatform.social.core.relationship.storage.JCRStorage;
import org.exoplatform.social.jcr.SocialDataLocation;
import org.exoplatform.social.relationship.spi.RelationshipListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipManager {
    private JCRStorage storage;
    private RelationshipLifeCycle lifeCycle = new RelationshipLifeCycle();

    public RelationshipManager(SocialDataLocation dataLocation, IdentityManager im) throws Exception {
        this.storage = new JCRStorage(dataLocation, im);
    }

    public Relationship getById(String id) throws Exception {
        return this.storage.getRelationship(id);
    }

    public Relationship invite(Identity currIdentity, Identity requestedIdentity) throws Exception {
        Relationship rel = this.create(currIdentity, requestedIdentity);
        rel.setStatus(Relationship.Type.PENDING);
        this.save(rel);
        this.lifeCycle.relationshipRequested(this, rel);
        return rel;
    }

    public void confirm(Relationship relationship) throws Exception {
        relationship.setStatus(Relationship.Type.CONFIRM);
        for (Property prop : relationship.getProperties()) {
            prop.setStatus(Relationship.Type.CONFIRM);
        }
        this.save(relationship);
        this.lifeCycle.relationshipConfirmed(this, relationship);
    }

    public void deny(Relationship relationship) throws Exception {
        this.storage.removeRelationship(relationship);
        this.lifeCycle.relationshipDenied(this, relationship);
    }

    public void remove(Relationship relationship) throws Exception {
        this.storage.removeRelationship(relationship);
        this.lifeCycle.relationshipRemoved(this, relationship);
    }

    public void ignore(Relationship relationship) throws Exception {
        relationship.setStatus(Relationship.Type.IGNORE);
        for (Property prop : relationship.getProperties()) {
            prop.setStatus(Relationship.Type.IGNORE);
        }
        this.save(relationship);
        this.lifeCycle.relationshipIgnored(this, relationship);
    }

    public List<Identity> getPublicRelation(Identity identity) throws Exception {
        ArrayList<Identity> ids = new ArrayList<Identity>();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityManager im = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        List<Identity> allIds = im.getIdentities("organization");
        for (Identity id : allIds) {
            if (id.getId().equals(identity.getId()) || this.getRelationship(identity, id) != null) continue;
            ids.add(id);
        }
        return ids;
    }

    public List<Relationship> getPending(Identity identity) throws Exception {
        List<Relationship> rels = this.get(identity);
        ArrayList<Relationship> pendingRel = new ArrayList<Relationship>();
        for (Relationship rel : rels) {
            if (rel.getStatus() == Relationship.Type.PENDING) {
                pendingRel.add(rel);
                continue;
            }
            if (rel.getProperties(Relationship.Type.PENDING).size() <= 0) continue;
            pendingRel.add(rel);
        }
        return pendingRel;
    }

    public List<Relationship> getPending(Identity identity, boolean toConfirm) throws Exception {
        List<Relationship> rels = this.get(identity);
        ArrayList<Relationship> pendingRel = new ArrayList<Relationship>();
        if (toConfirm) {
            for (Relationship rel : rels) {
                if (!this.getRelationshipStatus(rel, identity).equals((Object)Relationship.Type.PENDING)) continue;
                pendingRel.add(rel);
            }
            return pendingRel;
        }
        for (Relationship relationship : rels) {
            if (!this.getRelationshipStatus(relationship, identity).equals((Object)Relationship.Type.REQUIRE_VALIDATION)) continue;
            pendingRel.add(relationship);
        }
        return pendingRel;
    }

    public List<Relationship> getPending(Identity currIdentity, List<Identity> identities, boolean toConfirm) throws Exception {
        List<Relationship> pendingRels = this.getPending(currIdentity, true);
        List<Relationship> invitedRels = this.getPending(currIdentity, false);
        ArrayList<Relationship> pendingRel = new ArrayList<Relationship>();
        if (toConfirm) {
            block0: for (Identity id : identities) {
                for (Relationship rel : pendingRels) {
                    if (!rel.getIdentity2().getRemoteId().equals(id.getRemoteId())) continue;
                    pendingRel.add(rel);
                    continue block0;
                }
            }
            return pendingRel;
        }
        block2: for (Identity id : identities) {
            for (Relationship rel : invitedRels) {
                if (!rel.getIdentity1().getRemoteId().equals(id.getRemoteId())) continue;
                pendingRel.add(rel);
                continue block2;
            }
        }
        return pendingRel;
    }

    public List<Relationship> getContacts(Identity currIdentity, List<Identity> identities) throws Exception {
        List<Relationship> contacts = this.getContacts(currIdentity);
        ArrayList<Relationship> relations = new ArrayList<Relationship>();
        Identity identityRel = null;
        block0: for (Identity id : identities) {
            for (Relationship contact : contacts) {
                identityRel = contact.getIdentity1().getRemoteId().equals(currIdentity.getRemoteId()) ? contact.getIdentity2() : contact.getIdentity1();
                if (!identityRel.getRemoteId().equals(id.getRemoteId())) continue;
                relations.add(contact);
                continue block0;
            }
        }
        return relations;
    }

    public List<Relationship> getContacts(Identity identity) throws Exception {
        List<Relationship> rels = this.get(identity);
        if (rels == null) {
            return null;
        }
        ArrayList<Relationship> contacts = new ArrayList<Relationship>();
        for (Relationship rel : rels) {
            if (rel.getStatus() != Relationship.Type.CONFIRM) continue;
            contacts.add(rel);
        }
        return contacts;
    }

    public List<Relationship> get(Identity id) throws Exception {
        return this.storage.getRelationshipByIdentity(id);
    }

    public List<Relationship> getByIdentityId(String id) throws Exception {
        return this.storage.getRelationshipByIdentityId(id);
    }

    public List<Identity> getIdentities(Identity id) throws Exception {
        return this.storage.getRelationshipIdentitiesByIdentity(id);
    }

    public Relationship create(Identity id1, Identity id2) {
        return new Relationship(id1, id2);
    }

    void save(Relationship rel) throws Exception {
        if (rel.getIdentity1().getId().equals(rel.getIdentity2().getId())) {
            throw new Exception("the two identity are the same");
        }
        for (Property prop : rel.getProperties()) {
            if (prop.getInitiator().getId().equals(rel.getIdentity1().getId()) || prop.getInitiator().getId().equals(rel.getIdentity2().getId())) continue;
            throw new Exception("the property initiator is not member of the relationship");
        }
        this.storage.saveRelationship(rel);
    }

    public List findRoute(Identity id1, Identity id2) {
        return null;
    }

    public Relationship getRelationship(Identity id1, Identity id2) throws Exception {
        List<Relationship> rels = this.get(id1);
        String sId2 = id2.getId();
        for (Relationship rel : rels) {
            if (!rel.getIdentity1().getId().equals(sId2) && !rel.getIdentity2().getId().equals(sId2)) continue;
            return rel;
        }
        return null;
    }

    public Relationship.Type getRelationshipStatus(Relationship rel, Identity id) {
        if (rel == null) {
            return Relationship.Type.ALIEN;
        }
        Identity identity1 = rel.getIdentity1();
        if (rel.getStatus().equals((Object)Relationship.Type.PENDING)) {
            if (identity1.getId().equals(id.getId())) {
                return Relationship.Type.PENDING;
            }
            return Relationship.Type.REQUIRE_VALIDATION;
        }
        if (rel.getStatus().equals((Object)Relationship.Type.IGNORE)) {
            return Relationship.Type.ALIEN;
        }
        return Relationship.Type.CONFIRM;
    }

    public void registerListener(RelationshipListener listener) {
        this.lifeCycle.addListener(listener);
    }

    public void unregisterListener(RelationshipListener listener) {
        this.lifeCycle.removeListener(listener);
    }

    public void addListenerPlugin(RelationshipListenerPlugin plugin) {
        this.registerListener(plugin);
    }
}

