/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.composer;

import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.webui.composer.UIActivityComposer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;
import org.exoplatform.social.webui.space.UISpaceActivitiesDisplay;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig
public class UIDefaultActivityComposer
extends UIActivityComposer {
    public UIDefaultActivityComposer() {
        this.setReadyForPostingActivity(false);
    }

    @Override
    public void onPostActivity(UIComposer.PostContext postContext, UIComponent source, WebuiRequestContext requestContext, String postedMessage) throws Exception {
        if (postedMessage.equals("")) {
            UIApplication uiApplication = requestContext.getUIApplication();
            uiApplication.addMessage(new ApplicationMessage("UIComposer.msg.error.Empty_Message", null, 1));
            return;
        }
        String remoteUser = requestContext.getRemoteUser();
        UIComposer uiComposer = (UIComposer)source;
        ActivityManager activityManager = (ActivityManager)uiComposer.getApplicationComponent(ActivityManager.class);
        IdentityManager identityManager = (IdentityManager)uiComposer.getApplicationComponent(IdentityManager.class);
        Identity userIdentity = identityManager.getOrCreateIdentity("organization", remoteUser);
        String ownerName = null;
        if (postContext == UIComposer.PostContext.SPACE) {
            UISpaceActivitiesDisplay uiDisplaySpaceActivities = (UISpaceActivitiesDisplay)this.getActivityDisplay();
            Space space = uiDisplaySpaceActivities.getSpace();
            Identity spaceIdentity = identityManager.getOrCreateIdentity("space", space.getId(), false);
            Activity activity = new Activity(userIdentity.getId(), "exosocial:spaces", postedMessage, null);
            activity.setType("DEFAULT_ACTIVITY");
            activityManager.saveActivity(spaceIdentity, activity);
        } else if (postContext == UIComposer.PostContext.USER) {
            UIUserActivitiesDisplay uiUserActivitiesDisplay = (UIUserActivitiesDisplay)this.getActivityDisplay();
            ownerName = uiUserActivitiesDisplay.getOwnerName();
            Identity ownerIdentity = identityManager.getOrCreateIdentity("organization", ownerName);
            Activity activity = new Activity(userIdentity.getId(), "exosocial:people", postedMessage, null);
            activity.setType("DEFAULT_ACTIVITY");
            activityManager.saveActivity(ownerIdentity, activity);
            uiUserActivitiesDisplay.setSelectedDisplayMode(UIUserActivitiesDisplay.DisplayMode.MY_STATUS);
        }
    }

    @Override
    protected void onClose(Event<UIActivityComposer> event) {
    }

    @Override
    protected void onSubmit(Event<UIActivityComposer> event) {
    }

    @Override
    protected void onActivate(Event<UIActivityComposer> event) {
    }
}

