/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wsqa.recorder;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import org.exoplatform.wsqa.httpclient.HttpRequest;
import org.exoplatform.wsqa.httpclient.HttpResponse;
import org.exoplatform.wsqa.recorder.ConnectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connection
extends Thread {
    private Socket clientSocket_;
    private Socket serverSocket_;
    private List<ConnectionListener> listeners_;
    private HttpRequest request_;
    private HttpResponse response_;

    public Connection(List<ConnectionListener> listeners, Socket client) throws Exception {
        this.clientSocket_ = client;
        this.listeners_ = listeners;
    }

    public HttpRequest getHttpRequest() {
        return this.request_;
    }

    public HttpResponse getHttpResponse() {
        return this.response_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            for (ConnectionListener listener : this.listeners_) {
                listener.onStartConnection(this);
            }
            BufferedInputStream fromClient = new BufferedInputStream(this.clientSocket_.getInputStream());
            this.request_ = new HttpRequest(fromClient);
            this.serverSocket_ = new Socket(this.request_.getHeaders().getUri().getHost(), this.request_.getHeaders().getUri().getPort());
            OutputStream toServer = this.serverSocket_.getOutputStream();
            this.request_.forward(toServer);
            toServer.flush();
            BufferedInputStream fromServer = new BufferedInputStream(this.serverSocket_.getInputStream());
            this.response_ = new HttpResponse(fromServer, this.request_.getHeaders().getUri());
            BufferedOutputStream toClient = new BufferedOutputStream(this.clientSocket_.getOutputStream());
            this.response_.forward(toClient);
            ((OutputStream)toClient).flush();
            ((InputStream)fromClient).close();
            ((OutputStream)toClient).close();
            ((InputStream)fromServer).close();
            toServer.close();
            for (ConnectionListener listener : this.listeners_) {
                listener.onEndConnection(this);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            try {
                if (this.clientSocket_ != null) {
                    this.clientSocket_.close();
                }
                if (this.serverSocket_ != null) {
                    this.serverSocket_.close();
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }
}

