/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.impl.core.value.BooleanValue;
import org.exoplatform.services.jcr.impl.core.value.DoubleValue;
import org.exoplatform.services.jcr.impl.core.value.LongValue;
import org.exoplatform.services.jcr.impl.core.value.StringValue;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.jcr.JCRSessionManager;
import org.exoplatform.social.common.jcr.QueryBuilder;
import org.exoplatform.social.common.jcr.SocialDataLocation;
import org.exoplatform.social.core.identity.model.AvatarAttachment;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.service.ProfileConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityStorage {
    private static final Log LOG = ExoLogger.getExoLogger(IdentityStorage.class);
    public static final String IDENTITY_NODETYPE = "exo:identity".intern();
    public static final String PROFILE_NODETYPE = "exo:profile".intern();
    public static final String IDENTITY_REMOTEID = "exo:remoteId".intern();
    public static final String IDENTITY_PROVIDERID = "exo:providerId".intern();
    public static final String PROFILE_IDENTITY = "exo:identity".intern();
    public static final String PROFILE_AVATAR = "avatar".intern();
    public static final String JCR_UUID = "jcr:uuid".intern();
    public static final String REFERENCEABLE_NODE = "mix:referenceable";
    private ProfileConfig config = null;
    private SocialDataLocation dataLocation;
    private JCRSessionManager sessionManager;
    Comparator<Identity> identityComparator = new Comparator<Identity>(){

        @Override
        public int compare(Identity o1, Identity o2) {
            String name1 = o1.getProfile().getProperties().get("firstName").toString();
            String name2 = o2.getProfile().getProperties().get("firstName").toString();
            return name1.compareToIgnoreCase(name2);
        }
    };
    private Node identityServiceHome;
    private Node profileServiceHome;

    public IdentityStorage(SocialDataLocation dataLocation) {
        this.dataLocation = dataLocation;
        this.sessionManager = dataLocation.getSessionManager();
    }

    private Node getIdentityServiceHome(Session session) {
        if (this.identityServiceHome == null) {
            String path = this.dataLocation.getSocialIdentityHome();
            try {
                this.identityServiceHome = session.getRootNode().getNode(path);
            }
            catch (PathNotFoundException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
            catch (RepositoryException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.identityServiceHome;
    }

    private ProfileConfig getConfig() {
        if (this.config == null) {
            PortalContainer container = PortalContainer.getInstance();
            this.config = (ProfileConfig)container.getComponentInstanceOfType(ProfileConfig.class);
        }
        return this.config;
    }

    private Node getProfileServiceHome(Session session) throws Exception {
        if (this.profileServiceHome == null) {
            String path = this.dataLocation.getSocialProfileHome();
            this.profileServiceHome = session.getRootNode().getNode(path);
        }
        return this.profileServiceHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIdentity(Identity identity) {
        Identity checkingIdentity = null;
        try {
            checkingIdentity = this.findIdentity(identity.getProviderId(), identity.getRemoteId());
        }
        catch (Exception checkingException) {
            LOG.warn((Object)("Problem when finding identity with providerId: " + identity.getProviderId() + "; remoteId: " + identity.getRemoteId()), (Throwable)checkingException);
        }
        Session session = this.sessionManager.getOrOpenSession();
        try {
            Node identityNode;
            Node identityHomeNode = this.getIdentityServiceHome(session);
            if (identity.getId() == null) {
                if (checkingIdentity == null) {
                    identityNode = identityHomeNode.addNode(IDENTITY_NODETYPE, IDENTITY_NODETYPE);
                    identityNode.addMixin(REFERENCEABLE_NODE);
                } else {
                    identityNode = session.getNodeByUUID(checkingIdentity.getId());
                }
            } else {
                identityNode = session.getNodeByUUID(identity.getId());
            }
            identityNode.setProperty(IDENTITY_REMOTEID, identity.getRemoteId());
            identityNode.setProperty(IDENTITY_PROVIDERID, identity.getProviderId());
            if (identity.getId() == null) {
                identityHomeNode.save();
                identity.setId(identityNode.getUUID());
            } else {
                identityNode.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("failed to save identity " + identity), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteIdentity(Identity identity) {
        Session session = this.sessionManager.getOrOpenSession();
        try {
            Node identityNode = session.getNodeByUUID(identity.getId());
            if (identity.getProfile().getId() != null) {
                this.deleteProfile(identity.getProfile());
            }
            identityNode.remove();
            session.save();
            LOG.info((Object)("Identity: [" + identity.toString() + "] deleted."));
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProfile(Profile profile) {
        Session session = this.sessionManager.getOrOpenSession();
        try {
            Node profileNode = session.getNodeByUUID(profile.getId());
            profileNode.remove();
            session.save();
        }
        catch (ItemNotFoundException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identity findIdentityById(String nodeId) {
        Session session = this.sessionManager.getOrOpenSession();
        Identity identity = null;
        Node identityNode = null;
        try {
            identityNode = session.getNodeByUUID(nodeId);
            identity = this.getIdentity(identityNode);
        }
        catch (ItemNotFoundException e) {
            LOG.warn((Object)("failed to load identity " + nodeId));
        }
        catch (RepositoryException e) {
            LOG.warn((Object)"failed from repository", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn((Object)("failed getIdentity by identityNode:" + identityNode), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Identity> getAllIdentities() {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        try {
            Session session = this.sessionManager.openSession();
            Node identityHomeNode = this.getIdentityServiceHome(session);
            NodeIterator iter = identityHomeNode.getNodes();
            while (iter.hasNext()) {
                Node identityNode = iter.nextNode();
                Identity identity = this.getIdentity(identityNode);
                identities.add(identity);
            }
            ArrayList<Identity> arrayList = identities;
            return arrayList;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while loading identities", (Throwable)e);
            List<Identity> list = null;
            return list;
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identity findIdentity(String providerId, String remoteId) {
        Session session = this.sessionManager.openSession();
        Node identityHomeNode = this.getIdentityServiceHome(session);
        Identity identity = null;
        try {
            List nodes = new QueryBuilder(session).select(IDENTITY_NODETYPE).like("jcr:path", identityHomeNode.getPath() + "/%").and().equal(IDENTITY_PROVIDERID, providerId).and().equal(IDENTITY_REMOTEID, remoteId).exec();
            if (nodes.size() == 1) {
                Node identityNode = (Node)nodes.get(0);
                identity = this.getIdentity(identityNode);
            } else {
                LOG.debug((Object)("No node found for identity  " + providerId + ":" + remoteId));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("failed to load identity by remote id : " + providerId + ":" + remoteId), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return identity;
    }

    public Identity getIdentity(Node identityNode) throws Exception {
        Identity identity = new Identity(identityNode.getUUID());
        identity.setProviderId(identityNode.getProperty(IDENTITY_PROVIDERID).getString());
        identity.setRemoteId(identityNode.getProperty(IDENTITY_REMOTEID).getString());
        Profile profile = new Profile(identity);
        this.loadProfile(profile);
        identity.setProfile(profile);
        return identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Identity> getIdentitiesByProfileFilter(String identityProvider, ProfileFilter profileFilter, long offset, long limit) throws Exception {
        Session session = this.sessionManager.openSession();
        Node profileHomeNode = this.getProfileServiceHome(session);
        ArrayList<Identity> listIdentity = new ArrayList<Identity>();
        List nodes = null;
        try {
            QueryBuilder queryBuilder = new QueryBuilder(session).select(PROFILE_NODETYPE, offset, limit).like("jcr:path", profileHomeNode.getPath() + "[%]/" + PROFILE_NODETYPE + "[%]");
            String position = this.addPositionSearchPattern(profileFilter.getPosition().trim());
            String gender = profileFilter.getGender().trim();
            if (position.length() != 0) {
                queryBuilder.and().contains("position", position);
            }
            if (gender.length() != 0) {
                queryBuilder.and().equal("gender", gender);
            }
            nodes = queryBuilder.exec();
        }
        catch (Exception e) {
            LOG.warn((Object)("error while filtering identities: " + e.getMessage()));
            ArrayList<Identity> position = new ArrayList<Identity>();
            return position;
        }
        finally {
            this.sessionManager.closeSession();
        }
        String userName = this.processUsernameSearchPattern(profileFilter.getName().trim());
        for (Node profileNode : nodes) {
            Node identityNode = profileNode.getProperty(PROFILE_IDENTITY).getNode();
            Identity identity = this.getIdentity(identityNode);
            if (!identity.getProviderId().equals(identityProvider)) continue;
            if (userName.length() != 0) {
                String fullUserName = identity.getProfile().getFullName();
                String fullNameLC = fullUserName.toLowerCase();
                String userNameLC = userName.toLowerCase();
                if (userNameLC.length() == 0 || !fullNameLC.matches(userNameLC)) continue;
                listIdentity.add(identity);
                continue;
            }
            listIdentity.add(identity);
        }
        Collections.sort(listIdentity, this.identityComparator);
        return listIdentity;
    }

    private String addPositionSearchPattern(String position) {
        if (position.length() != 0) {
            if (position.indexOf("*") == -1) {
                return "*" + position + "*";
            }
            return position;
        }
        return "";
    }

    private String processUsernameSearchPattern(String userName) {
        if (userName.length() > 0) {
            userName = userName == "" || userName.length() == 0 ? "*" : userName;
            userName = userName.charAt(0) != '*' ? "*" + userName : userName;
            userName = userName.charAt(userName.length() - 1) != '*' ? (userName = userName + "*") : userName;
            userName = userName.indexOf("*") >= 0 ? userName.replace("*", ".*") : userName;
            userName = userName.indexOf("%") >= 0 ? userName.replace("%", ".*") : userName;
            Pattern.compile(userName);
        }
        return userName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Identity> getIdentitiesFilterByAlphaBet(String identityProvider, ProfileFilter profileFilter, long offset, long limit) throws Exception {
        ArrayList<Identity> listIdentity = new ArrayList<Identity>();
        try {
            Session session = this.sessionManager.getOrOpenSession();
            Node profileHomeNode = this.getProfileServiceHome(session);
            QueryBuilder queryBuilder = new QueryBuilder(session);
            queryBuilder.select(PROFILE_NODETYPE, offset, limit).like("jcr:path", profileHomeNode.getPath() + "/%");
            String userName = profileFilter.getName();
            if (userName.length() != 0) {
                userName = userName + "*";
                queryBuilder.and().contains("firstName", userName);
            }
            List nodes = queryBuilder.exec();
            for (Node profileNode : nodes) {
                Node identityNode = profileNode.getProperty(PROFILE_IDENTITY).getNode();
                Identity identity = this.getIdentity(identityNode);
                if (!identity.getProviderId().equals(identityProvider)) continue;
                listIdentity.add(identity);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to filter identities by alphabet" + e.getMessage()));
            List<Identity> list = null;
            return list;
        }
        finally {
            this.sessionManager.closeSession();
        }
        return listIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProfile(Profile profile) {
        try {
            Node profileNode;
            Session session = this.sessionManager.getOrOpenSession();
            Node profileHomeNode = this.getProfileServiceHome(session);
            if (profile.getIdentity().getId() == null) {
                LOG.warn((Object)"the identity has to be saved before saving the profile");
                return;
            }
            if (profile.getId() == null) {
                profileNode = profileHomeNode.addNode(PROFILE_NODETYPE, PROFILE_NODETYPE);
                profileNode.addMixin(REFERENCEABLE_NODE);
                Node identityNode = session.getNodeByUUID(profile.getIdentity().getId());
                profileNode.setProperty(PROFILE_IDENTITY, identityNode);
            } else {
                profileNode = session.getNodeByUUID(profile.getId());
            }
            this.saveProfile(profile, profileNode, session);
            if (profile.getId() == null) {
                profileHomeNode.save();
                profile.setId(profileNode.getUUID());
            } else {
                profileNode.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to save profile " + profile), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    protected void saveProfile(Profile profile, Node profileNode, Session session) throws Exception, IOException {
        Map<String, Object> props = profile.getProperties();
        Iterator<String> it = props.keySet().iterator();
        for (String name : props.keySet()) {
            if (name.contains(":")) continue;
            String[] propValue = props.get(name);
            if (this.isForcedMultiValue(name)) {
                if (propValue instanceof String) {
                    propValue = new String[]{(String)propValue};
                }
                this.setProperty(name, propValue, profileNode);
                continue;
            }
            if (propValue instanceof String) {
                profileNode.setProperty(name, (String)propValue);
                continue;
            }
            if (propValue instanceof Double) {
                profileNode.setProperty(name, ((Double)propValue).doubleValue());
                continue;
            }
            if (propValue instanceof Boolean) {
                profileNode.setProperty(name, ((Boolean)propValue).booleanValue());
                continue;
            }
            if (propValue instanceof Long) {
                profileNode.setProperty(name, ((Long)propValue).longValue());
                continue;
            }
            if (propValue instanceof String[]) {
                String[] strings = propValue;
                if (strings.length == 1) {
                    profileNode.setProperty(name, strings[0]);
                    continue;
                }
                this.setProperty(name, strings, profileNode);
                continue;
            }
            if (propValue instanceof List) {
                this.setProperty(name, (List)propValue, profileNode);
                continue;
            }
            if (!(propValue instanceof AvatarAttachment)) continue;
            ExtendedNode extNode = (ExtendedNode)profileNode;
            if (extNode.canAddMixin("exo:privilegeable")) {
                extNode.addMixin("exo:privilegeable");
            }
            String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
            extNode.setPermission(SystemIdentity.ANY, arrayPers);
            List permsList = extNode.getACL().getPermissionEntries();
            for (AccessControlEntry accessControlEntry : permsList) {
                extNode.setPermission(accessControlEntry.getIdentity(), arrayPers);
            }
            AvatarAttachment profileAtt = (AvatarAttachment)propValue;
            if (profileAtt.getFileName() != null) {
                Node nodeContent;
                Node nodeFile;
                try {
                    nodeFile = profileNode.getNode(name);
                }
                catch (PathNotFoundException ex) {
                    nodeFile = profileNode.addNode(name, "nt:file");
                }
                try {
                    nodeContent = nodeFile.getNode("jcr:content");
                }
                catch (PathNotFoundException ex) {
                    nodeContent = nodeFile.addNode("jcr:content", "nt:resource");
                }
                long lastModified = profileAtt.getLastModified();
                long lastSaveTime = 0L;
                if (nodeContent.hasProperty("jcr:lastModified")) {
                    lastSaveTime = nodeContent.getProperty("jcr:lastModified").getLong();
                }
                if (lastModified == 0L || lastModified == lastSaveTime) continue;
                nodeContent.setProperty("jcr:mimeType", profileAtt.getMimeType());
                nodeContent.setProperty("jcr:data", profileAtt.getInputStream(session));
                nodeContent.setProperty("jcr:lastModified", profileAtt.getLastModified());
                continue;
            }
            if (!profileNode.hasNode(name)) continue;
            profileNode.getNode(name).remove();
            session.save();
        }
    }

    private void setProperty(String name, List<Map<String, Object>> props, Node n) throws Exception, VersionException {
        String ntName = this.getNodeTypeName(name);
        if (ntName == null) {
            throw new Exception("no nodeType is defined for " + name);
        }
        NodeIterator nIt = n.getNodes(name);
        while (nIt.hasNext()) {
            Node currNode = nIt.nextNode();
            currNode.remove();
        }
        for (Map<String, Object> prop : props) {
            Node propNode = n.addNode(name, ntName);
            for (String key : prop.keySet()) {
                Object propValue = prop.get(key);
                if (propValue instanceof String) {
                    propNode.setProperty(key, (String)propValue);
                    continue;
                }
                if (propValue instanceof Double) {
                    propNode.setProperty(key, ((Double)propValue).doubleValue());
                    continue;
                }
                if (propValue instanceof Boolean) {
                    propNode.setProperty(key, ((Boolean)propValue).booleanValue());
                    continue;
                }
                if (!(propValue instanceof Long)) continue;
                propNode.setProperty(key, ((Long)propValue).longValue());
            }
        }
    }

    private void setProperty(String name, String[] propValue, Node n) throws IOException, RepositoryException, ConstraintViolationException, VersionException {
        ArrayList<StringValue> values = new ArrayList<StringValue>();
        for (String value : propValue) {
            if (value == null || value.length() <= 0) continue;
            values.add(new StringValue(value));
        }
        n.setProperty(name, values.toArray(new Value[values.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProfile(Profile profile) {
        if (profile.getIdentity().getId() == null) {
            LOG.warn((Object)"Failed to load profile. The identity has to be saved before loading the profile");
            return;
        }
        Session session = this.sessionManager.getOrOpenSession();
        try {
            Node identityNode = session.getNodeByUUID(profile.getIdentity().getId());
            String workspaceName = session.getWorkspace().getName();
            PropertyIterator references = identityNode.getReferences();
            if (references.getSize() == 0L) {
                this.saveProfile(profile);
            } else {
                while (references.hasNext()) {
                    Property nodeReferencedProperty = (Property)references.next();
                    if (!nodeReferencedProperty.getParent().isNodeType(PROFILE_NODETYPE)) continue;
                    Node profileNode = nodeReferencedProperty.getParent();
                    profile.setId(profileNode.getUUID());
                    this.loadProfile(profile, profileNode, workspaceName);
                }
            }
        }
        catch (ItemNotFoundException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    protected boolean isForcedMultiValue(String key) {
        return this.getConfig().isForcedMultiValue(key);
    }

    protected String getNodeTypeName(String nodeName) {
        return this.getConfig().getNodeType(nodeName);
    }

    protected void loadProfile(Profile profile, Node profileNode, String workspaceName) throws RepositoryException {
        PropertyIterator props = profileNode.getProperties();
        this.copyPropertiesToMap(props, profile.getProperties());
        NodeIterator it = profileNode.getNodes();
        while (it.hasNext()) {
            Node node = it.nextNode();
            if (node.getName().equals(PROFILE_AVATAR)) {
                if (!node.isNodeType("nt:file")) continue;
                AvatarAttachment file = new AvatarAttachment();
                file.setId(node.getPath());
                file.setMimeType(node.getNode("jcr:content").getProperty("jcr:mimeType").getString());
                try {
                    file.setInputStream(node.getNode("jcr:content").getProperty("jcr:data").getValue().getStream());
                }
                catch (Exception e) {
                    LOG.warn((Object)("Failed to load data for avatar of " + profile + ": " + e.getMessage()));
                }
                file.setLastModified(node.getNode("jcr:content").getProperty("jcr:lastModified").getLong());
                file.setFileName(node.getName());
                file.setWorkspace(workspaceName);
                profile.setProperty(node.getName(), file);
                continue;
            }
            List l = (List)profile.getProperty(node.getName());
            if (l != null) continue;
            profile.setProperty(node.getName(), new ArrayList());
            l = (List)profile.getProperty(node.getName());
            l.add(this.copyPropertiesToMap(node.getProperties(), new HashMap()));
        }
    }

    private Map copyPropertiesToMap(PropertyIterator props, Map map) throws RepositoryException {
        while (props.hasNext()) {
            Property prop = (Property)props.next();
            if (prop.getName().contains(":")) continue;
            try {
                Value v = prop.getValue();
                if (v instanceof StringValue) {
                    map.put(prop.getName(), v.getString());
                    continue;
                }
                if (v instanceof LongValue) {
                    map.put(prop.getName(), v.getLong());
                    continue;
                }
                if (v instanceof DoubleValue) {
                    map.put(prop.getName(), v.getDouble());
                    continue;
                }
                if (!(v instanceof BooleanValue)) continue;
                map.put(prop.getName(), v.getBoolean());
            }
            catch (ValueFormatException e) {
                Value[] values = prop.getValues();
                ArrayList<String> res = new ArrayList<String>();
                for (Value v : values) {
                    res.add(v.getString());
                }
                map.put(prop.getName(), res.toArray(new String[res.size()]));
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getType(String nodetype, String property) throws Exception {
        try {
            PropertyDefinition[] pDefs;
            Session session = this.sessionManager.openSession();
            NodeTypeManager ntManager = session.getWorkspace().getNodeTypeManager();
            NodeType nt = ntManager.getNodeType(nodetype);
            for (PropertyDefinition pDef : pDefs = nt.getDeclaredPropertyDefinitions()) {
                if (!pDef.getName().equals(property)) continue;
                String string = PropertyType.nameFromValue((int)pDef.getRequiredType());
                return string;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Could not find type of property " + property + " for nodetype " + nodetype));
            String string = null;
            return string;
        }
        finally {
            this.sessionManager.closeSession();
        }
        return null;
    }
}

