/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardTermEnum;

public class WildcardQuery
extends MultiTermQuery {
    private boolean termContainsWildcard;

    public WildcardQuery(Term term) {
        super(term);
        this.termContainsWildcard = term.text().indexOf(42) != -1 || term.text().indexOf(63) != -1;
    }

    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new WildcardTermEnum(reader, this.getTerm());
    }

    public boolean equals(Object o) {
        if (o instanceof WildcardQuery) {
            return super.equals(o);
        }
        return false;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.termContainsWildcard) {
            return super.rewrite(reader);
        }
        return new TermQuery(this.getTerm());
    }
}

