/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.application;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceActivityPublisher
extends SpaceListenerPlugin {
    public static final String SPACES_ACTIVITY_TYPE = "exosocial:spaces";
    public static final String SPACE_DISPLAY_NAME_PARAM = "SPACE_DISPLAY_NAME_PARAM";
    public static final String USER_NAME_PARAM = "USER_NAME_PARAM";
    private static Log LOG = ExoLogger.getExoLogger(SpaceActivityPublisher.class);
    private ActivityManager activityManager;
    private IdentityManager identityManager;

    public SpaceActivityPublisher(InitParams params, ActivityManager activityManager, IdentityManager identityManager) throws Exception {
        this.activityManager = activityManager;
        this.identityManager = identityManager;
    }

    @Override
    public void spaceCreated(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String activityMessage = space.getName() + " was created by @" + event.getTarget() + " .";
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put(SPACE_DISPLAY_NAME_PARAM, space.getName());
        templateParams.put(USER_NAME_PARAM, "@" + event.getTarget());
        this.recordActivity(event, this.createActivity(event, activityMessage, "space_created", templateParams));
    }

    @Override
    public void spaceRemoved(SpaceLifeCycleEvent event) {
        LOG.info((Object)("space " + event.getSpace().getName() + " was removed!"));
    }

    @Override
    public void applicationActivated(SpaceLifeCycleEvent event) {
        LOG.info((Object)("application <b>" + event.getTarget() + "</b> was activated in space " + event.getSpace().getName()));
    }

    @Override
    public void applicationAdded(SpaceLifeCycleEvent event) {
        LOG.info((Object)("application <b>" + event.getTarget() + "</b> was added in space " + event.getSpace().getName()));
    }

    @Override
    public void applicationDeactivated(SpaceLifeCycleEvent event) {
        LOG.info((Object)("application " + event.getTarget() + " was deactivated in space " + event.getSpace().getName()));
    }

    @Override
    public void applicationRemoved(SpaceLifeCycleEvent event) {
        LOG.info((Object)("application " + event.getTarget() + " was removed in space " + event.getSpace().getName()));
    }

    @Override
    public void grantedLead(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String activityMessage = "@" + event.getTarget() + " was granted manager role.";
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put(USER_NAME_PARAM, "@" + event.getTarget());
        this.recordActivity(event, this.createActivity(event, activityMessage, "manager_role_granted", templateParams));
        LOG.debug((Object)("user " + event.getTarget() + " was granted manager role of space " + space.getName()));
    }

    @Override
    public void joined(SpaceLifeCycleEvent event) {
        String activityMessage = "@" + event.getTarget() + " has joined the space.";
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put(USER_NAME_PARAM, "@" + event.getTarget());
        this.recordActivity(event, this.createActivity(event, activityMessage, "user_joined", templateParams));
        LOG.debug((Object)("user " + event.getTarget() + " joined space " + event.getSpace().getName()));
    }

    @Override
    public void left(SpaceLifeCycleEvent event) {
        String activityMessage = "@" + event.getTarget() + " has left the space.";
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put(USER_NAME_PARAM, "@" + event.getTarget());
        this.recordActivity(event, this.createActivity(event, activityMessage, "member_left", templateParams));
        LOG.debug((Object)("user " + event.getTarget() + " has left of space " + event.getSpace().getName()));
    }

    @Override
    public void revokedLead(SpaceLifeCycleEvent event) {
        LOG.info((Object)("user " + event.getTarget() + " was revoked lead privileges of space " + event.getSpace().getName()));
    }

    private Activity createActivity(SpaceLifeCycleEvent event, String activityMessage, String titleId, Map<String, String> templateParams) {
        Activity activity = new Activity();
        activity.setType(SPACES_ACTIVITY_TYPE);
        activity.setTitle(activityMessage);
        activity.setTitleId(titleId);
        activity.setTemplateParams(templateParams);
        return activity;
    }

    private void recordActivity(SpaceLifeCycleEvent event, Activity activity) {
        Space space = event.getSpace();
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getName(), false);
        this.activityManager.saveActivity(spaceIdentity, activity);
    }
}

