/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity.model;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.image.ImageUtils;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.service.LinkProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profile {
    public static final String GENDER = "gender";
    public static final String USERNAME = "username";
    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";
    public static final String EMAIL = "email";
    public static final String AVATAR = "avatar";
    public static final String AVATAR_URL = "avatarUrl";
    public static final String EXPERIENCES = "experiences";
    public static final String EXPERIENCES_COMPANY = "company";
    public static final String EXPERIENCES_POSITION = "position";
    public static final String EXPERIENCES_SKILLS = "skills";
    public static final String EXPERIENCES_START_DATE = "startDate";
    public static final String EXPERIENCES_END_DATE = "endDate";
    public static final String EXPERIENCES_IS_CURRENT = "isCurrent";
    public static final String EXPERIENCES_DESCRIPTION = "description";
    public static final String POSITION = "position";
    public static final String URL = "Url";
    public static final String CONTACT_PHONES = "phones";
    public static final String CONTACT_IMS = "ims";
    public static final String CONTACT_URLS = "urls";
    public static final String URL_POSTFIX = "Url";
    public static final String RESIZED_SUBFIX = "RESIZED_";
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Identity identity;
    private String id;
    private long lastLoaded;
    private boolean hasChanged;

    public Profile(Identity identity) {
        this.identity = identity;
    }

    public final Identity getIdentity() {
        return this.identity;
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final long getLastLoaded() {
        return this.lastLoaded;
    }

    public final void setLastLoaded(long lastLoaded) {
        this.lastLoaded = lastLoaded;
    }

    public final boolean hasChanged() {
        return this.hasChanged;
    }

    public final void clearHasChanged() {
        this.setHasChanged(false);
    }

    private void setHasChanged(boolean hasChanged) {
        this.hasChanged = hasChanged;
    }

    public final Object getProperty(String name) {
        return this.properties.get(name);
    }

    public final void setProperty(String name, Object value) {
        this.properties.put(name, value);
        this.setHasChanged(true);
    }

    public final boolean contains(String name) {
        return this.properties.containsKey(name);
    }

    public final Map<String, Object> getProperties() {
        return this.properties;
    }

    public final void removeProperty(String name) {
        this.properties.remove(name);
        this.setHasChanged(true);
    }

    @Deprecated
    public final Object getPropertyValue(String name) {
        return this.getProperty(name);
    }

    public final String getFullName() {
        String first = (String)this.getProperty(FIRST_NAME);
        String last = (String)this.getProperty(LAST_NAME);
        String all = first != null ? first : "";
        all = all + (last != null ? " " + last : "");
        return all;
    }

    public final String getAvatarImageSource() {
        String avatarUrl = (String)this.getProperty(AVATAR_URL);
        if (avatarUrl != null) {
            return avatarUrl;
        }
        AvatarAttachment avatarAttachment = (AvatarAttachment)this.getProperty(AVATAR);
        if (avatarAttachment != null) {
            avatarUrl = LinkProvider.buildAvatarUrl(avatarAttachment);
            return this.escapeJCRSpecialCharacters(avatarUrl);
        }
        return null;
    }

    public final String getAvatarImageSource(PortalContainer containerByName) {
        return this.getAvatarImageSource();
    }

    public final String getAvatarImageSource(int width, int height) {
        String postfix = ImageUtils.buildImagePostfix(width, height);
        String keyFile = AVATAR + postfix;
        String keyURL = AVATAR + postfix + "Url";
        String avatarUrl = (String)this.getProperty(keyURL);
        if (avatarUrl != null) {
            return avatarUrl;
        }
        IdentityManager identityManager = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
        AvatarAttachment avatarAttachment = (AvatarAttachment)this.getProperty(keyURL);
        if (avatarAttachment != null) {
            avatarUrl = LinkProvider.buildAvatarUrl(avatarAttachment);
            this.setProperty(keyURL, avatarUrl);
            identityManager.saveProfile(this);
            return avatarUrl;
        }
        avatarAttachment = (AvatarAttachment)this.getProperty(AVATAR);
        if (avatarAttachment == null) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(avatarAttachment.getImageBytes());
        String mimeType = avatarAttachment.getMimeType();
        AvatarAttachment newAvatarAttachment = ImageUtils.createResizedAvatarAttachment(inputStream, width, height, avatarAttachment.getId() + postfix, ImageUtils.buildFileName(avatarAttachment.getFileName(), RESIZED_SUBFIX, postfix), mimeType, avatarAttachment.getWorkspace());
        if (newAvatarAttachment == null) {
            return this.getAvatarImageSource();
        }
        this.setProperty(keyFile, newAvatarAttachment);
        identityManager.saveProfile(this);
        avatarUrl = LinkProvider.buildAvatarUrl(newAvatarAttachment);
        this.setProperty(keyURL, avatarUrl);
        identityManager.saveProfile(this);
        return this.escapeJCRSpecialCharacters(avatarUrl);
    }

    public final String getUrl() {
        return (String)this.getProperty("Url");
    }

    public final void addOrModifyProperties(Map<String, Object> props) {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String key = entry.getKey();
            if (key.contains(":")) continue;
            this.setProperty(key, entry.getValue());
        }
        this.setHasChanged(true);
    }

    public final String toString() {
        return "[uuid : " + this.id + " identity : " + this.identity.getId() + " properties: " + this.properties;
    }

    private String escapeJCRSpecialCharacters(String string) {
        return string.replace("[", "%5B").replace("]", "%5D").replace(":", "%3A");
    }
}

