/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import com.ibm.icu.text.Transliterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.common.util.Tools;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.info.PortletInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceUtils {
    private static final Log LOG = ExoLogger.getLogger(SpaceUtils.class);
    public static final String SPACE_GROUP = "/spaces";
    public static final String PLATFORM_USERS_GROUP = "/platform/users";
    public static final String MANAGER = "manager";
    public static final String MENU_CONTAINER = "Menu";
    public static final String APPLICATION_CONTAINER = "Application";
    public static final String SPACE_URL = "SPACE_URL";
    private static final ConcurrentHashMap<String, org.exoplatform.application.registry.Application> appListCache = new ConcurrentHashMap();
    private static final String REMOTE_CATEGORY_NAME = "remote";
    private static final Transliterator ACCENTS_CONVERTER = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");

    public static Group createGroupFromExistingGroup(Group parentGroup, Group existingGroup, String name) throws Exception {
        OrganizationService orgSrc = SpaceUtils.getOrganizationService();
        GroupHandler groupHandler = orgSrc.getGroupHandler();
        MembershipHandler memberShipHandler = orgSrc.getMembershipHandler();
        Group newGroup = groupHandler.createGroupInstance();
        newGroup.setGroupName(name);
        newGroup.setLabel(name);
        newGroup.setDescription(existingGroup.getDescription());
        groupHandler.addChild(parentGroup, newGroup, true);
        Collection memberShips = memberShipHandler.findMembershipsByGroup(existingGroup);
        for (Membership membership : memberShips) {
            User user = orgSrc.getUserHandler().findUserByName(membership.getUserName());
            MembershipType memberShipType = orgSrc.getMembershipTypeHandler().findMembershipType(membership.getMembershipType());
            memberShipHandler.linkMembership(user, newGroup, memberShipType, true);
        }
        return newGroup;
    }

    public static List<org.exoplatform.application.registry.Application> getApplications(String groupId) throws Exception {
        CopyOnWriteArrayList<org.exoplatform.application.registry.Application> list = new CopyOnWriteArrayList<org.exoplatform.application.registry.Application>();
        ApplicationRegistryService appRegistrySrc = SpaceUtils.getApplicationRegistryService();
        List listCategory = appRegistrySrc.getApplicationCategories();
        Iterator cateItr = listCategory.iterator();
        while (cateItr.hasNext()) {
            ApplicationCategory cate = (ApplicationCategory)cateItr.next();
            if (!SpaceUtils.hasAccessPermission(cate, groupId)) {
                cateItr.remove();
                continue;
            }
            ApplicationType portletType = ApplicationType.PORTLET;
            List applications = appRegistrySrc.getApplications(cate, new ApplicationType[]{portletType});
            Iterator appIterator = applications.iterator();
            while (appIterator.hasNext()) {
                org.exoplatform.application.registry.Application app = (org.exoplatform.application.registry.Application)appIterator.next();
                if (!SpaceUtils.hasAccessPermission(app, groupId)) {
                    appIterator.remove();
                    continue;
                }
                list.add(app);
            }
        }
        return list;
    }

    public static Map<ApplicationCategory, List<org.exoplatform.application.registry.Application>> getAppStore(Space space) throws Exception {
        LinkedHashMap<ApplicationCategory, List<org.exoplatform.application.registry.Application>> appStore = new LinkedHashMap<ApplicationCategory, List<org.exoplatform.application.registry.Application>>();
        ApplicationRegistryService appRegistryService = SpaceUtils.getApplicationRegistryService();
        String groupId = space.getGroupId();
        List categoryList = appRegistryService.getApplicationCategories();
        Collections.sort(categoryList, new PortletCategoryComparator());
        for (ApplicationCategory appCategory : categoryList) {
            if (!SpaceUtils.hasAccessPermission(appCategory, groupId)) continue;
            ArrayList<org.exoplatform.application.registry.Application> tempAppList = new ArrayList<org.exoplatform.application.registry.Application>();
            List appList = appCategory.getApplications();
            Collections.sort(appList, new PortletComparator());
            for (org.exoplatform.application.registry.Application application : appList) {
                if (!SpaceUtils.hasAccessPermission(application, groupId)) continue;
                tempAppList.add(application);
            }
            if (tempAppList.size() <= 0) continue;
            appStore.put(appCategory, tempAppList);
        }
        return appStore;
    }

    public static org.exoplatform.application.registry.Application getAppFromPortalContainer(String appId) throws Exception {
        if (appListCache.containsKey(appId)) {
            return appListCache.get(appId);
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortletInvoker portletInvoker = (PortletInvoker)container.getComponentInstance(PortletInvoker.class);
        Set portlets = portletInvoker.getPortlets();
        ApplicationRegistryService appRegistryService = SpaceUtils.getApplicationRegistryService();
        for (Portlet portlet : portlets) {
            org.exoplatform.application.registry.Application app;
            Object[] arr$;
            int len$;
            int i$;
            String keywords;
            PortletInfo info = portlet.getInfo();
            String portletApplicationName = info.getApplicationName();
            String portletName = info.getName();
            portletApplicationName = portletApplicationName.replace('/', '_');
            if (!(portletName = portletName.replace('/', '_')).equals(appId)) continue;
            LocalizedString keywordsLS = info.getMeta().getMetaValue("keywords");
            Object[] categoryNames = null;
            if (keywordsLS != null && (keywords = keywordsLS.getDefaultString()) != null && keywords.length() != 0) {
                categoryNames = keywords.split(",");
            }
            if (categoryNames == null || categoryNames.length == 0) {
                categoryNames = new String[]{portletApplicationName};
            }
            if (portlet.isRemote()) {
                categoryNames = (String[])Tools.appendTo((Object[])categoryNames, (Object)REMOTE_CATEGORY_NAME);
            }
            if ((i$ = 0) >= (len$ = (arr$ = categoryNames).length)) continue;
            Object categoryName = arr$[i$];
            ApplicationCategory category = appRegistryService.getApplicationCategory((String)(categoryName = ((String)categoryName).trim()));
            if (category == null) {
                category = new ApplicationCategory();
                category.setName((String)categoryName);
                category.setDisplayName((String)categoryName);
            }
            if ((app = appRegistryService.getApplication((String)categoryName + "/" + portletName)) != null) {
                return app;
            }
            LocalizedString descriptionLS = portlet.getInfo().getMeta().getMetaValue("description");
            LocalizedString displayNameLS = portlet.getInfo().getMeta().getMetaValue("display-name");
            SpaceUtils.getLocalizedStringValue(descriptionLS, portletName);
            app = new org.exoplatform.application.registry.Application();
            String contentId = portlet.isRemote() ? portlet.getContext().getId() : info.getApplicationName() + "/" + info.getName();
            app.setType(ApplicationType.PORTLET);
            app.setContentId(contentId);
            app.setApplicationName(portletName);
            app.setCategoryName((String)categoryName);
            app.setDisplayName(SpaceUtils.getLocalizedStringValue(displayNameLS, portletName));
            app.setDescription(SpaceUtils.getLocalizedStringValue(descriptionLS, portletName));
            org.exoplatform.application.registry.Application oldApp = appListCache.putIfAbsent(app.getApplicationName(), app);
            return oldApp == null ? app : oldApp;
        }
        return null;
    }

    public static String cleanString(String str) {
        str = ACCENTS_CONVERTER.transliterate(str);
        StringBuilder cleanedStr = new StringBuilder(str.trim());
        for (int i = 0; i < cleanedStr.length(); ++i) {
            char c = cleanedStr.charAt(i);
            if (c == ' ') {
                if (i > 0 && cleanedStr.charAt(i - 1) == '_') {
                    cleanedStr.deleteCharAt(i--);
                    continue;
                }
                c = '_';
                cleanedStr.setCharAt(i, c);
                continue;
            }
            if (!Character.isLetterOrDigit(c) && c != '_') {
                cleanedStr.deleteCharAt(i--);
                continue;
            }
            if (i <= 0 || c != 95 || cleanedStr.charAt(i - 1) != '_') continue;
            cleanedStr.deleteCharAt(i--);
        }
        return cleanedStr.toString().toLowerCase();
    }

    public static String getSpaceUrl() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences pref = pcontext.getRequest().getPreferences();
        return pref.getValue(SPACE_URL, "");
    }

    public static void changeSpaceUrlPreference(PageNode spacePageNode, Space space, String newSpaceName) throws Exception {
        String pageId = spacePageNode.getPageReference();
        DataStorage dataStorage = SpaceUtils.getDataStorage();
        Page page = dataStorage.getPage(pageId);
        page.setTitle(page.getTitle().replace(space.getName(), newSpaceName));
        dataStorage.save(page);
        ArrayList pageChildren = page.getChildren();
        Container menuContainer = SpaceUtils.findContainerById(pageChildren, MENU_CONTAINER);
        Application menuPortlet = (Application)menuContainer.getChildren().get(0);
        ApplicationState menuState = menuPortlet.getState();
        try {
            org.exoplatform.portal.pom.spi.portlet.Portlet menuPortletPreference = (org.exoplatform.portal.pom.spi.portlet.Portlet)dataStorage.load(menuState, ApplicationType.PORTLET);
            menuPortletPreference.setValue(SPACE_URL, space.getUrl());
            dataStorage.save(menuState, (Object)menuPortletPreference);
        }
        catch (Exception e) {
            LOG.warn((Object)"Can not save menu portlet preference!");
            e.printStackTrace();
        }
        Container applicationContainer = SpaceUtils.findContainerById(pageChildren, APPLICATION_CONTAINER);
        try {
            Application applicationPortlet = (Application)applicationContainer.getChildren().get(0);
            ApplicationState appState = applicationPortlet.getState();
            try {
                org.exoplatform.portal.pom.spi.portlet.Portlet appPortletPreference = (org.exoplatform.portal.pom.spi.portlet.Portlet)dataStorage.load(appState, ApplicationType.PORTLET);
                if (appPortletPreference == null || appPortletPreference.getPreference(SPACE_URL) == null) {
                    return;
                }
                appPortletPreference.setValue(SPACE_URL, space.getUrl());
                dataStorage.save(appState, (Object)appPortletPreference);
            }
            catch (Exception e) {
                LOG.warn((Object)"Can not save application portlet preference!");
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static Container findContainerById(ArrayList<ModelObject> children, String id) {
        Container found = null;
        for (ModelObject obj : children) {
            if (Application.class.isInstance(obj)) continue;
            Container child = (Container)obj;
            if (child.getId() == null) {
                found = SpaceUtils.findContainerById(child.getChildren(), id);
                if (found == null) continue;
                return found;
            }
            if (child.getId().equals(id)) {
                return child;
            }
            found = SpaceUtils.findContainerById(child.getChildren(), id);
            if (found == null) continue;
            return found;
        }
        return found;
    }

    public static void setNavigation(PageNavigation nav) {
        if (nav == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (context == null) {
            return;
        }
        UIPortalApplication uiPortalApplication = Util.getUIPortalApplication();
        try {
            UserPortalConfig userPortalConfig = uiPortalApplication.getUserPortalConfig();
            List navs = userPortalConfig.getNavigations();
            PageNavigation selectedNav = Util.getUIPortal().getSelectedNavigation();
            if (selectedNav.getId() == nav.getId()) {
                Util.getUIPortal().setSelectedNavigation(nav);
            }
            boolean alreadyExisted = false;
            for (int i = 0; i < navs.size(); ++i) {
                if (((PageNavigation)navs.get(i)).getId() != nav.getId()) continue;
                navs.set(i, nav);
                alreadyExisted = true;
                return;
            }
            if (!alreadyExisted) {
                navs.add(nav);
            }
            userPortalConfig.setNavigations(navs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeNavigation(PageNavigation nav) throws Exception {
        UserPortalConfig userPortalConfig = Util.getUIPortalApplication().getUserPortalConfig();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
        if (dataStorage == null) {
            LOG.warn((Object)"dataStorage is null!");
            return;
        }
        List navs = userPortalConfig.getNavigations();
        navs.remove(nav);
        try {
            userPortalConfig.setNavigations(navs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadNavigation() throws Exception {
        String groupId;
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        SpaceService spaceService = (SpaceService)container.getComponentInstanceOfType(SpaceService.class);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        List<Space> spaces = spaceService.getAccessibleSpaces(userId);
        UserPortalConfig userPortalConfig = Util.getUIPortalApplication().getUserPortalConfig();
        List navs = userPortalConfig.getNavigations();
        ArrayList<PageNavigation> spaceNavs = new ArrayList<PageNavigation>();
        for (PageNavigation nav : navs) {
            String ownerId = nav.getOwnerId();
            try {
                Space space = SpaceUtils.getSpaceByGroupId(ownerId);
                if (space == null) continue;
                spaceNavs.add(nav);
            }
            catch (Exception e) {}
        }
        boolean spaceContained = false;
        for (Space space : spaces) {
            groupId = space.getGroupId();
            for (PageNavigation nav : spaceNavs) {
                if (!groupId.equals(nav.getOwnerId())) continue;
                spaceContained = true;
                break;
            }
            if (spaceContained) continue;
            SpaceUtils.setNavigation(SpaceUtils.getGroupNavigation(groupId));
        }
        if (spaces.size() == 0) {
            for (PageNavigation nav : spaceNavs) {
                SpaceUtils.removeNavigation(nav);
            }
        } else {
            boolean navContained = false;
            for (PageNavigation nav : spaceNavs) {
                for (Space space : spaces) {
                    groupId = space.getGroupId();
                    if (!groupId.equals(nav.getOwnerId())) continue;
                    navContained = true;
                    break;
                }
                if (navContained) continue;
                SpaceUtils.removeNavigation(nav);
            }
        }
    }

    private static Space getSpaceByGroupId(String groupId) throws SpaceException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        SpaceService spaceService = (SpaceService)container.getComponentInstanceOfType(SpaceService.class);
        return spaceService.getSpaceByGroupId(groupId);
    }

    public static void updateWorkingWorkSpace() {
        UIPortalApplication uiPortalApplication = Util.getUIPortalApplication();
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApplication.getChildById("UIWorkingWorkspace");
        PortalRequestContext pContext = Util.getPortalRequestContext();
        pContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        pContext.setFullRender(true);
    }

    public static String createGroup(String spaceName, String creator) throws SpaceException {
        String groupId;
        OrganizationService organizationService = SpaceUtils.getOrganizationService();
        GroupHandler groupHandler = organizationService.getGroupHandler();
        try {
            Group parentGroup = groupHandler.findGroupById(SPACE_GROUP);
            Group newGroup = groupHandler.createGroupInstance();
            String shortName = SpaceUtils.cleanString(spaceName);
            groupId = parentGroup.getId() + "/" + shortName;
            if (SpaceUtils.isSpaceNameExisted(spaceName)) {
                throw new SpaceException(SpaceException.Code.SPACE_ALREADY_EXIST);
            }
            newGroup.setGroupName(shortName);
            newGroup.setLabel(spaceName);
            newGroup.setDescription("the " + parentGroup.getId() + "/" + shortName + " group");
            groupHandler.addChild(parentGroup, newGroup, true);
        }
        catch (Exception e) {
            if (e instanceof SpaceException) {
                throw (SpaceException)e;
            }
            throw new SpaceException(SpaceException.Code.UNABLE_TO_CREATE_GROUP, (Throwable)e);
        }
        try {
            SpaceUtils.addCreatorToGroup(creator, groupId);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_ADD_CREATOR, (Throwable)e);
        }
        return groupId;
    }

    public static void removeGroup(Space space) throws SpaceException {
        try {
            OrganizationService organizationService = SpaceUtils.getOrganizationService();
            GroupHandler groupHandler = organizationService.getGroupHandler();
            Group group = groupHandler.findGroupById(space.getGroupId());
            groupHandler.removeGroup(group, true);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_GROUP, (Throwable)e);
        }
    }

    public static boolean isSpaceNameExisted(String spaceName) throws SpaceException {
        PortalContainer portalContainer = PortalContainer.getInstance();
        SpaceService spaceService = (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
        List<Space> spaces = spaceService.getAllSpaces();
        for (Space space : spaces) {
            if (!SpaceUtils.cleanString(space.getName()).equalsIgnoreCase(SpaceUtils.cleanString(spaceName))) continue;
            return true;
        }
        return false;
    }

    public static void addCreatorToGroup(String creator, String groupId) throws SpaceException {
        PortalContainer portalContainer = PortalContainer.getInstance();
        OrganizationService organizationService = (OrganizationService)portalContainer.getComponentInstanceOfType(OrganizationService.class);
        try {
            GroupHandler groupHandler = organizationService.getGroupHandler();
            Group existingGroup = groupHandler.findGroupById(groupId);
            User user = organizationService.getUserHandler().findUserByName(creator);
            MembershipType membershipType = organizationService.getMembershipTypeHandler().findMembershipType(MANAGER);
            organizationService.getMembershipHandler().linkMembership(user, existingGroup, membershipType, true);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_ADD_CREATOR, (Throwable)e);
        }
    }

    public static PageNavigation createGroupNavigation(String groupId) throws SpaceException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        DataStorage dataStorage = (DataStorage)container.getComponentInstance(DataStorage.class);
        try {
            PageNavigation spaceNav = dataStorage.getPageNavigation("group", groupId);
            if (spaceNav == null) {
                spaceNav = new PageNavigation();
                spaceNav.setOwnerType("group");
                spaceNav.setOwnerId(groupId);
                spaceNav.setModifiable(true);
                dataStorage.create(spaceNav);
            }
            return spaceNav;
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_CREAT_NAV, (Throwable)e);
        }
    }

    public static void removeGroupNavigation(String groupId) throws SpaceException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
        try {
            PageNavigation spaceNav = dataStorage.getPageNavigation("group", groupId);
            if (spaceNav == null) {
                throw new Exception("spaceNav is null");
            }
            UIPortal uiPortal = Util.getUIPortal();
            List pnavigations = uiPortal.getNavigations();
            pnavigations.remove(spaceNav);
            dataStorage.remove(spaceNav);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_NAV, (Throwable)e);
        }
    }

    public static PageNavigation getGroupNavigation(String groupId) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
        return dataStorage.getPageNavigation("group", groupId);
    }

    public static PageNode getHomeNode(PageNavigation pageNavigation, String spaceUrl) {
        PageNode homeNode = pageNavigation.getNode(spaceUrl);
        if (homeNode == null) {
            ArrayList pageNodes = pageNavigation.getNodes();
            for (PageNode pageNode : pageNodes) {
                if (!pageNode.getUri().equals(spaceUrl)) continue;
                homeNode = pageNode;
                break;
            }
        }
        return homeNode;
    }

    public static List<Space> getOrderedSpaces(List<Space> spaces) {
        Iterator<Space> itr = spaces.iterator();
        ArrayList<Space> orderedSpaces = new ArrayList<Space>();
        ArrayList<Space> middleSpaces = new ArrayList<Space>();
        ArrayList<Space> lowSpaces = new ArrayList<Space>();
        Space space = null;
        while (itr.hasNext()) {
            space = itr.next();
            String priority = space.getPriority();
            if (priority.equals("1")) {
                orderedSpaces.add(space);
                continue;
            }
            if (priority.equals("2")) {
                middleSpaces.add(space);
                continue;
            }
            if (!priority.equals("3")) continue;
            lowSpaces.add(space);
        }
        for (Space sp : middleSpaces) {
            orderedSpaces.add(sp);
        }
        for (Space sp : lowSpaces) {
            orderedSpaces.add(sp);
        }
        return orderedSpaces;
    }

    public static int countMembers(Space space) throws SpaceException {
        try {
            PortalContainer portalContainer = PortalContainer.getInstance();
            SpaceService spaceService = (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
            return spaceService.getMembers(space).size();
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to count space members for " + space), (Throwable)e);
            return 0;
        }
    }

    public static String getAppStatus(Space space, String appId) {
        String installedApps = space.getApp();
        if (installedApps == null) {
            return null;
        }
        if (installedApps.contains(appId)) {
            String appStatusPattern = SpaceUtils.getAppStatusPattern(installedApps, appId);
            return appStatusPattern.split(":")[3];
        }
        return null;
    }

    public static String getAppNodeName(Space space, String appId) {
        String installedApps = space.getApp();
        if (installedApps == null) {
            return null;
        }
        if (installedApps.contains(appId)) {
            String appStatusPatern = SpaceUtils.getAppStatusPattern(installedApps, appId);
            return appStatusPatern.split(":")[1];
        }
        return null;
    }

    public static boolean isRemovableApp(Space space, String appId) {
        String appStatus;
        String[] spliter;
        String installedApps = space.getApp();
        return !installedApps.contains(appId) || !(spliter = (appStatus = SpaceUtils.getAppStatusPattern(installedApps, appId)).split(":"))[2].equals("false");
    }

    public static List<String> getAppIdList(Space space) {
        ArrayList<String> appIdList = new ArrayList<String>();
        String installedApps = space.getApp();
        if (installedApps != null) {
            if (installedApps.contains(",")) {
                String[] appStatuses;
                for (String appStatus : appStatuses = installedApps.split(",")) {
                    appIdList.add(appStatus.split(":")[0]);
                }
            } else {
                appIdList.add(installedApps.split(":")[0]);
            }
        }
        return appIdList;
    }

    public static String getAbsoluteUrl() throws SpaceException {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        HttpServletRequest request = portalRequestContext.getRequest();
        String str = request.getRequestURL().toString();
        return str.substring(0, str.indexOf(portalRequestContext.getRequestContextPath()));
    }

    public static void checkUserExisting(String userName) throws SpaceException {
        OrganizationService orgService = SpaceUtils.getOrganizationService();
        User user = null;
        try {
            user = orgService.getUserHandler().findUserByName(userName);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_RETRIEVING_USER, (Throwable)e);
        }
        if (user == null) {
            throw new SpaceException(SpaceException.Code.ERROR_RETRIEVING_USER);
        }
    }

    public static boolean isInstalledApp(Space space, String appId) {
        String installedApps = space.getApp();
        if (installedApps == null) {
            return false;
        }
        String[] apps = installedApps.split(",");
        for (int idx = 0; idx < apps.length; ++idx) {
            String[] appPart = apps[idx].split(":");
            if (!appPart[0].equals(appId)) continue;
            return true;
        }
        return false;
    }

    public static String getDisplayAppName(String appDisplayName) {
        int len = appDisplayName.length() - 1;
        if (appDisplayName.toLowerCase().endsWith("portlet")) {
            return appDisplayName.substring(0, len - 7);
        }
        if (appDisplayName.toLowerCase().endsWith("gadget")) {
            return appDisplayName.substring(0, len - 6);
        }
        return appDisplayName;
    }

    private static String getAppStatusPattern(String installedApps, String appId) {
        if (installedApps == null) {
            return null;
        }
        if (installedApps.contains(appId)) {
            String[] splited;
            String appStatus = installedApps.substring(installedApps.indexOf(appId));
            if (appStatus.contains(",")) {
                appStatus = appStatus.substring(0, appStatus.indexOf(","));
            }
            if ((splited = appStatus.split(":")).length != 4) {
                LOG.warn((Object)("appStatus is not in correct form of [appId:appNodeName:isRemovableString:status] : " + appStatus));
                return null;
            }
            return appStatus;
        }
        return null;
    }

    private static boolean hasAccessPermission(org.exoplatform.application.registry.Application app, String groupId) throws Exception {
        ArrayList permissions = app.getAccessPermissions();
        if (permissions == null) {
            return false;
        }
        for (String ele : permissions) {
            if (!SpaceUtils.hasViewPermission(ele, groupId)) continue;
            return true;
        }
        return false;
    }

    public static OrganizationService getOrganizationService() {
        PortalContainer portalContainer = PortalContainer.getInstance();
        return (OrganizationService)portalContainer.getComponentInstanceOfType(OrganizationService.class);
    }

    public static DataStorage getDataStorage() {
        PortalContainer portalContainer = PortalContainer.getInstance();
        return (DataStorage)portalContainer.getComponentInstanceOfType(DataStorage.class);
    }

    private static boolean hasAccessPermission(ApplicationCategory app, String groupId) throws Exception {
        List permissions = app.getAccessPermissions();
        if (permissions == null) {
            return false;
        }
        for (String ele : permissions) {
            if (!SpaceUtils.hasViewPermission(ele, groupId)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasViewPermission(String expPerm, String groupId) throws Exception {
        if ("Everyone".equals(expPerm)) {
            return true;
        }
        String[] temp = expPerm.split(":");
        if (temp.length < 2) {
            return false;
        }
        String tempExp = temp[1].trim();
        return tempExp.equals(groupId) || tempExp.equals(PLATFORM_USERS_GROUP);
    }

    private static String getLocalizedStringValue(LocalizedString localizedString, String portletName) {
        if (localizedString == null || localizedString.getDefaultString() == null) {
            return portletName;
        }
        return localizedString.getDefaultString();
    }

    private static ApplicationRegistryService getApplicationRegistryService() {
        PortalContainer portalContainer = PortalContainer.getInstance();
        return (ApplicationRegistryService)portalContainer.getComponentInstanceOfType(ApplicationRegistryService.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PortletComparator
    implements Comparator<org.exoplatform.application.registry.Application> {
        PortletComparator() {
        }

        @Override
        public int compare(org.exoplatform.application.registry.Application p1, org.exoplatform.application.registry.Application p2) {
            return p1.getDisplayName().compareTo(p2.getDisplayName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PortletCategoryComparator
    implements Comparator<ApplicationCategory> {
        PortletCategoryComparator() {
        }

        @Override
        public int compare(ApplicationCategory cat1, ApplicationCategory cat2) {
            return cat1.getDisplayName().compareTo(cat2.getDisplayName());
        }
    }
}

