/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common.function;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;

public abstract class PDStreamFunction
extends PDFunction {
    private PDStream function = null;

    protected PDStreamFunction(PDDocument doc, int functionType) {
        this.function = new PDStream(doc);
        this.function.getStream().setInt("FunctionType", functionType);
    }

    public PDStreamFunction(PDStream functionDictionary) {
        this.function = functionDictionary;
    }

    public COSBase getCOSObject() {
        return this.function.getCOSObject();
    }

    public COSStream getCOSStream() {
        return this.function.getStream();
    }

    private COSArray getRangeArray(String fieldName, int n) {
        COSArray rangeArray = (COSArray)this.function.getStream().getDictionaryObject(COSName.getPDFName("Range"));
        if (rangeArray == null) {
            rangeArray = new COSArray();
            this.function.getStream().setItem(fieldName, (COSBase)rangeArray);
            while (rangeArray.size() < n * 2) {
                rangeArray.add(new COSFloat(0.0f));
                rangeArray.add(new COSFloat(0.0f));
            }
        }
        return rangeArray;
    }

    public int getNumberOfOutputParameters() {
        COSArray array = this.getRangeArray("Range", 0);
        return array.size() / 2;
    }

    public PDRange getRangeForOutput(int n) {
        COSArray rangeArray = this.getRangeArray("Range", n);
        return new PDRange(rangeArray, n);
    }

    public void setRangeForOutput(PDRange range, int n) {
        COSArray rangeArray = this.getRangeArray("Range", n);
        rangeArray.set(n * 2, new COSFloat(range.getMin()));
        rangeArray.set(n * 2 + 1, new COSFloat(range.getMax()));
    }

    public int getNumberOfInputParameters() {
        COSArray array = this.getRangeArray("Domain", 0);
        return array.size() / 2;
    }

    public PDRange getDomainForInput(int n) {
        COSArray rangeArray = this.getRangeArray("Domain", n);
        return new PDRange(rangeArray, n);
    }

    public void setDomainForInput(PDRange range, int n) {
        COSArray rangeArray = this.getRangeArray("Domain", n);
        rangeArray.set(n * 2, new COSFloat(range.getMin()));
        rangeArray.set(n * 2 + 1, new COSFloat(range.getMax()));
    }
}

