/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.serialization;

import java.io.IOException;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectReader;
import org.exoplatform.services.jcr.dataflow.serialization.UnknownClassIdException;
import org.exoplatform.services.jcr.impl.dataflow.serialization.PlainChangesLogReader;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ReaderSpoolFileHolder;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

public class TransactionChangesLogReader {
    private FileCleaner fileCleaner;
    private int maxBufferSize;
    private ReaderSpoolFileHolder holder;

    public TransactionChangesLogReader(FileCleaner fileCleaner, int maxBufferSize, ReaderSpoolFileHolder holder) {
        this.fileCleaner = fileCleaner;
        this.maxBufferSize = maxBufferSize;
        this.holder = holder;
    }

    public TransactionChangesLog read(ObjectReader in) throws UnknownClassIdException, IOException {
        int key = in.readInt();
        if (key != 5) {
            throw new UnknownClassIdException("There is unexpected class [" + key + "]");
        }
        TransactionChangesLog log = new TransactionChangesLog();
        if (in.readByte() == 1) {
            log.setSystemId(in.readString());
        }
        while (in.readByte() == 1) {
            PlainChangesLogReader rdr = new PlainChangesLogReader(this.fileCleaner, this.maxBufferSize, this.holder);
            PlainChangesLog pl = rdr.read(in);
            log.addLog(pl);
        }
        return log;
    }
}

