/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.cache.ehcache;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.cache.Cache;
import org.jsecurity.cache.CacheException;

public class EhCache
implements Cache {
    private static final Log log = LogFactory.getLog(EhCache.class);
    private Ehcache cache;

    public EhCache(net.sf.ehcache.Cache cache) {
        if (cache == null) {
            throw new IllegalArgumentException("Cache argument cannot be null.");
        }
        this.cache = cache;
    }

    public Object get(Object key) throws CacheException {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Getting object from cache [" + this.cache.getName() + "] for key [" + key + "]"));
            }
            if (key == null) {
                return null;
            }
            Element element = this.cache.get(key);
            if (element == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Element for [" + key + "] is null."));
                }
                return null;
            }
            return element.getObjectValue();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public void put(Object key, Object value) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Putting object in cache [" + this.cache.getName() + "] for key [" + key + "]"));
        }
        try {
            Element element = new Element(key, value);
            this.cache.put(element);
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public void remove(Object key) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Removing object from cache [" + this.cache.getName() + "] for key [" + key + "]"));
        }
        try {
            this.cache.remove(key);
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public void clear() throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Clearing all objects from cache [" + this.cache.getName() + "]"));
        }
        try {
            this.cache.removeAll();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public int size() {
        try {
            return this.cache.getSize();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public Set keys() {
        try {
            List keys = this.cache.getKeys();
            if (keys != null && !keys.isEmpty()) {
                return Collections.unmodifiableSet(new LinkedHashSet(keys));
            }
            return Collections.EMPTY_SET;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public Set values() {
        try {
            List keys = this.cache.getKeys();
            if (keys != null && !keys.isEmpty()) {
                LinkedHashSet<Element> values = new LinkedHashSet<Element>(keys.size());
                for (Object key : keys) {
                    values.add(this.cache.get(key));
                }
                return Collections.unmodifiableSet(values);
            }
            return Collections.EMPTY_SET;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public long getMemoryUsage() {
        try {
            return this.cache.calculateInMemorySize();
        }
        catch (Throwable t) {
            return -1L;
        }
    }

    public long getMemoryStoreSize() {
        try {
            return this.cache.getMemoryStoreSize();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public long getDiskStoreSize() {
        try {
            return this.cache.getDiskStoreSize();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public String toString() {
        return "EhCache [" + this.cache.getName() + "]";
    }
}

