/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.spring;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.util.Destroyable;
import org.jsecurity.util.Initializable;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;

public class LifecycleBeanPostProcessor
implements DestructionAwareBeanPostProcessor {
    private static final Log log = LogFactory.getLog(LifecycleBeanPostProcessor.class);

    public Object postProcessBeforeInitialization(Object object, String name) throws BeansException {
        if (object instanceof Initializable) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Initializing bean [" + name + "]..."));
                }
                ((Initializable)object).init();
            }
            catch (Exception e) {
                throw new FatalBeanException("Error initializing bean [" + name + "]", (Throwable)e);
            }
        }
        return object;
    }

    public Object postProcessAfterInitialization(Object object, String name) throws BeansException {
        return object;
    }

    public void postProcessBeforeDestruction(Object object, String name) throws BeansException {
        if (object instanceof Destroyable) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Destroying bean [" + name + "]..."));
                }
                ((Destroyable)object).destroy();
            }
            catch (Exception e) {
                throw new FatalBeanException("Error destroying bean [" + name + "]", (Throwable)e);
            }
        }
    }
}

