/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.spring.security.interceptor;

import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.authz.annotation.RequiresAuthentication;
import org.jsecurity.authz.annotation.RequiresGuest;
import org.jsecurity.authz.annotation.RequiresPermissions;
import org.jsecurity.authz.annotation.RequiresRoles;
import org.jsecurity.authz.annotation.RequiresUser;
import org.jsecurity.mgt.SecurityManager;
import org.jsecurity.spring.security.interceptor.AopAllianceAnnotationsAuthorizingMethodInterceptor;
import org.springframework.aop.support.StaticMethodMatcherPointcutAdvisor;
import org.springframework.beans.factory.InitializingBean;

public class AuthorizationAttributeSourceAdvisor
extends StaticMethodMatcherPointcutAdvisor
implements InitializingBean {
    private static final Log log = LogFactory.getLog(AuthorizationAttributeSourceAdvisor.class);
    protected SecurityManager securityManager = null;

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public boolean matches(Method method, Class targetClass) {
        return method.getAnnotation(RequiresPermissions.class) != null || method.getAnnotation(RequiresRoles.class) != null || method.getAnnotation(RequiresUser.class) != null || method.getAnnotation(RequiresGuest.class) != null || method.getAnnotation(RequiresAuthentication.class) != null;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getAdvice() == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("No authorization advice explicitly configured via the 'advice' property.  Attempting to set default instance of type [" + AopAllianceAnnotationsAuthorizingMethodInterceptor.class.getName() + "]"));
            }
            AopAllianceAnnotationsAuthorizingMethodInterceptor interceptor = new AopAllianceAnnotationsAuthorizingMethodInterceptor();
            this.setAdvice((Advice)interceptor);
        }
    }
}

