/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.link;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.plugin.link.UILinkActivity;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.BaseUIActivityBuilder;
import org.json.JSONException;
import org.json.JSONObject;

public class UILinkActivityBuilder
extends BaseUIActivityBuilder {
    private static final Log log = ExoLogger.getLogger(UILinkActivityBuilder.class);

    protected void extendUIActivity(BaseUIActivity uiActivity, Activity activity) {
        UILinkActivity uiLinkActivity = (UILinkActivity)uiActivity;
        Map templateParams = activity.getTemplateParams();
        if (templateParams != null) {
            uiLinkActivity.setLinkSource((String)templateParams.get("link"));
            uiLinkActivity.setLinkTitle((String)templateParams.get("title"));
            uiLinkActivity.setLinkImage((String)templateParams.get("image"));
            uiLinkActivity.setLinkDescription((String)templateParams.get("description"));
            uiLinkActivity.setLinkComment((String)templateParams.get("comment"));
        } else {
            try {
                JSONObject jsonObj = new JSONObject(activity.getTitle());
                uiLinkActivity.setLinkSource(jsonObj.getString("link"));
                uiLinkActivity.setLinkTitle(jsonObj.getString("title"));
                uiLinkActivity.setLinkImage(jsonObj.getString("image"));
                uiLinkActivity.setLinkDescription(jsonObj.getString("description"));
                uiLinkActivity.setLinkComment(jsonObj.getString("comment"));
                this.saveToNewDataFormat(activity, uiLinkActivity);
            }
            catch (JSONException e) {
                log.error((Object)"Error with link activity's title data");
            }
        }
    }

    private void saveToNewDataFormat(Activity activity, UILinkActivity uiLinkActivity) {
        String linkTitle = "Shared a link: <a href=\"${link}\">${title} </a>";
        activity.setTitle(linkTitle);
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put("link", uiLinkActivity.getLinkSource());
        templateParams.put("title", uiLinkActivity.getLinkTitle());
        templateParams.put("image", uiLinkActivity.getLinkImage());
        templateParams.put("description", uiLinkActivity.getLinkDescription());
        templateParams.put("comment", uiLinkActivity.getLinkComment());
        ActivityManager am = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
        am.saveActivity(activity);
    }
}

