/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.application;

import java.util.HashMap;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;

public class ProfileUpdatesPublisher
extends ProfileListenerPlugin {
    public static final String USER_NAME_PARAM = "USER_NAME_PARAM";
    private static final Log LOG = ExoLogger.getLogger(ProfileUpdatesPublisher.class);
    private ActivityManager activityManager;
    private IdentityManager identityManager;

    public ProfileUpdatesPublisher(InitParams params, ActivityManager activityManager, IdentityManager identityManager) {
        this.activityManager = activityManager;
        this.identityManager = identityManager;
    }

    public void avatarUpdated(ProfileLifeCycleEvent event) {
        String activityMessage = "@" + event.getUsername() + " has an updated profile picture.";
        this.publishActivity(event, activityMessage, "avatar_updated");
    }

    public void basicInfoUpdated(ProfileLifeCycleEvent event) {
        String activityMessage = "@" + event.getUsername() + " has an updated basic profile info.";
        this.publishActivity(event, activityMessage, "basic_info_updated");
    }

    public void contactSectionUpdated(ProfileLifeCycleEvent event) {
        String activityMessage = "@" + event.getUsername() + " has an updated contact info.";
        this.publishActivity(event, activityMessage, "contact_section_updated");
    }

    public void experienceSectionUpdated(ProfileLifeCycleEvent event) {
        String activityMessage = "@" + event.getUsername() + " has an updated experience section.";
        this.publishActivity(event, activityMessage, "experience_section_updated");
    }

    public void headerSectionUpdated(ProfileLifeCycleEvent event) {
        String activityMessage = "@" + event.getUsername() + " has an updated header info.";
        this.publishActivity(event, activityMessage, "header_section_updated");
    }

    private void publishActivity(ProfileLifeCycleEvent event, String activityMessage, String titleId) {
        Activity activity = new Activity();
        activity.setType("exosocial:people");
        activity.setTitleId(titleId);
        activity.setTitle(activityMessage);
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put(USER_NAME_PARAM, "@" + event.getUsername());
        activity.setTemplateParams(templateParams);
        this.publish(event, activity);
    }

    private void publish(ProfileLifeCycleEvent event, Activity activity) {
        Profile profile = event.getProfile();
        Identity identity = profile.getIdentity();
        try {
            this.reloadIfNeeded(identity);
            this.activityManager.saveActivity(identity, activity);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to publish event " + (Object)((Object)event) + ": " + e.getMessage()));
        }
    }

    private void reloadIfNeeded(Identity id1) throws Exception {
        if (id1.getId() == null || id1.getProfile().getFullName().length() == 0) {
            id1 = this.identityManager.getIdentity(id1.getGlobalId().toString(), true);
        }
    }
}

