/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.activity.model;

import java.util.Arrays;
import java.util.Date;
import org.apache.shindig.social.core.model.ActivityImpl;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ActivityStreamImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public class ExoSocialActivityImpl
extends ActivityImpl
implements ExoSocialActivity {
    private ActivityStream activityStream;
    private transient boolean isAComment = false;
    private String type;
    private String replyToId;
    private transient boolean isHiddenActivity;
    private String[] likeIdentityIds;
    private String name;
    private String summary;
    private transient String permaLink;

    public ExoSocialActivityImpl() {
        this.init();
    }

    public ExoSocialActivityImpl(String userId, String activityType, String activityTitle) {
        this.init();
        this.setUserId(userId);
        this.type = activityType;
        this.setTitle(activityTitle);
    }

    public ExoSocialActivityImpl(String userId, String activityType, String activityTitle, String activityBody) {
        this(userId, activityType, activityTitle);
        this.setBody(activityBody);
    }

    public final ActivityStream getActivityStream() {
        if (this.activityStream == null) {
            this.activityStream = new ActivityStreamImpl();
        }
        return this.activityStream;
    }

    public final void setActivityStream(ActivityStream providedAS) {
        this.activityStream = providedAS;
    }

    public final boolean isComment() {
        return this.isAComment;
    }

    public final void isComment(boolean isCommentOrNot) {
        this.isAComment = isCommentOrNot;
    }

    public final String getType() {
        return this.type;
    }

    public final void setType(String activityType) {
        this.type = activityType;
    }

    public final String getReplyToId() {
        return this.replyToId;
    }

    public final void setReplyToId(String replyToIdentityId) {
        this.replyToId = replyToIdentityId;
    }

    public final boolean isHidden() {
        return this.isHiddenActivity;
    }

    public final void isHidden(boolean isHiddenOrNot) {
        this.isHiddenActivity = isHiddenOrNot;
    }

    public final String[] getLikeIdentityIds() {
        if (this.likeIdentityIds != null) {
            return Arrays.copyOf(this.likeIdentityIds, this.likeIdentityIds.length);
        }
        return this.likeIdentityIds;
    }

    public final void setLikeIdentityIds(String[] identityIds) {
        this.likeIdentityIds = Arrays.copyOf(identityIds, identityIds.length);
    }

    public final String getStreamOwner() {
        return this.activityStream.getPrettyId();
    }

    public final void setStreamOwner(String activitySO) {
        this.activityStream.setPrettyId(activitySO);
    }

    public final String getStreamId() {
        return this.activityStream.getId();
    }

    public final void setStreamId(String sId) {
        this.activityStream.setId(sId);
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String activityName) {
        this.name = activityName;
    }

    public final String getSummary() {
        return this.summary;
    }

    public final void setSummary(String activitySummary) {
        this.summary = activitySummary;
    }

    public final String getPermaLink() {
        return this.permaLink;
    }

    public final void setPermanLink(String activityPermaLink) {
        this.permaLink = activityPermaLink;
    }

    public final String getStreamFaviconUrl() {
        return this.activityStream.getFaviconUrl();
    }

    public final String getStreamSourceUrl() {
        return this.activityStream.getPermaLink();
    }

    public final String getStreamTitle() {
        return this.activityStream.getTitle();
    }

    public final String getStreamUrl() {
        return this.activityStream.getPermaLink();
    }

    private void init() {
        Date date = new Date();
        this.setPostedTime(date.getTime());
        this.setUpdated(date);
        this.activityStream = new ActivityStreamImpl();
    }
}

