/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.RelationshipManagerImpl;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.RelationshipStorage;
import org.exoplatform.social.core.storage.RelationshipStorageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingRelationshipManager
extends RelationshipManagerImpl {
    private ExoCache<String, List<Relationship>> relationshipListCache;
    private ExoCache<String, Relationship> relationshipIdCache;

    public CachingRelationshipManager(RelationshipStorage relationshipStorage, CacheService cacheService) {
        super(relationshipStorage);
        this.relationshipListCache = cacheService.getCacheInstance(this.getClass().getName() + "relationshipListCache");
        this.relationshipIdCache = cacheService.getCacheInstance(this.getClass().getName() + "relationshipIdCache");
    }

    @Override
    public void remove(Relationship relationship) throws RelationshipStorageException {
        this.removeCachedRelationship(relationship);
        super.remove(relationship);
    }

    @Override
    public Relationship get(Identity identity1, Identity identity2) throws RelationshipStorageException {
        List cachedRelationshipsByIdentity2;
        List cachedRelationshipsByIdentity1 = (List)this.relationshipListCache.get((Serializable)((Object)identity1.getId()));
        if (cachedRelationshipsByIdentity1 != null) {
            for (Relationship relationship : cachedRelationshipsByIdentity1) {
                if (!relationship.getPartner(identity1).equals(identity2)) continue;
                return relationship;
            }
        }
        if ((cachedRelationshipsByIdentity2 = (List)this.relationshipListCache.get((Serializable)((Object)identity2.getId()))) != null) {
            for (Relationship relationship : cachedRelationshipsByIdentity2) {
                if (!relationship.getPartner(identity2).equals(identity1)) continue;
                return relationship;
            }
        }
        return super.get(identity1, identity2);
    }

    @Override
    public Relationship get(String relationshipId) {
        Relationship relationship = (Relationship)this.relationshipIdCache.get((Serializable)((Object)relationshipId));
        if (relationship != null) {
            return relationship;
        }
        relationship = super.get(relationshipId);
        if (relationship != null) {
            this.putRelationshipToCache(relationship);
        }
        return relationship;
    }

    @Override
    public void save(Relationship relationship) throws RelationshipStorageException {
        super.save(relationship);
        this.putRelationshipToCache(relationship);
    }

    @Override
    public List<Relationship> getAllRelationships(Identity identity) throws RelationshipStorageException {
        String identityId = identity.getId();
        List<Relationship> cachedRelationships = (List<Relationship>)this.relationshipListCache.get((Serializable)((Object)identityId));
        if (cachedRelationships == null) {
            cachedRelationships = super.getRelationships(identity, null, null);
            if (cachedRelationships == null || cachedRelationships.size() == 0) {
                return null;
            }
            this.relationshipListCache.put((Serializable)((Object)identityId), cachedRelationships);
        }
        return cachedRelationships;
    }

    private void putRelationshipToCache(Relationship relationship) throws RelationshipStorageException {
        String receiverId;
        List cachedRelationshipsReceiver;
        String relationshipId = relationship.getId();
        if (this.relationshipIdCache.get((Serializable)((Object)relationshipId)) != null) {
            this.relationshipIdCache.remove((Serializable)((Object)relationshipId));
        }
        this.relationshipIdCache.put((Serializable)((Object)relationshipId), (Object)relationship);
        String senderId = relationship.getSender().getId();
        List cachedRelationshipsSender = (List)this.relationshipListCache.get((Serializable)((Object)senderId));
        if (cachedRelationshipsSender != null) {
            if (cachedRelationshipsSender.contains(relationship)) {
                cachedRelationshipsSender.remove(relationship);
            }
            cachedRelationshipsSender.add(relationship);
            this.relationshipListCache.put((Serializable)((Object)relationship.getSender().getId()), (Object)cachedRelationshipsSender);
        }
        if ((cachedRelationshipsReceiver = (List)this.relationshipListCache.get((Serializable)((Object)(receiverId = relationship.getReceiver().getId())))) != null) {
            if (cachedRelationshipsReceiver.contains(relationship)) {
                cachedRelationshipsReceiver.remove(relationship);
            }
            cachedRelationshipsReceiver.add(relationship);
            this.relationshipListCache.put((Serializable)((Object)relationship.getReceiver().getId()), (Object)cachedRelationshipsReceiver);
        }
    }

    private void removeCachedRelationship(Relationship relationship) {
        String receiverId;
        List cachedRelationshipsReceiver;
        String senderId;
        List cachedRelationshipsSender;
        if (this.relationshipIdCache.get((Serializable)((Object)relationship.getId())) != null) {
            this.relationshipIdCache.remove((Serializable)((Object)relationship.getId()));
        }
        if ((cachedRelationshipsSender = (List)this.relationshipListCache.get((Serializable)((Object)(senderId = relationship.getSender().getId())))) != null && cachedRelationshipsSender.contains(relationship)) {
            cachedRelationshipsSender.remove(relationship);
            this.relationshipListCache.put((Serializable)((Object)senderId), (Object)cachedRelationshipsSender);
        }
        if ((cachedRelationshipsReceiver = (List)this.relationshipListCache.get((Serializable)((Object)(receiverId = relationship.getReceiver().getId())))) != null && cachedRelationshipsReceiver.contains(relationship)) {
            cachedRelationshipsReceiver.remove(relationship);
            this.relationshipListCache.put((Serializable)((Object)receiverId), (Object)cachedRelationshipsReceiver);
        }
    }

    @Override
    protected List<Relationship> getRelationships(Identity identity, Relationship.Type type, List<Identity> identities) throws RelationshipStorageException {
        List<Relationship> cachedRelationships = this.getAllRelationships(identity);
        if (cachedRelationships == null || cachedRelationships.size() == 0) {
            return null;
        }
        ArrayList<Relationship> filterCachedRelationships = new ArrayList<Relationship>();
        for (Relationship relationship : cachedRelationships) {
            if (type == null) {
                if (identities == null) {
                    filterCachedRelationships.add(relationship);
                    continue;
                }
                if (!identities.contains(relationship.getPartner(identity))) continue;
                filterCachedRelationships.add(relationship);
                continue;
            }
            if (!relationship.getStatus().equals((Object)type)) continue;
            if (identities == null) {
                filterCachedRelationships.add(relationship);
                continue;
            }
            if (!identities.contains(relationship.getPartner(identity))) continue;
            filterCachedRelationships.add(relationship);
        }
        return filterCachedRelationships;
    }

    @Override
    protected List<Relationship> getSender(Identity sender, Relationship.Type type, List<Identity> identities) throws RelationshipStorageException {
        List<Relationship> cachedRelationships = this.getAllRelationships(sender);
        if (cachedRelationships == null || cachedRelationships.size() == 0) {
            return null;
        }
        ArrayList<Relationship> filterCachedRelationships = new ArrayList<Relationship>();
        for (Relationship relationship : cachedRelationships) {
            if (!relationship.getSender().equals(sender)) continue;
            if (type == null) {
                if (identities == null) {
                    filterCachedRelationships.add(relationship);
                    continue;
                }
                if (!identities.contains(relationship.getReceiver())) continue;
                filterCachedRelationships.add(relationship);
                continue;
            }
            if (!relationship.getStatus().equals((Object)type)) continue;
            if (identities == null) {
                filterCachedRelationships.add(relationship);
                continue;
            }
            if (!identities.contains(relationship.getReceiver())) continue;
            filterCachedRelationships.add(relationship);
        }
        return filterCachedRelationships;
    }

    @Override
    protected List<Relationship> getReceiver(Identity receiver, Relationship.Type type, List<Identity> identities) throws RelationshipStorageException {
        List<Relationship> cachedRelationships = this.getAllRelationships(receiver);
        if (cachedRelationships == null || cachedRelationships.size() == 0) {
            return null;
        }
        ArrayList<Relationship> filterCachedRelationships = new ArrayList<Relationship>();
        for (Relationship relationship : cachedRelationships) {
            if (!relationship.getReceiver().equals(receiver)) continue;
            if (type == null) {
                if (identities == null) {
                    filterCachedRelationships.add(relationship);
                    continue;
                }
                if (!identities.contains(relationship.getReceiver())) continue;
                filterCachedRelationships.add(relationship);
                continue;
            }
            if (!relationship.getStatus().equals((Object)type)) continue;
            if (identities == null) {
                filterCachedRelationships.add(relationship);
                continue;
            }
            if (!identities.contains(relationship.getReceiver())) continue;
            filterCachedRelationships.add(relationship);
        }
        return filterCachedRelationships;
    }
}

