/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.IdentityProviderPlugin;
import org.exoplatform.social.core.identity.model.GlobalId;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.profile.ProfileLifeCycle;
import org.exoplatform.social.core.profile.ProfileListener;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.IdentityStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityManagerImpl
implements IdentityManager {
    private static final Log LOG = ExoLogger.getExoLogger(IdentityManagerImpl.class);
    protected Map<String, IdentityProvider<?>> identityProviders = new HashMap();
    protected IdentityStorage identityStorage;
    protected RelationshipManager relationshipManager;
    protected ProfileLifeCycle profileLifeCycle = new ProfileLifeCycle();

    public IdentityManagerImpl(IdentityStorage identityStorage, IdentityProvider<?> defaultIdentityProvider) {
        this.identityStorage = identityStorage;
        this.addIdentityProvider(defaultIdentityProvider);
    }

    @Override
    public void addIdentityProvider(IdentityProvider<?> idProvider) {
        if (idProvider != null) {
            LOG.debug((Object)("Registering identity provider for " + idProvider.getName() + ": " + idProvider));
            this.identityProviders.put(idProvider.getName(), idProvider);
        }
    }

    @Override
    public void deleteIdentity(Identity identity) {
        if (identity.getId() == null) {
            LOG.warn((Object)("identity.getId() must not be null of [" + identity + "]"));
            return;
        }
        this.getIdentityStorage().deleteIdentity(identity);
    }

    @Override
    public List<Identity> getConnections(Identity ownerIdentity) throws Exception {
        return this.getRelationshipManager().findRelationships(ownerIdentity, Relationship.Type.CONFIRMED);
    }

    @Override
    public List<Identity> getIdentities(String providerId) throws Exception {
        return this.getIdentities(providerId, true);
    }

    @Override
    public List<Identity> getIdentities(String providerId, boolean loadProfile) {
        IdentityProvider<?> ip = this.getIdentityProvider(providerId);
        List<String> userids = ip.getAllUserId();
        ArrayList<Identity> ids = new ArrayList<Identity>();
        for (String userId : userids) {
            ids.add(this.getOrCreateIdentity(providerId, userId, loadProfile));
        }
        return ids;
    }

    @Override
    public List<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFilter profileFilter) throws Exception {
        return this.identityStorage.getIdentitiesByProfileFilter(providerId, profileFilter, 0L, 500L);
    }

    @Override
    public List<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFilter profileFilter, long offset, long limit) throws Exception {
        return this.identityStorage.getIdentitiesByProfileFilter(providerId, profileFilter, offset, limit);
    }

    @Override
    public List<Identity> getIdentitiesByProfileFilter(ProfileFilter profileFilter) throws Exception {
        return this.getIdentitiesByProfileFilter(null, profileFilter, 0L, 500L);
    }

    @Override
    public List<Identity> getIdentitiesByProfileFilter(ProfileFilter profileFilter, long offset, long limit) throws Exception {
        return this.getIdentitiesByProfileFilter(null, profileFilter, offset, limit);
    }

    @Override
    public List<Identity> getIdentitiesFilterByAlphaBet(String providerId, ProfileFilter profileFilter) throws Exception {
        return this.identityStorage.getIdentitiesFilterByAlphaBet(providerId, profileFilter, 0L, 500L);
    }

    @Override
    public List<Identity> getIdentitiesFilterByAlphaBet(String providerId, ProfileFilter profileFilter, long offset, long limit) throws Exception {
        return this.identityStorage.getIdentitiesFilterByAlphaBet(providerId, profileFilter, offset, limit);
    }

    @Override
    public List<Identity> getIdentitiesFilterByAlphaBet(ProfileFilter profileFilter) throws Exception {
        return this.getIdentitiesFilterByAlphaBet(null, profileFilter);
    }

    @Override
    public Identity getIdentity(String id) {
        return this.getIdentity(id, true);
    }

    @Override
    public long getIdentitiesCount(String providerId) {
        return this.identityStorage.getIdentitiesCount(providerId);
    }

    @Override
    public Identity getIdentity(String id, boolean loadProfile) {
        Identity returnIdentity = null;
        if (GlobalId.isValid(id)) {
            String remoteId;
            GlobalId globalId = new GlobalId(id);
            String providerId = globalId.getDomain();
            returnIdentity = this.getOrCreateIdentity(providerId, remoteId = globalId.getLocalId(), loadProfile);
            if (returnIdentity != null) {
                return returnIdentity;
            }
            String tempId = globalId.getLocalId();
            returnIdentity = this.getIdentityStorage().findIdentityById(tempId);
            if (returnIdentity != null) {
                id = tempId;
            }
        } else {
            returnIdentity = this.getIdentityStorage().findIdentityById(id);
        }
        if (returnIdentity != null && loadProfile) {
            this.getIdentityStorage().loadProfile(returnIdentity.getProfile());
        }
        if (returnIdentity == null) {
            LOG.info((Object)("Can not get identity with id: " + id));
        }
        return returnIdentity;
    }

    @Override
    public Identity getIdentity(String providerId, String remoteId, boolean loadProfile) {
        Identity returnIdentity = null;
        IdentityProvider<?> identityProvider = this.getIdentityProvider(providerId);
        returnIdentity = identityProvider.getIdentityByRemoteId(remoteId);
        if (returnIdentity != null) {
            Identity storedIdentity = this.getIdentityStorage().findIdentity(providerId, remoteId);
            if (storedIdentity != null) {
                returnIdentity.setId(storedIdentity.getId());
                if (loadProfile) {
                    this.getIdentityStorage().loadProfile(returnIdentity.getProfile());
                }
            } else {
                this.getIdentityStorage().saveIdentity(returnIdentity);
            }
        }
        return returnIdentity;
    }

    @Override
    public Identity getOrCreateIdentity(String providerId, String remoteId) {
        return this.getOrCreateIdentity(providerId, remoteId, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Identity getOrCreateIdentity(String providerId, String remoteId, boolean loadProfile) {
        Identity returnIdentity = null;
        IdentityProvider<?> identityProvider = this.getIdentityProvider(providerId);
        Identity identity1 = identityProvider.getIdentityByRemoteId(remoteId);
        Identity result = this.getIdentityStorage().findIdentity(providerId, remoteId);
        if (result == null) {
            if (identity1 == null) return result;
            this.saveIdentity(identity1);
            this.getIdentityStorage().saveProfile(identity1.getProfile());
            result = identity1;
            return result;
        } else {
            if (identity1 == null) {
                this.getIdentityStorage().deleteIdentity(result);
                return null;
            }
            if (!loadProfile) return result;
            this.getIdentityStorage().loadProfile(result.getProfile());
        }
        return result;
    }

    @Override
    public boolean identityExisted(String providerId, String remoteId) {
        IdentityProvider<?> identityProvider = this.getIdentityProvider(providerId);
        return identityProvider.getIdentityByRemoteId(remoteId) != null;
    }

    @Override
    public void registerIdentityProviders(IdentityProviderPlugin plugin) {
        List<IdentityProvider<?>> pluginProviders = plugin.getProviders();
        if (pluginProviders != null) {
            for (IdentityProvider<?> identityProvider : pluginProviders) {
                this.addIdentityProvider(identityProvider);
            }
        }
    }

    @Override
    public void saveIdentity(Identity identity) {
        this.getIdentityStorage().saveIdentity(identity);
        this.getIdentityProvider(identity.getProviderId()).onSaveIdentity(identity);
    }

    @Override
    public void saveProfile(Profile profile) {
        this.getIdentityStorage().saveProfile(profile);
        this.getIdentityProvider(profile.getIdentity().getProviderId()).onSaveProfile(profile);
    }

    @Override
    public void updateAvatar(Profile p) {
        this.saveProfile(p);
        this.profileLifeCycle.avatarUpdated(p.getIdentity().getRemoteId(), p);
        LOG.debug((Object)("Update avatar successfully for user: " + p));
    }

    @Override
    public void updateBasicInfo(Profile p) throws Exception {
        this.addOrModifyProfileProperties(p);
        this.profileLifeCycle.basicUpdated(p.getIdentity().getRemoteId(), p);
        LOG.debug((Object)("Update basic infomation successfully for user: " + p));
    }

    @Override
    public void updateContactSection(Profile p) throws Exception {
        this.addOrModifyProfileProperties(p);
        this.profileLifeCycle.contactUpdated(p.getIdentity().getRemoteId(), p);
        LOG.debug((Object)("Update contact section successfully for user: " + p));
    }

    @Override
    public void updateExperienceSection(Profile p) throws Exception {
        this.addOrModifyProfileProperties(p);
        this.profileLifeCycle.experienceUpdated(p.getIdentity().getRemoteId(), p);
        LOG.debug((Object)("Update experience section successfully for user: " + p));
    }

    @Override
    public void updateHeaderSection(Profile p) throws Exception {
        this.addOrModifyProfileProperties(p);
        this.profileLifeCycle.headerUpdated(p.getIdentity().getRemoteId(), p);
        LOG.debug((Object)("Update header section successfully for user: " + p));
    }

    public IdentityProvider<?> getIdentityProvider(String providerId) {
        IdentityProvider<?> provider = this.identityProviders.get(providerId);
        if (provider == null) {
            throw new RuntimeException("No suitable identity provider exists for " + providerId);
        }
        return provider;
    }

    @Override
    public IdentityStorage getIdentityStorage() {
        return this.identityStorage;
    }

    public void setIdentityStorage(IdentityStorage identityStorage) {
        this.identityStorage = identityStorage;
    }

    public RelationshipManager getRelationshipManager() {
        if (this.relationshipManager == null) {
            this.relationshipManager = (RelationshipManager)PortalContainer.getInstance().getComponentInstanceOfType(RelationshipManager.class);
        }
        return this.relationshipManager;
    }

    @Override
    public void addProfileListener(ProfileListenerPlugin plugin) {
        this.registerProfileListener(plugin);
    }

    @Override
    public void registerProfileListener(ProfileListener listener) {
        this.profileLifeCycle.addListener(listener);
    }

    @Override
    public void unregisterProfileListener(ProfileListener listener) {
        this.profileLifeCycle.removeListener(listener);
    }

    @Override
    public void addOrModifyProfileProperties(Profile profile) throws Exception {
        this.getIdentityStorage().addOrModifyProfileProperties(profile);
        this.getIdentityProvider(profile.getIdentity().getProviderId()).onSaveProfile(profile);
    }

    @Override
    public IdentityStorage getStorage() {
        return this.identityStorage;
    }
}

