/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.jcr.JCRSessionManager;
import org.exoplatform.social.common.jcr.QueryBuilder;
import org.exoplatform.social.common.jcr.SocialDataLocation;
import org.exoplatform.social.common.jcr.Util;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.storage.ActivityStorageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityStorage {
    private static final Log LOG = ExoLogger.getLogger(ActivityStorage.class);
    private static final String PUBLISHED_NODE = "published";
    private static final String COMMENT_IDS_DELIMITER = ",";
    private SocialDataLocation dataLocation;
    private JCRSessionManager sessionManager;
    private Node activityServiceHome;
    private IdentityManager identityManager;
    private static final String ACTIVITY_PROPERTIES_NAME_PATTERN = Util.getPropertiesNamePattern((String[])new String[]{"exo:body", "exo:externalId", "exo:hidden", "exo:postedTime", "exo:priority", "exo:title", "exo:type", "exo:replyToId", "exo:updatedTimestamp", "exo:url", "exo:userId", "exo:likeIdentityIds", "exo:params", "exo:titleTemplate", "exo:bodyTemplate"});

    public ActivityStorage(SocialDataLocation dataLocation, IdentityManager identityManager) {
        this.dataLocation = dataLocation;
        this.identityManager = identityManager;
        this.sessionManager = dataLocation.getSessionManager();
    }

    public ExoSocialActivity saveActivity(Identity owner, ExoSocialActivity activity) throws ActivityStorageException {
        try {
            Validate.notNull((Object)owner, (String)"owner must not be null.");
            Validate.notNull((Object)activity, (String)"activity must not be null.");
            Validate.notNull((Object)activity.getUpdated(), (String)"Activity.getUpdated() must not be null.");
            Validate.notNull((Object)activity.getPostedTime(), (String)"Activity.getPostedTime() must not be null.");
            Validate.notNull((Object)activity.getTitle(), (String)"Activity.getTitle() must not be null.");
        }
        catch (IllegalArgumentException e) {
            throw new ActivityStorageException(ActivityStorageException.Type.ILLEGAL_ARGUMENTS, e.getMessage(), e);
        }
        if (activity.getUserId() == null) {
            activity.setUserId(owner.getId());
        }
        try {
            Node activityNode;
            Node activityHomeNode = this.getPublishedActivityServiceHome(owner);
            Session session = this.sessionManager.getOrOpenSession();
            if (activity.getId() == null) {
                activityNode = activityHomeNode.addNode("exo:activity", "exo:activity");
                activityNode.addMixin("mix:referenceable");
            } else {
                activityNode = session.getNodeByUUID(activity.getId());
            }
            this.setStreamInfo(activity, activityNode);
            this.setActivityNodeFromActivity(activityNode, activity);
            if (activity.getId() == null) {
                activityHomeNode.save();
                activity.setId(activityNode.getUUID());
            } else {
                activityNode.save();
            }
        }
        catch (Exception e) {
            throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_SAVE_ACTIVITY, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession(true);
        }
        return activity;
    }

    public void deleteActivity(String activityId) throws ActivityStorageException {
        block6: {
            try {
                this.deleteActivityComments(activityId);
                Session session = this.sessionManager.getOrOpenSession();
                Node activityNode = session.getNodeByUUID(activityId);
                if (activityNode != null) {
                    activityNode.remove();
                    break block6;
                }
                throw new Exception("Failed to delete activityId: " + activityId + ": not found");
            }
            catch (Exception e) {
                throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_DELETE_ACTIVITY, e.getMessage(), e);
            }
            finally {
                this.sessionManager.closeSession(true);
            }
        }
    }

    public void deleteActivity(ExoSocialActivity storedActivity) throws ActivityStorageException {
        if (storedActivity.getId() == null) {
            throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_DELETE_ACTIVITY, "Failed to delete this activity. It is not stored in JCR yet.");
        }
        this.deleteActivity(storedActivity.getId());
    }

    public void saveComment(ExoSocialActivity activity, ExoSocialActivity comment) throws ActivityStorageException {
        try {
            Validate.notNull((Object)activity, (String)"activity must not be null.");
            Validate.notNull((Object)comment.getUserId(), (String)"comment.getUserId() must not be null.");
            Validate.notNull((Object)comment.getTitle(), (String)"comment.getTitle() must not be null.");
        }
        catch (IllegalArgumentException e) {
            throw new ActivityStorageException(ActivityStorageException.Type.ILLEGAL_ARGUMENTS, e.getMessage(), e);
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (comment.getId() != null) {
            comment.setUpdated(new Date(currentTimeMillis));
        } else {
            comment.setPostedTime(currentTimeMillis);
            comment.setUpdated(new Date(currentTimeMillis));
        }
        comment.setReplyToId("IS_COMMENT");
        Identity ownerStream = this.identityManager.getIdentity(activity.getUserId());
        try {
            comment = this.saveActivity(ownerStream, comment);
            String rawCommentIds = activity.getReplyToId();
            if (rawCommentIds == null) {
                rawCommentIds = "";
            }
            rawCommentIds = rawCommentIds + COMMENT_IDS_DELIMITER + comment.getId();
            activity.setReplyToId(rawCommentIds);
            this.saveActivity(ownerStream, activity);
        }
        catch (ActivityStorageException e) {
            throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_SAVE_COMMENT, e.getMessage(), (Throwable)((Object)e));
        }
    }

    public void deleteComment(String activityId, String commentId) throws ActivityStorageException {
        block6: {
            ExoSocialActivity activity = null;
            try {
                activity = this.getActivity(activityId);
                String rawCommentIds = activity.getReplyToId();
                if (rawCommentIds != null && rawCommentIds.contains(commentId)) {
                    ExoSocialActivity comment = this.getActivity(commentId);
                    if (comment == null) {
                        throw new Exception("Failed to find comment with id: " + commentId);
                    }
                    try {
                        this.deleteActivity(commentId);
                        commentId = COMMENT_IDS_DELIMITER + commentId;
                        rawCommentIds = rawCommentIds.replace(commentId, "");
                        activity.setReplyToId(rawCommentIds);
                        Identity user = this.identityManager.getIdentity(activity.getUserId());
                        this.saveActivity(user, activity);
                        break block6;
                    }
                    catch (Exception e) {
                        throw new Exception("Failed to delete comment with id: " + commentId, e);
                    }
                }
                throw new Exception("Failed to find commentId: " + commentId + " in activity with activityId: " + activityId);
            }
            catch (Exception e) {
                throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_DELETE_COMMENT, e.getMessage(), e);
            }
        }
    }

    public ExoSocialActivity getActivity(String activityId) throws ActivityStorageException {
        Session session = this.sessionManager.getOrOpenSession();
        try {
            Node activityNode = session.getNodeByUUID(activityId);
            if (activityNode != null) {
                ExoSocialActivity exoSocialActivity = this.getActivityFromActivityNode(activityNode);
                return exoSocialActivity;
            }
        }
        catch (Exception e) {
            throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_GET_ACTIVITY, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return null;
    }

    public List<ExoSocialActivity> getActivitiesOfConnections(List<Identity> connectionList, int offset, int limit) throws ActivityStorageException {
        ArrayList<ExoSocialActivity> activities = new ArrayList<ExoSocialActivity>();
        if (connectionList == null || connectionList.isEmpty()) {
            return activities;
        }
        try {
            Session session = this.sessionManager.getOrOpenSession();
            QueryBuilder queryBuilder = new QueryBuilder(session).select("exo:activity", (long)offset, (long)limit).not().equal("exo:replyToId", "IS_COMMENT").and().group();
            int length = connectionList.size();
            for (int i = 0; i < length; ++i) {
                Identity id = connectionList.get(i);
                if (i != 0) {
                    queryBuilder.or();
                }
                queryBuilder.equal("exo:userId", id.getId());
            }
            queryBuilder.endGroup().orderBy("exo:postedTime", "DESC");
            List nodes = queryBuilder.exec();
            for (Node node : nodes) {
                activities.add(this.getActivityFromActivityNode(node));
            }
        }
        catch (Exception e) {
            throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_GET_ACTIVITIES_OF_CONNECTIONS, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return activities;
    }

    public List<ExoSocialActivity> getActivities(Identity owner, long offset, long limit) throws ActivityStorageException {
        ArrayList<ExoSocialActivity> activities = new ArrayList<ExoSocialActivity>();
        try {
            Node n = this.getPublishedActivityServiceHome(owner);
            String path = n.getPath();
            Session session = this.sessionManager.getOrOpenSession();
            List nodes = new QueryBuilder(session).select("exo:activity", offset, limit).like("jcr:path", path + "[%]/" + "exo:activity" + "[%]").and().not().equal("exo:replyToId", "IS_COMMENT").orderBy("exo:updatedTimestamp", "DESC").exec();
            for (Node node : nodes) {
                activities.add(this.getActivityFromActivityNode(node));
            }
        }
        catch (Exception e) {
            throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_GET_ACTIVITIES, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return activities;
    }

    public List<ExoSocialActivity> getActivities(Identity owner) throws ActivityStorageException {
        ArrayList<ExoSocialActivity> activities = new ArrayList<ExoSocialActivity>();
        try {
            Node publishingNode = this.getPublishedActivityServiceHome(owner);
            Session session = this.sessionManager.getOrOpenSession();
            String path = publishingNode.getPath();
            List nodes = new QueryBuilder(session).select("exo:activity").like("jcr:path", path + "[%]/" + "exo:activity" + "[%]").and().not().equal("exo:replyToId", "IS_COMMENT").exec();
            for (Node node : nodes) {
                activities.add(this.getActivityFromActivityNode(node));
            }
        }
        catch (Exception e) {
            throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_GET_ACTIVITIES, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return activities;
    }

    public int getActivitiesCount(Identity owner) throws ActivityStorageException {
        int count = 0;
        try {
            Node publishingNode = this.getPublishedActivityServiceHome(owner);
            Session session = this.sessionManager.getOrOpenSession();
            String path = publishingNode.getPath();
            count = (int)new QueryBuilder(session).select("exo:activity").like("jcr:path", path + "[%]/" + "exo:activity" + "[%]").and().not().equal("exo:replyToId", "IS_COMMENT").count();
        }
        catch (Exception e) {
            throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_GET_ACTIVITIES_COUNT, e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return count;
    }

    private Node getActivityServiceHome(Session session) throws Exception {
        if (this.activityServiceHome == null) {
            String path = this.dataLocation.getSocialActivitiesHome();
            this.activityServiceHome = session.getRootNode().getNode(path);
        }
        return this.activityServiceHome;
    }

    private Node getStreamLocation(Identity owner) throws Exception {
        String type = owner.getProviderId();
        String id = owner.getRemoteId();
        if (type != null && id != null) {
            return this.getStreamsLocationByType(type, id);
        }
        LOG.warn((Object)("attempting to get a stream for non prefixed owner : " + id));
        return this.getStreamsLocationByType("default", id);
    }

    private Node getStreamsLocationByType(String type, String username) throws Exception {
        Session session = this.sessionManager.getOrOpenSession();
        try {
            Node typeHome;
            Node activityHomeNode = this.getActivityServiceHome(session);
            if (activityHomeNode.hasNode(type)) {
                typeHome = activityHomeNode.getNode(type);
            } else {
                typeHome = activityHomeNode.addNode(type, "nt:unstructured");
                activityHomeNode.save();
            }
            if (typeHome.hasNode(username)) {
                Node node = typeHome.getNode(username);
                return node;
            }
            Node streamNode = typeHome.addNode(username, "nt:unstructured");
            typeHome.save();
            Node node = streamNode;
            return node;
        }
        catch (Exception e) {
            throw new Exception("Failed to locate stream owner node for " + username + "; " + e.getMessage(), e);
        }
        finally {
            this.sessionManager.closeSession(true);
        }
    }

    private Node getPublishedActivityServiceHome(Identity owner) throws Exception {
        Node userActivityHomeNode = this.getStreamLocation(owner);
        try {
            return userActivityHomeNode.getNode(PUBLISHED_NODE);
        }
        catch (PathNotFoundException ex) {
            Node appNode = userActivityHomeNode.addNode(PUBLISHED_NODE, "nt:unstructured");
            appNode.addMixin("mix:referenceable");
            userActivityHomeNode.save();
            return appNode;
        }
    }

    private void deleteActivityComments(String activityId) throws Exception {
        ExoSocialActivity activity = this.getActivity(activityId);
        String rawCommentIds = activity.getReplyToId();
        if (rawCommentIds != null) {
            if (rawCommentIds.equals("IS_COMMENT")) {
                return;
            }
            Object[] commentIds = rawCommentIds.split(COMMENT_IDS_DELIMITER);
            for (Object commentId : commentIds = (String[])ArrayUtils.removeElement((Object[])commentIds, (Object)"")) {
                this.deleteActivity((String)commentId);
            }
        }
    }

    private void setStreamInfo(ExoSocialActivity activity, Node activityNode) throws Exception {
        ActivityStream activityStream = activity.getActivityStream();
        try {
            String providerName = activityNode.getParent().getParent().getParent().getName();
            String streamNodeId = activityNode.getParent().getUUID();
            String streamName = activityNode.getParent().getParent().getName();
            activityStream.setId(streamNodeId);
            activityStream.setPrettyId(streamName);
            activityStream.setType(providerName);
            activityStream.setTitle("Activity Stream of " + streamName);
            activityStream.setPermaLink(LinkProvider.getActivityUri(providerName, streamName));
        }
        catch (UnsupportedRepositoryOperationException e) {
            activityNode.getParent().addMixin("mix:referenceable");
            activityStream.setId(activityNode.getParent().getUUID());
        }
    }

    private void setActivityNodeFromActivity(Node activityNode, ExoSocialActivity activity) throws RepositoryException {
        activityNode.setProperty("exo:title", activity.getTitle());
        activityNode.setProperty("exo:userId", activity.getUserId());
        activityNode.setProperty("exo:updatedTimestamp", activity.getUpdated().getTime());
        activityNode.setProperty("exo:postedTime", activity.getPostedTime().longValue());
        if (activity.getLikeIdentityIds() != null) {
            activityNode.setProperty("exo:likeIdentityIds", activity.getLikeIdentityIds());
        }
        if (activity.isHidden()) {
            activityNode.setProperty("exo:hidden", activity.isHidden());
        }
        activityNode.setProperty("exo:bodyTemplate", activity.getBodyId());
        activityNode.setProperty("exo:params", Util.convertMapToStrings((Map)activity.getTemplateParams()));
        if (activity.getTitleId() != null) {
            activityNode.setProperty("exo:titleTemplate", activity.getTitleId());
        }
        if (activity.getBody() != null) {
            activityNode.setProperty("exo:body", activity.getBody());
        }
        if (activity.getExternalId() != null) {
            activityNode.setProperty("exo:externalId", activity.getExternalId());
        }
        if (activity.getPriority() != null) {
            activityNode.setProperty("exo:priority", (double)activity.getPriority().floatValue());
        }
        if (activity.getType() != null) {
            activityNode.setProperty("exo:type", activity.getType());
        }
        if (activity.getReplyToId() != null) {
            activityNode.setProperty("exo:replyToId", activity.getReplyToId());
        }
        if (activity.getUrl() != null) {
            activityNode.setProperty("exo:url", activity.getUrl());
        }
    }

    private ExoSocialActivity getActivityFromActivityNode(Node activityNode) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        try {
            activity.setId(activityNode.getUUID());
            this.setStreamInfo(activity, activityNode);
            PropertyIterator it = activityNode.getProperties(ACTIVITY_PROPERTIES_NAME_PATTERN);
            while (it.hasNext()) {
                Property p = it.nextProperty();
                String propertyName = p.getName();
                if ("exo:body".equals(propertyName)) {
                    activity.setBody(p.getString());
                    continue;
                }
                if ("exo:externalId".equals(propertyName)) {
                    activity.setExternalId(p.getString());
                    continue;
                }
                if ("exo:hidden".equals(propertyName)) {
                    activity.isHidden(p.getBoolean());
                    continue;
                }
                if ("exo:postedTime".equals(propertyName)) {
                    activity.setPostedTime(p.getLong());
                    continue;
                }
                if ("exo:priority".equals(propertyName)) {
                    activity.setPriority(Float.valueOf(p.getLong()));
                    continue;
                }
                if ("exo:title".equals(propertyName)) {
                    activity.setTitle(p.getString());
                    continue;
                }
                if ("exo:type".equals(propertyName)) {
                    activity.setType(p.getString());
                    continue;
                }
                if ("exo:replyToId".equals(propertyName)) {
                    activity.setReplyToId(p.getString());
                    continue;
                }
                if ("exo:updatedTimestamp".equals(propertyName)) {
                    activity.setUpdated(new Date(p.getLong()));
                    continue;
                }
                if ("exo:url".equals(propertyName)) {
                    activity.setUrl(p.getString());
                    continue;
                }
                if ("exo:userId".equals(propertyName)) {
                    activity.setUserId(p.getString());
                    continue;
                }
                if ("exo:likeIdentityIds".equals(propertyName)) {
                    activity.setLikeIdentityIds(Util.convertValuesToStrings((Value[])p.getValues()));
                    continue;
                }
                if ("exo:params".equals(propertyName)) {
                    activity.setTemplateParams(Util.convertValuesToMap((Value[])p.getValues()));
                    continue;
                }
                if ("exo:titleTemplate".equals(propertyName)) {
                    activity.setTitleId(p.getString());
                    continue;
                }
                if (!"exo:bodyTemplate".equals(propertyName)) continue;
                activity.setBodyId(p.getString());
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        return activity;
    }
}

