/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.jcr.JCRSessionManager;
import org.exoplatform.social.common.jcr.QueryBuilder;
import org.exoplatform.social.common.jcr.SocialDataLocation;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.RelationshipStorageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipStorage {
    private static final Log LOG = ExoLogger.getLogger(RelationshipStorage.class);
    private IdentityManager identityManager;
    private SocialDataLocation dataLocation;
    private JCRSessionManager sessionManager;
    private Node relationshipServiceHome;

    public RelationshipStorage(SocialDataLocation dataLocation) {
        this.dataLocation = dataLocation;
        this.sessionManager = dataLocation.getSessionManager();
    }

    public Relationship saveRelationship(Relationship relationship) throws RelationshipStorageException {
        if (relationship == null) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.ILLEGAL_ARGUMENTS, new String[]{Relationship.class.getSimpleName()});
        }
        Session session = this.sessionManager.getOrOpenSession();
        Node relationshipNode = null;
        try {
            Node relationshipHomeNode = this.getRelationshipServiceHome(session);
            if (relationship.getId() == null) {
                relationshipNode = relationshipHomeNode.addNode("exo:relationship", "exo:relationship");
                relationshipNode.addMixin("mix:referenceable");
            } else {
                relationshipNode = session.getNodeByUUID(relationship.getId());
            }
            relationshipNode.setProperty("exo:sender", session.getNodeByUUID(relationship.getSender().getId()));
            relationshipNode.setProperty("exo:receiver", session.getNodeByUUID(relationship.getReceiver().getId()));
            relationshipNode.setProperty("exo:status", relationship.getStatus().toString());
            relationshipNode.setProperty("exo:isSymetric", relationship.isSymetric());
            if (relationship.getId() == null) {
                relationshipHomeNode.save();
                relationship.setId(relationshipNode.getUUID());
                LOG.debug((Object)("relationship " + relationship + " stored"));
            } else {
                relationshipNode.save();
                LOG.debug((Object)("relationship " + relationship + " updated"));
            }
        }
        catch (Exception e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_SAVE_RELATIONSHIP, e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return relationship;
    }

    public void removeRelationship(Relationship relationship) throws RelationshipStorageException {
        Session session = this.sessionManager.openSession();
        try {
            Node relationshipNode = session.getNodeByUUID(relationship.getId());
            relationshipNode.remove();
            session.save();
        }
        catch (ItemNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_DELETE_RELATIONSHIP_ITEM_NOT_FOUND, e);
        }
        catch (RepositoryException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_DELETE_RELATIONSHIP, e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    public Relationship getRelationship(String uuid) throws RelationshipStorageException {
        Session session = this.sessionManager.getOrOpenSession();
        Relationship relationship = null;
        try {
            Node relationshipNode = session.getNodeByUUID(uuid);
            relationship = this.loadRelationship(relationshipNode);
        }
        catch (Exception e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return relationship;
    }

    private Relationship loadRelationship(Node relationshipNode) throws RepositoryException, RelationshipStorageException {
        Relationship relationship = new Relationship(relationshipNode.getUUID());
        Node idNode = relationshipNode.getProperty("exo:sender").getNode();
        relationship.setSender(this.getIdentityManager().getIdentity(idNode.getUUID()));
        idNode = relationshipNode.getProperty("exo:receiver").getNode();
        relationship.setReceiver(this.getIdentityManager().getIdentity(idNode.getUUID()));
        relationship.setStatus(Relationship.Type.valueOf(relationshipNode.getProperty("exo:status").getString()));
        relationship.setSymetric(relationshipNode.getProperty("exo:isSymetric").getBoolean());
        return relationship;
    }

    public Relationship getRelationship(Identity identity1, Identity identity2) throws RelationshipStorageException {
        if (identity1 == null || identity1.getId() == null || identity2 == null || identity2.getId() == null) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.ILLEGAL_ARGUMENTS, identity1.toString(), identity2.toString());
        }
        return this.getRelationship(identity1.getId(), identity2.getId());
    }

    public Relationship getRelationship(String identityId1, String identityId2) throws RelationshipStorageException {
        if (identityId1 == null || "".equals(identityId1) || identityId2 == null || "".equals(identityId2)) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.ILLEGAL_ARGUMENTS, identityId1, identityId2);
        }
        Session session = this.sessionManager.getOrOpenSession();
        List nodes = null;
        try {
            QueryBuilder query = this.selectRelationship(session);
            query.and().group().group().equal("exo:sender", identityId1).and().equal("exo:receiver", identityId2).endGroup().or().group().equal("exo:sender", identityId2).and().equal("exo:receiver", identityId1).endGroup().endGroup();
            nodes = query.exec();
            if (nodes == null || nodes.size() < 1) {
                Relationship relationship = null;
                return relationship;
            }
            if (nodes.size() > 1) {
                throw new RelationshipStorageException(RelationshipStorageException.Type.MORE_THAN_ONE_RELATIONSHIP, identityId1, identityId2);
            }
            Relationship relationship = this.loadRelationship((Node)nodes.get(0));
            return relationship;
        }
        catch (RepositoryException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP_OF_THEM, null, e, identityId1, identityId2);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    public List<Relationship> getRelationships(Identity identity, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        if (identity == null || identity.getId() == null) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.ILLEGAL_ARGUMENTS);
        }
        if (listCheckIdentity == null) {
            return this.getRelationships(identity.getId(), type, null);
        }
        ArrayList<String> identityIds = new ArrayList<String>();
        for (Identity checkingIdentity : listCheckIdentity) {
            identityIds.add(checkingIdentity.getId());
        }
        return this.getRelationships(identity.getId(), type, identityIds);
    }

    public List<Relationship> getRelationships(String identityId, Relationship.Type type, List<String> listCheckIdentityId) throws RelationshipStorageException {
        Session session = this.sessionManager.getOrOpenSession();
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        List nodes = null;
        try {
            QueryBuilder query = this.selectRelationship(session);
            query.and().group().equal("exo:sender", identityId).or().equal("exo:receiver", identityId).endGroup();
            if (type != null) {
                query.and().equal("exo:status", type.toString());
            }
            if (listCheckIdentityId != null && listCheckIdentityId.size() > 0) {
                query.and().group();
                String firstCheckIdentityId = listCheckIdentityId.get(0);
                query.equal("exo:sender", firstCheckIdentityId).or().equal("exo:receiver", firstCheckIdentityId);
                listCheckIdentityId.remove(0);
                for (String checkIdentityId : listCheckIdentityId) {
                    query.or().equal("exo:sender", checkIdentityId).or().equal("exo:receiver", checkIdentityId);
                }
                query.endGroup();
            }
            nodes = query.exec();
            for (Node node : nodes) {
                Relationship relationship = this.loadRelationship(node);
                results.add(relationship);
            }
        }
        catch (RepositoryException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, null, e, identityId, type.toString());
        }
        finally {
            this.sessionManager.closeSession();
        }
        return results;
    }

    public List<Relationship> getSenderRelationships(Identity sender, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        if (sender == null || sender.getId() == null) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.ILLEGAL_ARGUMENTS);
        }
        if (listCheckIdentity == null) {
            return this.getSenderRelationships(sender.getId(), type, null);
        }
        ArrayList<String> identityIds = new ArrayList<String>();
        for (Identity checkingIdentity : listCheckIdentity) {
            identityIds.add(checkingIdentity.getId());
        }
        return this.getSenderRelationships(sender.getId(), type, identityIds);
    }

    public List<Relationship> getSenderRelationships(String senderId, Relationship.Type type, List<String> listCheckIdentityId) throws RelationshipStorageException {
        Session session = this.sessionManager.getOrOpenSession();
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        List nodes = null;
        try {
            QueryBuilder query = this.selectRelationship(session);
            query.and().equal("exo:sender", senderId);
            if (type != null) {
                query.and().equal("exo:status", type.toString());
            }
            if (listCheckIdentityId != null && listCheckIdentityId.size() > 0) {
                query.and().group();
                String firstCheckIdentityId = listCheckIdentityId.get(0);
                query.equal("exo:receiver", firstCheckIdentityId);
                listCheckIdentityId.remove(0);
                for (String checkIdentityId : listCheckIdentityId) {
                    query.or().equal("exo:receiver", checkIdentityId);
                }
                query.endGroup();
            }
            nodes = query.exec();
            for (Node node : nodes) {
                Relationship relationship = this.loadRelationship(node);
                results.add(relationship);
            }
        }
        catch (RepositoryException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, null, e, senderId, type.toString());
        }
        finally {
            this.sessionManager.closeSession();
        }
        return results;
    }

    public List<Relationship> getReceiverRelationships(Identity receiver, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        ArrayList<String> identityIds = new ArrayList<String>();
        for (Identity checkingIdentity : listCheckIdentity) {
            identityIds.add(checkingIdentity.getId());
        }
        return this.getReceiverRelationships(receiver.getId(), type, identityIds);
    }

    public List<Relationship> getReceiverRelationships(String receiverId, Relationship.Type type, List<String> listCheckIdentityId) throws RelationshipStorageException {
        Session session = this.sessionManager.getOrOpenSession();
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        List nodes = null;
        try {
            QueryBuilder query = this.selectRelationship(session);
            query.and().equal("exo:receiver", receiverId);
            if (type != null) {
                query.and().equal("exo:status", type.toString());
            }
            if (listCheckIdentityId != null && listCheckIdentityId.size() > 0) {
                query.and().group();
                String firstCheckIdentityId = listCheckIdentityId.get(0);
                query.equal("exo:sender", firstCheckIdentityId);
                listCheckIdentityId.remove(0);
                for (String checkIdentityId : listCheckIdentityId) {
                    query.or().equal("exo:sender", checkIdentityId);
                }
                query.endGroup();
            }
            nodes = query.exec();
            for (Node node : nodes) {
                Relationship relationship = this.loadRelationship(node);
                results.add(relationship);
            }
        }
        catch (RepositoryException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, null, e, receiverId, type.toString());
        }
        finally {
            this.sessionManager.closeSession();
        }
        return results;
    }

    private QueryBuilder selectRelationship(Session session) {
        QueryBuilder query = new QueryBuilder(session);
        query.select("exo:relationship").like("jcr:path", "/" + this.dataLocation.getSocialRelationshipHome() + "/%");
        return query;
    }

    private Node getRelationshipServiceHome(Session session) {
        if (this.relationshipServiceHome == null) {
            try {
                this.relationshipServiceHome = session.getRootNode().getNode(this.dataLocation.getSocialRelationshipHome());
            }
            catch (PathNotFoundException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
            catch (RepositoryException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.relationshipServiceHome;
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager;
    }
}

