/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.jcr.JCRSessionManager;
import org.exoplatform.social.common.jcr.QueryBuilder;
import org.exoplatform.social.common.jcr.SocialDataLocation;
import org.exoplatform.social.common.jcr.Util;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceStorage {
    private static final Log LOG = ExoLogger.getLogger(SpaceStorage.class);
    private static final String SPACE_PROPERTIES_NAME_PATTERN = Util.getPropertiesNamePattern((String[])new String[]{"exo:app", "exo:avatarUrl", "exo:description", "exo:name", "exo:groupId", "exo:invitedUsers", "exo:parent", "exo:pendingUsers", "exo:prettyName", "exo:priority", "exo:registration", "exo:tag", "exo:type", "exo:url", "exo:visibility"});
    private SocialDataLocation dataLocation;
    private JCRSessionManager sessionManager;
    private static final String IMAGE_PATH = "image";
    private Node spaceHomeNode;
    private final ExoCache<String, Space> spaceCache;

    public SpaceStorage(SocialDataLocation dataLocation, CacheService cacheService) {
        this.dataLocation = dataLocation;
        this.sessionManager = dataLocation.getSessionManager();
        this.spaceCache = cacheService.getCacheInstance(this.getClass().getName() + "spaceCache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Space> getAllSpaces() {
        ArrayList<Space> spaces = new ArrayList<Space>();
        try {
            Session session = this.sessionManager.getOrOpenSession();
            List spacesNode = new QueryBuilder(session).select("exo:space").exec();
            for (Node node : spacesNode) {
                Space space = this.getSpaceFromNode(node, session);
                spaces.add(space);
            }
            ArrayList<Space> arrayList = spaces;
            return arrayList;
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to getAllSpaces()", (Throwable)e);
            ArrayList<Space> arrayList = spaces;
            return arrayList;
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Space getSpaceByGroupId(String groupId) throws SpaceException {
        Session session = this.sessionManager.getOrOpenSession();
        Space space = null;
        try {
            Node foundNode = new QueryBuilder(session).select("exo:space").equal("exo:groupId", groupId).findNode();
            if (foundNode != null) {
                space = this.getSpaceFromNode(foundNode, session);
            } else {
                LOG.warn((Object)("Not found node with groupId: " + groupId));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to getSpaceByGroupId with groupId: " + groupId), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return space;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Space getSpaceById(String id) {
        Space cachedSpace = (Space)this.spaceCache.get((Serializable)((Object)id));
        if (cachedSpace != null) {
            return cachedSpace;
        }
        Session session = this.sessionManager.getOrOpenSession();
        try {
            Node spaceNode = session.getNodeByUUID(id);
            if (spaceNode != null) {
                Space space = this.getSpaceFromNode(spaceNode, session);
                return space;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to getSpaceById: " + id), (Throwable)e);
            Space space = null;
            return space;
        }
        finally {
            this.sessionManager.closeSession();
        }
        LOG.warn((Object)("No node found for space: " + id));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Space> getSpacesBySearchCondition(String condition) throws Exception {
        Session session = this.sessionManager.getOrOpenSession();
        ArrayList<Space> spaceList = new ArrayList();
        List spaceNodes = null;
        try {
            if (condition.length() != 0) {
                if (condition.indexOf("*") < 0) {
                    if (condition.charAt(0) != '*') {
                        condition = "*" + condition;
                    }
                    if (condition.charAt(condition.length() - 1) != '*') {
                        condition = condition + "*";
                    }
                }
                spaceNodes = new QueryBuilder(session).select("exo:space").contains("exo:name", condition).or().contains("exo:description", condition).exec();
            } else {
                spaceList = this.getAllSpaces();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to getSpacesBySearchCondition with condition: " + condition), (Throwable)e);
            ArrayList<Space> arrayList = spaceList;
            return arrayList;
        }
        finally {
            this.sessionManager.closeSession();
        }
        for (Node spaceNode : spaceNodes) {
            Space space = this.getSpaceFromNode(spaceNode, session);
            if (space == null) continue;
            spaceList.add(space);
        }
        return spaceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Space getSpaceByDisplayName(String spaceDisplayName) {
        Session session = this.sessionManager.getOrOpenSession();
        Space space = null;
        try {
            Node foundNode = new QueryBuilder(session).select("exo:space").equal("exo:name", spaceDisplayName).findNode();
            if (foundNode != null) {
                space = this.getSpaceFromNode(foundNode, session);
            } else {
                LOG.warn((Object)("Not found node: " + spaceDisplayName));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to getSpaceByDisplayName with displayName: " + spaceDisplayName), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return space;
    }

    public Space getSpaceByName(String spaceName) throws Exception {
        return this.getSpaceByPrettyName(spaceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Space getSpaceByPrettyName(String spacePrettyName) throws Exception {
        Session session = this.sessionManager.getOrOpenSession();
        Space space = null;
        try {
            Node foundNodeSpace = new QueryBuilder(session).select("exo:space").equal("exo:prettyName", spacePrettyName).findNode();
            if (foundNodeSpace != null) {
                space = this.getSpaceFromNode(foundNodeSpace, session);
            } else {
                LOG.warn((Object)("Node not found for spacePrettyName:  " + spacePrettyName));
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)("Failed to getSpaceByName: " + ex.getMessage()), (Throwable)ex);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return space;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Space getSpaceByUrl(String url) {
        Session session = this.sessionManager.getOrOpenSession();
        Space space = null;
        try {
            Node foundNode = new QueryBuilder(session).select("exo:space").equal("exo:url", url).findNode();
            if (foundNode != null) {
                space = this.getSpaceFromNode(foundNode, session);
            } else {
                LOG.warn((Object)("No node found for url: " + url));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to getSpaceByUrl: " + url), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return space;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSpace(String id) {
        Session session = this.sessionManager.getOrOpenSession();
        try {
            Node spaceNode = session.getNodeByUUID(id);
            if (spaceNode != null) {
                spaceNode.remove();
            } else {
                LOG.warn((Object)("Failed to find a spaceNode by its id: " + id));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to delete a space by its id: " + id), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSpace(Space space, boolean isNew) {
        try {
            Session session = this.sessionManager.getOrOpenSession();
            this.spaceHomeNode = this.getSpaceHomeNode(session);
            this.saveSpace(this.spaceHomeNode, space, isNew, session);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to saveSpace", (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSpace(Node spaceHomeNode, Space space, boolean isNew, Session session) {
        try {
            Node spaceNode;
            if (isNew) {
                spaceNode = spaceHomeNode.addNode("exo:space", "exo:space");
                spaceNode.addMixin("mix:referenceable");
            } else {
                spaceNode = session.getNodeByUUID(space.getId());
            }
            if (space.getId() == null) {
                space.setId(spaceNode.getUUID());
            }
            this.setNodeFromSpace(space, spaceNode);
            AvatarAttachment attachment = space.getAvatarAttachment();
            if (attachment != null) {
                ExtendedNode extNode = (ExtendedNode)spaceNode;
                if (extNode.canAddMixin("exo:privilegeable")) {
                    extNode.addMixin("exo:privilegeable");
                }
                String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
                extNode.setPermission(SystemIdentity.ANY, arrayPers);
                List permsList = extNode.getACL().getPermissionEntries();
                for (AccessControlEntry accessControlEntry : permsList) {
                    extNode.setPermission(accessControlEntry.getIdentity(), arrayPers);
                }
                if (attachment.getFileName() != null) {
                    Node nodeFile = null;
                    try {
                        nodeFile = spaceNode.getNode(IMAGE_PATH);
                    }
                    catch (PathNotFoundException ex) {
                        nodeFile = spaceNode.addNode(IMAGE_PATH, "nt:file");
                    }
                    Node nodeContent = null;
                    try {
                        nodeContent = nodeFile.getNode("jcr:content");
                    }
                    catch (PathNotFoundException ex) {
                        nodeContent = nodeFile.addNode("jcr:content", "nt:resource");
                    }
                    long lastModified = attachment.getLastModified();
                    long lastSaveTime = 0L;
                    if (nodeContent.hasProperty("jcr:lastModified")) {
                        lastSaveTime = nodeContent.getProperty("jcr:lastModified").getLong();
                    }
                    if (lastModified != 0L && lastModified != lastSaveTime) {
                        nodeContent.setProperty("jcr:mimeType", attachment.getMimeType());
                        nodeContent.setProperty("jcr:data", attachment.getInputStream(session));
                        nodeContent.setProperty("jcr:lastModified", attachment.getLastModified());
                    }
                }
            } else if (spaceNode.hasNode(IMAGE_PATH)) {
                spaceNode.getNode(IMAGE_PATH).remove();
                session.save();
            }
            if (isNew) {
                spaceHomeNode.save();
            } else {
                spaceNode.save();
                this.spaceCache.remove((Serializable)((Object)spaceNode.getUUID()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"failed to save space", (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    private void setNodeFromSpace(Space space, Node spaceNode) throws RepositoryException {
        spaceNode.setProperty("exo:name", space.getDisplayName());
        spaceNode.setProperty("exo:groupId", space.getGroupId());
        spaceNode.setProperty("exo:app", space.getApp());
        spaceNode.setProperty("exo:parent", space.getParent());
        spaceNode.setProperty("exo:description", space.getDescription());
        spaceNode.setProperty("exo:tag", space.getTag());
        spaceNode.setProperty("exo:pendingUsers", space.getPendingUsers());
        spaceNode.setProperty("exo:invitedUsers", space.getInvitedUsers());
        spaceNode.setProperty("exo:type", space.getType());
        spaceNode.setProperty("exo:url", space.getUrl());
        spaceNode.setProperty("exo:visibility", space.getVisibility());
        spaceNode.setProperty("exo:registration", space.getRegistration());
        spaceNode.setProperty("exo:priority", space.getPriority());
        spaceNode.setProperty("exo:prettyName", space.getPrettyName());
        spaceNode.setProperty("exo:avatarUrl", space.getAvatarUrl());
    }

    private Space getSpaceFromNode(Node spaceNode, Session session) throws Exception {
        Node image;
        String id = spaceNode.getUUID();
        Space space = (Space)this.spaceCache.get((Serializable)((Object)id));
        if (space != null) {
            return space;
        }
        space = new Space();
        space.setId(spaceNode.getUUID());
        PropertyIterator itr = spaceNode.getProperties(SPACE_PROPERTIES_NAME_PATTERN);
        while (itr.hasNext()) {
            Property p = itr.nextProperty();
            String propertyName = p.getName();
            if ("exo:name".equals(propertyName)) {
                space.setDisplayName(p.getString());
                continue;
            }
            if ("exo:groupId".equals(propertyName)) {
                space.setGroupId(p.getString());
                continue;
            }
            if ("exo:app".equals(propertyName)) {
                space.setApp(p.getString());
                continue;
            }
            if ("exo:parent".equals(propertyName)) {
                space.setParent(p.getString());
                continue;
            }
            if ("exo:description".equals(propertyName)) {
                space.setDescription(p.getString());
                continue;
            }
            if ("exo:tag".equals(propertyName)) {
                space.setTag(p.getString());
                continue;
            }
            if ("exo:pendingUsers".equals(propertyName)) {
                space.setPendingUsers(Util.convertValuesToStrings((Value[])p.getValues()));
                continue;
            }
            if ("exo:invitedUsers".equals(propertyName)) {
                space.setInvitedUsers(Util.convertValuesToStrings((Value[])p.getValues()));
                continue;
            }
            if ("exo:type".equals(propertyName)) {
                space.setType(p.getString());
                continue;
            }
            if ("exo:url".equals(propertyName)) {
                space.setUrl(p.getString());
                continue;
            }
            if ("exo:visibility".equals(propertyName)) {
                space.setVisibility(p.getString());
                continue;
            }
            if ("exo:registration".equals(propertyName)) {
                space.setRegistration(p.getString());
                continue;
            }
            if ("exo:priority".equals(propertyName)) {
                space.setPriority(p.getString());
                continue;
            }
            if ("exo:prettyName".equals(propertyName)) {
                space.setPrettyName(p.getString());
                continue;
            }
            if (!"exo:avatarUrl".equals(propertyName)) continue;
            space.setAvatarUrl(p.getString());
        }
        if (spaceNode.hasNode(IMAGE_PATH) && (image = spaceNode.getNode(IMAGE_PATH)).isNodeType("nt:file")) {
            AvatarAttachment file = new AvatarAttachment();
            file.setId(image.getPath());
            file.setMimeType(image.getNode("jcr:content").getProperty("jcr:mimeType").getString());
            try {
                file.setInputStream(image.getNode("jcr:content").getProperty("jcr:data").getValue().getStream());
            }
            catch (Exception ex) {
                LOG.warn((Object)"Failed to setInputStream in space", (Throwable)ex);
            }
            file.setFileName(image.getName());
            file.setLastModified(image.getNode("jcr:content").getProperty("jcr:lastModified").getLong());
            file.setWorkspace(session.getWorkspace().getName());
            space.setAvatarAttachment(file);
        }
        this.spaceCache.put((Serializable)((Object)id), (Object)space);
        return space;
    }

    private Node getSpaceHomeNode(Session session) throws Exception {
        if (this.spaceHomeNode == null) {
            String path = this.dataLocation.getSocialSpaceHome();
            this.spaceHomeNode = session.getRootNode().getNode(path);
        }
        return this.spaceHomeNode;
    }
}

